/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.colormanip;

import com.bc.ceres.swing.TableLayout;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import java.awt.event.ActionListener;
import java.text.DecimalFormat;
import javax.swing.AbstractButton;
import javax.swing.JButton;
import javax.swing.JFormattedTextField;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.text.NumberFormatter;
import org.esa.snap.core.datamodel.ColorPaletteDef;
import org.esa.snap.core.datamodel.ImageInfo;
import org.esa.snap.core.datamodel.ProductNodeEvent;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.Stx;
import org.esa.snap.core.util.math.Range;
import org.esa.snap.rcp.colormanip.ColorManipulationChildForm;
import org.esa.snap.rcp.colormanip.ColorManipulationForm;
import org.esa.snap.rcp.colormanip.ColorPaletteChooser;
import org.esa.snap.rcp.colormanip.ColorPaletteManager;
import org.esa.snap.rcp.colormanip.DiscreteCheckBox;
import org.esa.snap.rcp.colormanip.FormModel;
import org.esa.snap.rcp.colormanip.LogDisplay;
import org.esa.snap.rcp.colormanip.MoreOptionsForm;

class Continuous1BandBasicForm
implements ColorManipulationChildForm {
    private final ColorManipulationForm parentForm;
    private final JPanel contentPanel;
    private final AbstractButton logDisplayButton;
    private final MoreOptionsForm moreOptionsForm;
    private final ColorPaletteChooser colorPaletteChooser;
    private final JFormattedTextField minField;
    private final JFormattedTextField maxField;
    private final DiscreteCheckBox discreteCheckBox;
    private boolean shouldFireChooserEvent;
    private boolean hidden = false;

    Continuous1BandBasicForm(ColorManipulationForm parentForm) {
        ColorPaletteManager.getDefault().loadAvailableColorPalettes(parentForm.getIODir().toFile());
        this.parentForm = parentForm;
        TableLayout layout = new TableLayout();
        layout.setTableWeightX(Double.valueOf(1.0));
        layout.setTableWeightY(Double.valueOf(1.0));
        layout.setTablePadding(2, 2);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTableAnchor(TableLayout.Anchor.NORTH);
        layout.setCellPadding(0, 0, new Insets(8, 2, 2, 2));
        layout.setCellPadding(2, 0, new Insets(13, 2, 5, 2));
        JPanel editorPanel = new JPanel((LayoutManager)layout);
        editorPanel.add(new JLabel("Colour ramp:"));
        this.colorPaletteChooser = new ColorPaletteChooser();
        editorPanel.add(this.colorPaletteChooser);
        editorPanel.add(new JLabel("Display range"));
        this.minField = this.getNumberTextField(1.0E-5);
        this.maxField = this.getNumberTextField(1.0);
        JPanel minPanel = new JPanel(new BorderLayout(5, 2));
        minPanel.add((Component)new JLabel("Min:"), "West");
        minPanel.add((Component)this.minField, "South");
        JPanel maxPanel = new JPanel(new BorderLayout(5, 2));
        maxPanel.add((Component)new JLabel("Max:"), "East");
        maxPanel.add((Component)this.maxField, "South");
        JPanel minMaxPanel = new JPanel(new BorderLayout(5, 5));
        minMaxPanel.add((Component)minPanel, "West");
        minMaxPanel.add((Component)maxPanel, "East");
        editorPanel.add(minMaxPanel);
        JButton fromFile = new JButton("Range from File");
        JButton fromData = new JButton("Range from Data");
        JPanel buttonPanel = new JPanel(new BorderLayout(5, 10));
        buttonPanel.add((Component)fromFile, "West");
        buttonPanel.add((Component)fromData, "East");
        editorPanel.add(new JLabel(" "));
        editorPanel.add(buttonPanel);
        this.shouldFireChooserEvent = true;
        this.colorPaletteChooser.addActionListener(this.createListener(RangeKey.FromCurrentPalette));
        this.minField.addActionListener(this.createListener(RangeKey.FromMinMaxFields));
        this.maxField.addActionListener(this.createListener(RangeKey.FromMinMaxFields));
        fromFile.addActionListener(this.createListener(RangeKey.FromPaletteSource));
        fromData.addActionListener(this.createListener(RangeKey.FromData));
        this.contentPanel = new JPanel(new BorderLayout());
        this.contentPanel.add((Component)editorPanel, "North");
        this.moreOptionsForm = new MoreOptionsForm(this, parentForm.getFormModel().canUseHistogramMatching());
        this.discreteCheckBox = new DiscreteCheckBox(parentForm);
        this.moreOptionsForm.addRow(this.discreteCheckBox);
        parentForm.getFormModel().modifyMoreOptionsForm(this.moreOptionsForm);
        this.logDisplayButton = LogDisplay.createButton();
        this.logDisplayButton.addActionListener(e -> {
            boolean shouldLog10Display = this.logDisplayButton.isSelected();
            ImageInfo imageInfo = parentForm.getFormModel().getModifiedImageInfo();
            if (shouldLog10Display) {
                ColorPaletteDef cpd = imageInfo.getColorPaletteDef();
                if (LogDisplay.checkApplicability(cpd)) {
                    this.colorPaletteChooser.setLog10Display(true);
                    imageInfo.setLogScaled(true);
                    parentForm.applyChanges();
                } else {
                    LogDisplay.showNotApplicableInfo(parentForm.getContentPanel());
                    this.logDisplayButton.setSelected(false);
                }
            } else {
                this.colorPaletteChooser.setLog10Display(false);
                imageInfo.setLogScaled(false);
                parentForm.applyChanges();
            }
        });
    }

    @Override
    public Component getContentPanel() {
        return this.contentPanel;
    }

    @Override
    public ColorManipulationForm getParentForm() {
        return this.parentForm;
    }

    @Override
    public void handleFormShown(FormModel formModel) {
        this.hidden = false;
        this.updateFormModel(formModel);
    }

    @Override
    public void handleFormHidden(FormModel formModel) {
        this.hidden = true;
    }

    @Override
    public void updateFormModel(FormModel formModel) {
        if (!this.hidden) {
            ColorPaletteManager.getDefault().loadAvailableColorPalettes(this.parentForm.getIODir().toFile());
            this.colorPaletteChooser.reloadPalettes();
        }
        ImageInfo imageInfo = formModel.getOriginalImageInfo();
        ColorPaletteDef cpd = imageInfo.getColorPaletteDef();
        boolean logScaled = imageInfo.isLogScaled();
        boolean discrete = cpd.isDiscrete();
        this.colorPaletteChooser.setLog10Display(logScaled);
        this.colorPaletteChooser.setDiscreteDisplay(discrete);
        this.shouldFireChooserEvent = false;
        this.colorPaletteChooser.setSelectedColorPaletteDefinition(cpd);
        this.shouldFireChooserEvent = true;
        this.discreteCheckBox.setDiscreteColorsMode(discrete);
        this.logDisplayButton.setSelected(logScaled);
        this.parentForm.revalidateToolViewPaneControl();
        this.minField.setValue(cpd.getMinDisplaySample());
        this.maxField.setValue(cpd.getMaxDisplaySample());
    }

    @Override
    public void resetFormModel(FormModel formModel) {
        this.updateFormModel(formModel);
        this.parentForm.revalidateToolViewPaneControl();
    }

    @Override
    public void handleRasterPropertyChange(ProductNodeEvent event, RasterDataNode raster) {
        if (event.getPropertyName().equals("stx")) {
            this.updateFormModel(this.parentForm.getFormModel());
        }
    }

    @Override
    public RasterDataNode[] getRasters() {
        return this.parentForm.getFormModel().getRasters();
    }

    @Override
    public MoreOptionsForm getMoreOptionsForm() {
        return this.moreOptionsForm;
    }

    @Override
    public AbstractButton[] getToolButtons() {
        return new AbstractButton[]{this.logDisplayButton};
    }

    private ActionListener createListener(RangeKey key) {
        return e -> this.applyChanges(key);
    }

    private JFormattedTextField getNumberTextField(double value) {
        NumberFormatter formatter = new NumberFormatter(new DecimalFormat("0.0############"));
        formatter.setValueClass(Double.class);
        JFormattedTextField numberField = new JFormattedTextField(formatter);
        numberField.setValue(value);
        Dimension preferredSize = numberField.getPreferredSize();
        preferredSize.width = 70;
        numberField.setPreferredSize(preferredSize);
        return numberField;
    }

    private void applyChanges(RangeKey key) {
        if (this.shouldFireChooserEvent) {
            ColorPaletteDef cpd;
            double max;
            double min;
            ColorPaletteDef selectedCPD = this.colorPaletteChooser.getSelectedColorPaletteDefinition();
            ImageInfo currentInfo = this.parentForm.getFormModel().getModifiedImageInfo();
            ColorPaletteDef currentCPD = currentInfo.getColorPaletteDef();
            ColorPaletteDef deepCopy = selectedCPD.createDeepCopy();
            deepCopy.setDiscrete(currentCPD.isDiscrete());
            switch (key) {
                case FromPaletteSource: {
                    Range rangeFromFile = this.colorPaletteChooser.getRangeFromFile();
                    min = rangeFromFile.getMin();
                    max = rangeFromFile.getMax();
                    cpd = currentCPD;
                    break;
                }
                case FromData: {
                    Stx stx = this.parentForm.getStx(this.parentForm.getFormModel().getRaster());
                    min = stx.getMinimum();
                    max = stx.getMaximum();
                    cpd = currentCPD;
                    break;
                }
                case FromMinMaxFields: {
                    min = (Double)this.minField.getValue();
                    max = (Double)this.maxField.getValue();
                    cpd = currentCPD;
                    break;
                }
                default: {
                    min = currentCPD.getMinDisplaySample();
                    max = currentCPD.getMaxDisplaySample();
                    cpd = deepCopy;
                }
            }
            boolean autoDistribute = true;
            currentInfo.setColorPaletteDef(cpd, min, max, true);
            this.parentForm.applyChanges();
        }
    }

    private static enum RangeKey {
        FromPaletteSource,
        FromData,
        FromMinMaxFields,
        FromCurrentPalette;

    }
}

