/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.bandmaths;

import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.binding.ValueSet;
import com.bc.ceres.core.Assert;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyEditor;
import com.bc.ceres.swing.binding.PropertyEditorRegistry;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Window;
import java.beans.PropertyChangeListener;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.dataop.barithm.StandardUncertaintyGenerator;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.window.OpenImageViewAction;
import org.esa.snap.rcp.bandmaths.Bundle;
import org.esa.snap.rcp.bandmaths.ProductNodeNameValidator;
import org.esa.snap.rcp.nodes.UndoableProductNodeInsertion;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.GridBagUtils;
import org.esa.snap.ui.ModalDialog;
import org.openide.awt.UndoRedo;

public class PropagateUncertaintyDialog
extends ModalDialog {
    private static final String PROPERTY_NAME_BAND_NAME = "bandName";
    private static final String PROPERTY_NAME_ORDER = "order";
    private static final String PROPERTY_NAME_RELATION = "relation";
    private static final String ERROR_PREFIX = "Error: ";
    private final BindingContext bindingContext;
    private VirtualBand sourceBand;
    private String bandName;
    private int order;
    private String relation;
    private JTextArea sourceExprArea;
    private JTextArea targetExprArea;

    public PropagateUncertaintyDialog(VirtualBand virtualBand) {
        super((Window)SnapApp.getDefault().getMainFrame(), Bundle.CTL_PropagateUncertaintyDialog_Title(), 161, "propagateUncertainty");
        Assert.notNull((Object)virtualBand, (String)"virtualBand");
        this.sourceBand = virtualBand;
        this.bindingContext = this.createBindingContext();
        this.bandName = virtualBand.getName() + "_unc";
        this.order = 1;
        this.initUI();
    }

    protected void onOK() {
        String uncertaintyExpression = this.targetExprArea.getText();
        Product targetProduct = this.sourceBand.getProduct();
        int width = targetProduct.getSceneRasterWidth();
        int height = targetProduct.getSceneRasterHeight();
        ProductNodeGroup bandGroup = targetProduct.getBandGroup();
        VirtualBand uncertaintyBand = new VirtualBand(this.getBandName(), 30, width, height, uncertaintyExpression);
        uncertaintyBand.setDescription("Uncertainty propagated from band " + this.sourceBand.getName() + " = " + this.sourceBand.getExpression());
        uncertaintyBand.setUnit(this.sourceBand.getUnit());
        uncertaintyBand.setNoDataValue(Double.NaN);
        uncertaintyBand.setNoDataValueUsed(true);
        uncertaintyBand.setValidPixelExpression(this.sourceBand.getValidPixelExpression());
        ProductUtils.copySpectralBandProperties((Band)this.sourceBand, (Band)uncertaintyBand);
        bandGroup.add((ProductNode)uncertaintyBand);
        this.sourceBand.addAncillaryVariable((RasterDataNode)uncertaintyBand, new String[]{this.relation});
        UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(targetProduct);
        if (undoManager != null) {
            undoManager.addEdit(new UndoableProductNodeInsertion<VirtualBand>(bandGroup, uncertaintyBand));
        }
        this.hide();
        uncertaintyBand.setModified(true);
        if (SnapApp.getDefault().getPreferences().getBoolean("BandMaths.autoShowNewBands", true)) {
            OpenImageViewAction.openImageView((RasterDataNode)uncertaintyBand);
        }
    }

    private String generateUncertaintyExpression() throws ParseException, UnsupportedOperationException {
        StandardUncertaintyGenerator propagator = new StandardUncertaintyGenerator(this.order, false);
        return propagator.generateUncertainty(this.sourceBand.getProduct(), this.relation, this.sourceBand.getExpression());
    }

    protected boolean verifyUserInput() {
        String uncertaintyExpression = this.targetExprArea.getText();
        if (uncertaintyExpression == null || uncertaintyExpression.trim().isEmpty()) {
            Dialogs.showError("Uncertainty expression is empty.");
            return false;
        }
        if (uncertaintyExpression.startsWith(ERROR_PREFIX)) {
            Dialogs.showError(uncertaintyExpression.substring(ERROR_PREFIX.length()));
            return false;
        }
        if (this.sourceBand.getProduct().containsBand(this.getBandName())) {
            Dialogs.showError("A raster with name '" + this.getBandName() + "' already exists.");
            return false;
        }
        return super.verifyUserInput();
    }

    private void initUI() {
        JPanel panel = GridBagUtils.createPanel();
        int line = 0;
        GridBagConstraints gbc = new GridBagConstraints();
        this.sourceExprArea = new JTextArea(3, 40);
        this.sourceExprArea.setEditable(false);
        this.sourceExprArea.setEnabled(false);
        this.sourceExprArea.setText(this.sourceBand.getExpression());
        this.targetExprArea = new JTextArea(6, 40);
        this.targetExprArea.setEditable(true);
        this.updateTargetExprArea();
        JComboBox<String> comboBox = new JComboBox<String>(new String[]{"uncertainty", "standard_deviation", "error"});
        comboBox.setEditable(true);
        this.bindingContext.bind(PROPERTY_NAME_RELATION, comboBox);
        ++line;
        gbc.gridy = line++;
        JComponent[] components = this.createComponents(PROPERTY_NAME_BAND_NAME);
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[1], (GridBagConstraints)gbc, (String)"weightx=0, insets.right=3, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[0], (GridBagConstraints)gbc, (String)"weightx=1, insets.right=0, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        components = this.createComponents(PROPERTY_NAME_ORDER);
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[1], (GridBagConstraints)gbc, (String)"weightx=0, insets.right=3, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)panel, (Component)components[0], (GridBagConstraints)gbc, (String)"weightx=1, insets.right=0, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        PropertyDescriptor relationDescriptor = this.bindingContext.getPropertySet().getDescriptor(PROPERTY_NAME_RELATION);
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JLabel(relationDescriptor.getDisplayName() + ":"), (GridBagConstraints)gbc, (String)"weightx=0, insets.right=3, insets.top=3, gridwidth=1, fill=HORIZONTAL, anchor=WEST");
        GridBagUtils.addToPanel((JPanel)panel, comboBox, (GridBagConstraints)gbc, (String)"weightx=1, insets.right=0, insets.top=3, gridwidth=2, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JLabel("Source expression:"), (GridBagConstraints)gbc, (String)"weightx=1, insets.top=8, gridwidth=3, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JScrollPane(this.sourceExprArea), (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=3, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line++;
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JLabel("Uncertainty expression:"), (GridBagConstraints)gbc, (String)"weightx=1, insets.top=3, gridwidth=3, fill=HORIZONTAL, anchor=WEST");
        gbc.gridy = line;
        GridBagUtils.addToPanel((JPanel)panel, (Component)new JScrollPane(this.targetExprArea), (GridBagConstraints)gbc, (String)"weightx=1, weighty=1, insets.top=3, gridwidth=3, fill=BOTH, anchor=WEST");
        this.setContent(panel);
    }

    private void updateTargetExprArea() {
        try {
            String uncertaintyExpression = this.generateUncertaintyExpression();
            this.targetExprArea.setText(uncertaintyExpression);
        }
        catch (UnsupportedOperationException | ParseException e) {
            this.targetExprArea.setText(ERROR_PREFIX + e.getMessage());
        }
    }

    private JComponent[] createComponents(String propertyName) {
        PropertyDescriptor descriptor = this.bindingContext.getPropertySet().getDescriptor(propertyName);
        PropertyEditor propertyEditor = PropertyEditorRegistry.getInstance().findPropertyEditor(descriptor);
        return propertyEditor.createComponents(descriptor, this.bindingContext);
    }

    private BindingContext createBindingContext() {
        PropertyContainer container = PropertyContainer.createObjectBacked((Object)((Object)this));
        BindingContext context = new BindingContext((PropertySet)container);
        PropertyDescriptor descriptor = container.getDescriptor(PROPERTY_NAME_BAND_NAME);
        descriptor.setDisplayName("Uncertainty band name");
        descriptor.setDescription("The name for the new uncertainty band.");
        descriptor.setNotEmpty(true);
        descriptor.setValidator((Validator)new ProductNodeNameValidator(this.sourceBand.getProduct()));
        descriptor.setDefaultValue((Object)this.getDefaultBandName(this.sourceBand.getName() + "_unc"));
        descriptor = container.getDescriptor(PROPERTY_NAME_ORDER);
        descriptor.setDisplayName("Order of Taylor polynomial");
        descriptor.setDescription("The number of Taylor series expansion terms used for the Standard Combined Uncertainty (GUM 1995).");
        descriptor.setDefaultValue((Object)1);
        descriptor.setValueSet(new ValueSet((Object[])new Integer[]{1, 2, 3}));
        descriptor = container.getDescriptor(PROPERTY_NAME_RELATION);
        descriptor.setDisplayName("Relation name of ancillary bands");
        descriptor.setDescription("Relation  name of ancillary variables that represent uncertainties (NetCDF-U 'rel' attribute).");
        descriptor.setDefaultValue((Object)"uncertainty");
        descriptor.setNotNull(true);
        descriptor.setNotEmpty(true);
        container.setDefaultValues();
        PropertyChangeListener targetExprUpdater = evt -> this.updateTargetExprArea();
        context.addPropertyChangeListener(PROPERTY_NAME_ORDER, targetExprUpdater);
        context.addPropertyChangeListener(PROPERTY_NAME_RELATION, targetExprUpdater);
        return context;
    }

    private String getDefaultBandName(String nameBase) {
        String defaultName = nameBase;
        Product product = this.sourceBand.getProduct();
        int i = 0;
        while (product.getRasterDataNode(defaultName) != null) {
            defaultName = nameBase + ++i;
        }
        return defaultName;
    }

    private String getBandName() {
        return this.bandName.trim();
    }
}

