/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import com.bc.ceres.swing.figure.Figure;
import com.bc.ceres.swing.figure.FigureSelection;
import com.bc.ceres.swing.figure.support.DefaultFigureSelection;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.io.WKTWriter;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.vector.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.product.SimpleFeatureFigure;
import org.geotools.geometry.jts.GeometryCoordinateSequenceTransformer;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.MathTransform;
import org.opengis.referencing.operation.TransformException;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ShowGeometryWktAction
extends AbstractAction
implements LookupListener,
ContextAwareAction {
    private static final String DLG_TITLE = "WKT from Geometry";
    private Lookup.Result<FigureSelection> result;
    private Lookup lookup;

    public ShowGeometryWktAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ShowGeometryWktAction(Lookup lookup) {
        super(Bundle.CTL_ShowGeometryWktAction_MenuText());
        this.lookup = lookup;
        this.result = lookup.lookupResult(FigureSelection.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.exportToWkt();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new ShowGeometryWktAction(actionContext);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        FigureSelection selection = (FigureSelection)this.lookup.lookup(FigureSelection.class);
        this.setEnabled(selection != null);
    }

    private void exportToWkt() {
        Geometry targetGeom;
        SimpleFeatureFigure selectedFeatureFigure = this.getSimpleFeatureFigure();
        if (selectedFeatureFigure == null) {
            Dialogs.showInformation(DLG_TITLE, "Please select a geometry.", null);
            return;
        }
        SimpleFeature simpleFeature = selectedFeatureFigure.getSimpleFeature();
        CoordinateReferenceSystem sourceCrs = simpleFeature.getDefaultGeometryProperty().getDescriptor().getCoordinateReferenceSystem();
        DefaultGeographicCRS targetCrs = DefaultGeographicCRS.WGS84;
        Geometry sourceGeom = selectedFeatureFigure.getGeometry();
        try {
            targetGeom = this.transformGeometry(sourceGeom, sourceCrs, (CoordinateReferenceSystem)targetCrs);
        }
        catch (Exception e) {
            Dialogs.showWarning(DLG_TITLE, "Failed to transform geometry to " + targetCrs.getName() + ".\n" + "Using " + sourceCrs.getName() + " instead.", null);
            targetGeom = sourceGeom;
            targetCrs = sourceCrs;
        }
        WKTWriter wktWriter = new WKTWriter();
        wktWriter.setFormatted(true);
        wktWriter.setMaxCoordinatesPerLine(2);
        wktWriter.setTab(3);
        String wkt = wktWriter.writeFormatted(targetGeom);
        JTextArea textArea = new JTextArea(16, 32);
        textArea.setEditable(false);
        textArea.setText(wkt);
        textArea.selectAll();
        JPanel contentPanel = new JPanel(new BorderLayout(4, 4));
        contentPanel.add((Component)new JLabel("Geometry Well-Known-Text (WKT):"), "North");
        contentPanel.add((Component)new JScrollPane(textArea), "Center");
        contentPanel.add((Component)new JLabel("Geometry CRS: " + targetCrs.getName().toString()), "South");
        ModalDialog modalDialog = new ModalDialog((Window)SnapApp.getDefault().getMainFrame(), DLG_TITLE, 1, null);
        modalDialog.setContent((Component)contentPanel);
        modalDialog.center();
        modalDialog.show();
    }

    private SimpleFeatureFigure getSimpleFeatureFigure() {
        Figure[] figures;
        DefaultFigureSelection selection = (DefaultFigureSelection)this.lookup.lookup(DefaultFigureSelection.class);
        SimpleFeatureFigure selectedFeatureFigure = null;
        for (Figure figure : figures = selection.getFigures()) {
            if (!(figure instanceof SimpleFeatureFigure)) continue;
            selectedFeatureFigure = (SimpleFeatureFigure)figure;
        }
        return selectedFeatureFigure;
    }

    private Geometry transformGeometry(Geometry sourceGeom, CoordinateReferenceSystem sourceCrs, CoordinateReferenceSystem targetCrs) throws FactoryException, TransformException {
        MathTransform mt = CRS.findMathTransform((CoordinateReferenceSystem)sourceCrs, (CoordinateReferenceSystem)targetCrs, (boolean)true);
        GeometryCoordinateSequenceTransformer gcst = new GeometryCoordinateSequenceTransformer();
        gcst.setMathTransform(mt);
        return gcst.transform(sourceGeom);
    }
}

