/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.event.ActionEvent;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.util.EventListener;
import javax.swing.Action;
import org.esa.snap.core.dataio.geometry.VectorDataNodeReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.FeatureUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.vector.AbstractImportVectorDataNodeAction;
import org.esa.snap.rcp.actions.vector.Bundle;
import org.esa.snap.rcp.actions.vector.VectorDataNodeImporter;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ImportVectorDataNodeFromMermaidAction
extends AbstractImportVectorDataNodeAction
implements ContextAwareAction,
LookupListener {
    private Lookup lookup;
    private final Lookup.Result<Product> result;
    private VectorDataNodeImporter importer;
    private static final String vector_data_type = "CSV";

    public ImportVectorDataNodeFromMermaidAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ImportVectorDataNodeFromMermaidAction(Lookup lookup) {
        this.lookup = lookup;
        this.result = lookup.lookupResult(Product.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnableState();
        this.setHelpId(Bundle.CTL_ImportVectorDataNodeFromMermaidActionHelp());
        this.putValue("Name", Bundle.CTL_ImportVectorDataNodeFromMermaidActionText());
        this.putValue("ShortDescription", Bundle.CTL_ImportVectorDataNodeFromMermaidActionDescription());
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ImportVectorDataNodeFromMermaidAction(lookup);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnableState();
    }

    private void setEnableState() {
        boolean state = false;
        ProductNode productNode = (ProductNode)this.lookup.lookup(ProductNode.class);
        if (productNode != null) {
            Product product = productNode.getProduct();
            state = product != null && product.getSceneGeoCoding() != null;
        }
        this.setEnabled(state);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        SnapFileFilter filter = new SnapFileFilter(this.getVectorDataType(), new String[]{".txt", ".dat", ".csv"}, "Plain text");
        this.importer = new VectorDataNodeImporter(this.getHelpId(), filter, new MermaidReader(), "Import MERMAID Extraction File", "csv.io.dir");
        this.importer.importGeometry(SnapApp.getDefault());
    }

    @Override
    protected String getDialogTitle() {
        return this.importer.getDialogTitle();
    }

    @Override
    protected String getVectorDataType() {
        return vector_data_type;
    }

    private class MermaidReader
    implements VectorDataNodeImporter.VectorDataNodeReader {
        private MermaidReader() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public VectorDataNode readVectorDataNode(File file, Product product, ProgressMonitor pm) throws IOException {
            try (InputStreamReader reader = null;){
                CoordinateReferenceSystem modelCrs = product.getSceneCRS();
                reader = new FileReader(file);
                char delimiterChar = ';';
                VectorDataNode vectorDataNode = VectorDataNodeReader.read((String)file.getName(), (Reader)reader, (Product)product, (FeatureUtils.FeatureCrsProvider)ImportVectorDataNodeFromMermaidAction.this.crsProvider, (VectorDataNodeReader.PlacemarkDescriptorProvider)ImportVectorDataNodeFromMermaidAction.this.placemarkDescriptorProvider, (CoordinateReferenceSystem)modelCrs, (char)delimiterChar, (ProgressMonitor)pm);
                return vectorDataNode;
            }
        }
    }
}

