/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.vector;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerFilter;
import com.bc.ceres.glayer.support.LayerUtils;
import com.bc.ceres.swing.binding.PropertyPane;
import java.awt.Dimension;
import java.awt.Window;
import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JPanel;
import javax.swing.undo.UndoableEdit;
import org.esa.snap.core.datamodel.PlainFeatureFactory;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.vector.Bundle;
import org.esa.snap.rcp.nodes.UndoableProductNodeInsertion;
import org.esa.snap.ui.ModalDialog;
import org.esa.snap.ui.product.ProductSceneView;
import org.esa.snap.ui.product.VectorDataLayerFilterFactory;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.openide.awt.UndoRedo;
import org.openide.util.ContextAwareAction;
import org.openide.util.ImageUtilities;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class CreateVectorDataNodeAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private static final String HELP_ID = "vectorDataManagement";
    private static int numItems = 1;

    public CreateVectorDataNodeAction() {
        this(Utilities.actionsGlobalContext());
    }

    public CreateVectorDataNodeAction(Lookup lkp) {
        super(Bundle.CTL_CreateVectorDataNodeActionText());
        Lookup.Result result = lkp.lookupResult(Product.class);
        result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)result));
        this.putValue("SmallIcon", ImageUtilities.loadImageIcon((String)"org/esa/snap/rcp/icons/NewVectorDataNode24.gif", (boolean)false));
        this.setEnabled(false);
    }

    public static VectorDataNode createDefaultVectorDataNode(Product product) {
        return CreateVectorDataNodeAction.createDefaultVectorDataNode(product, CreateVectorDataNodeAction.getDefaultVectorDataNodeName(), "Default vector data container for geometries (automatically created)");
    }

    public static VectorDataNode createDefaultVectorDataNode(Product product, String name, String description) {
        CoordinateReferenceSystem modelCrs = product.getSceneCRS();
        SimpleFeatureType type = PlainFeatureFactory.createDefaultFeatureType((CoordinateReferenceSystem)modelCrs);
        VectorDataNode vectorDataNode = new VectorDataNode(name, type);
        vectorDataNode.setDescription(description);
        product.getVectorDataGroup().add((ProductNode)vectorDataNode);
        vectorDataNode.getPlacemarkGroup();
        String oldLayerId = CreateVectorDataNodeAction.selectVectorDataLayer(vectorDataNode);
        UndoRedo.Manager undoManager = SnapApp.getDefault().getUndoManager(product);
        if (undoManager != null) {
            undoManager.addEdit((UndoableEdit)new UndoableVectorDataNodeInsertion(product, vectorDataNode, oldLayerId));
        }
        return vectorDataNode;
    }

    private static String selectVectorDataLayer(VectorDataNode vectorDataNode) {
        Layer oldLayer = null;
        ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
        if (sceneView != null) {
            oldLayer = sceneView.getSelectedLayer();
            sceneView.selectVectorDataLayer(vectorDataNode);
            LayerFilter nodeFilter = VectorDataLayerFilterFactory.createNodeFilter((VectorDataNode)vectorDataNode);
            Layer newSelectedLayer = LayerUtils.getChildLayer((Layer)sceneView.getRootLayer(), (LayerUtils.SearchMode)LayerUtils.SEARCH_DEEP, (LayerFilter)nodeFilter);
            if (newSelectedLayer != null) {
                newSelectedLayer.setVisible(true);
            }
        }
        return oldLayer != null ? oldLayer.getId() : null;
    }

    public static String getDefaultVectorDataNodeName() {
        return "geometry";
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new CreateVectorDataNodeAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        Product[] products = SnapApp.getDefault().getProductManager().getProducts();
        this.setEnabled(products.length > 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Product product = SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.AUTO);
        if (product != null) {
            DialogData dialogData = new DialogData(product.getVectorDataGroup());
            PropertyContainer propertySet = PropertyContainer.createObjectBacked((Object)dialogData);
            propertySet.getDescriptor("name").setNotNull(true);
            propertySet.getDescriptor("name").setNotEmpty(true);
            propertySet.getDescriptor("name").setValidator((Validator)new NameValidator(product));
            propertySet.getDescriptor("description").setNotNull(true);
            PropertyPane propertyPane = new PropertyPane((PropertySet)propertySet);
            JPanel panel = propertyPane.createPanel();
            panel.setPreferredSize(new Dimension(400, 100));
            MyModalDialog dialog = new MyModalDialog(propertyPane);
            dialog.setContent(panel);
            int i = dialog.show();
            if (i == 1) {
                CreateVectorDataNodeAction.createDefaultVectorDataNode(product, dialogData.name, dialogData.description);
            }
        }
    }

    private static class UndoableVectorDataNodeInsertion
    extends UndoableProductNodeInsertion<VectorDataNode> {
        private String oldLayerId;

        public UndoableVectorDataNodeInsertion(Product product, VectorDataNode vectorDataNode, String oldLayerId) {
            super(product.getVectorDataGroup(), vectorDataNode);
            this.oldLayerId = oldLayerId;
        }

        private static String getSelectedLayerId() {
            Layer selectedLayer;
            ProductSceneView sceneView = SnapApp.getDefault().getSelectedProductSceneView();
            if (sceneView != null && (selectedLayer = sceneView.getSelectedLayer()) != null) {
                return selectedLayer.getId();
            }
            return null;
        }

        @Override
        public void undo() {
            super.undo();
            this.setSelectedLayer(this.oldLayerId);
        }

        @Override
        public void redo() {
            this.oldLayerId = UndoableVectorDataNodeInsertion.getSelectedLayerId();
            super.redo();
            CreateVectorDataNodeAction.selectVectorDataLayer((VectorDataNode)this.getProductNode());
        }

        private void setSelectedLayer(String layerId) {
            Layer layer;
            ProductSceneView sceneView;
            if (layerId != null && (sceneView = SnapApp.getDefault().getSelectedProductSceneView()) != null && (layer = LayerUtils.getChildLayerById((Layer)sceneView.getRootLayer(), (String)layerId)) != null) {
                sceneView.setSelectedLayer(layer);
            }
        }
    }

    private static class DialogData {
        private String name;
        private String description;

        private DialogData(ProductNodeGroup<VectorDataNode> vectorGroup) {
            String defaultPrefix = CreateVectorDataNodeAction.getDefaultVectorDataNodeName() + "_";
            this.name = defaultPrefix + numItems++;
            while (vectorGroup.contains(this.name)) {
                this.name = defaultPrefix + numItems++;
            }
            this.description = "";
        }
    }

    private static class MyModalDialog
    extends ModalDialog {
        private final PropertyPane propertyPane;

        private MyModalDialog(PropertyPane propertyPane) {
            super((Window)SnapApp.getDefault().getMainFrame(), Bundle.CTL_CreateVectorDataNodeActionText(), 161, CreateVectorDataNodeAction.HELP_ID);
            this.propertyPane = propertyPane;
        }

        protected boolean verifyUserInput() {
            return !this.propertyPane.getBindingContext().hasProblems();
        }
    }

    private static class NameValidator
    implements Validator {
        private final Product product;

        private NameValidator(Product product) {
            this.product = product;
        }

        public void validateValue(Property property, Object value) throws ValidationException {
            String name = (String)value;
            if (this.product.getVectorDataGroup().contains(name)) {
                String pattern = "A vector data container with name ''{0}'' already exists.\nPlease choose another one.";
                throw new ValidationException(MessageFormat.format("A vector data container with name ''{0}'' already exists.\nPlease choose another one.", name));
            }
        }
    }
}

