/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.layer.overlay;

import com.bc.ceres.glayer.Layer;
import com.bc.ceres.glayer.LayerListener;
import com.bc.ceres.glayer.support.AbstractLayerListener;
import java.awt.Component;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JToggleButton;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.SelectionSupport;
import org.esa.snap.ui.product.ProductSceneView;
import org.netbeans.api.annotations.common.NullAllowed;
import org.openide.util.actions.Presenter;

public abstract class AbstractOverlayAction
extends AbstractAction
implements Presenter.Toolbar,
Presenter.Menu,
Presenter.Popup,
SelectionSupport.Handler<ProductSceneView> {
    private final AbstractLayerListener layerListener = new AbstractLayerListener(){

        public void handleLayersAdded(Layer parentLayer, Layer[] childLayers) {
            AbstractOverlayAction.this.updateActionState();
        }

        public void handleLayersRemoved(Layer parentLayer, Layer[] childLayers) {
            AbstractOverlayAction.this.updateActionState();
        }
    };

    protected AbstractOverlayAction() {
        SnapApp.getDefault().getSelectionSupport(ProductSceneView.class).addHandler(this);
        this.initActionProperties();
        this.updateActionState();
    }

    protected void updateActionState() {
        ProductSceneView view = this.getSelectedProductSceneView();
        if (view != null) {
            this.setEnabled(this.getActionEnabledState(view));
            this.setSelected(this.getActionSelectionState(view));
        } else {
            this.setEnabled(false);
            this.setSelected(false);
        }
    }

    @Override
    public void selectionChange(@NullAllowed ProductSceneView oldValue, @NullAllowed ProductSceneView newValue) {
        if (oldValue != null) {
            oldValue.getRootLayer().removeListener((LayerListener)this.layerListener);
        }
        if (newValue != null) {
            newValue.getRootLayer().addListener((LayerListener)this.layerListener);
        }
        this.updateActionState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.setOverlayEnableState(this.getSelectedProductSceneView());
        this.updateActionState();
    }

    public JMenuItem getMenuPresenter() {
        JCheckBoxMenuItem menuItem = new JCheckBoxMenuItem(this);
        menuItem.setIcon(null);
        return menuItem;
    }

    public JMenuItem getPopupPresenter() {
        return this.getMenuPresenter();
    }

    public Component getToolbarPresenter() {
        JToggleButton toggleButton = new JToggleButton(this);
        toggleButton.setText(null);
        return toggleButton;
    }

    protected abstract void initActionProperties();

    protected abstract boolean getActionSelectionState(ProductSceneView var1);

    protected abstract boolean getActionEnabledState(ProductSceneView var1);

    protected abstract void setOverlayEnableState(ProductSceneView var1);

    protected ProductSceneView getSelectedProductSceneView() {
        return SnapApp.getDefault().getSelectedProductSceneView();
    }

    protected boolean isSelected() {
        return Boolean.TRUE.equals(this.getValue("SwingSelectedKey"));
    }

    private void setSelected(boolean selected) {
        this.putValue("SwingSelectedKey", selected);
    }
}

