/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import com.bc.ceres.core.ProgressMonitor;
import com.bc.ceres.swing.progress.ProgressMonitorSwingWorker;
import com.sun.media.jai.codec.ImageCodec;
import com.sun.media.jai.codec.ImageEncoder;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.OutputStream;
import java.util.EventListener;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.JComponent;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.ImageLegend;
import org.esa.snap.core.datamodel.MapGeoCoding;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkGroup;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.dataop.maptransf.MapTransformDescriptor;
import org.esa.snap.core.util.Debug;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.Bundle;
import org.esa.snap.rcp.actions.file.export.ExportImageAction;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.runtime.Config;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.product.ProductSceneView;
import org.geotools.referencing.CRS;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.openide.util.ContextAwareAction;
import org.openide.util.HelpCtx;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportKmzFileAction
extends AbstractAction
implements HelpCtx.Provider,
ContextAwareAction,
LookupListener {
    private static final String OVERLAY_KML = "overlay.kml";
    private static final String OVERLAY_PNG = "overlay.png";
    private static final String IMAGE_TYPE = "PNG";
    private static final String LEGEND_PNG = "legend.png";
    private static final String[] KMZ_FORMAT_DESCRIPTION = new String[]{"KMZ", "kmz", "KMZ - Google Earth File Format"};
    private static final String IMAGE_EXPORT_DIR_PREFERENCES_KEY = "user.image.export.dir";
    private static final String HELP_ID = "exportKmzFile";
    private final Lookup.Result<ProductSceneView> result;

    public ExportKmzFileAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportKmzFileAction(Lookup lookup) {
        super(Bundle.CTL_ExportKmzFileAction_MenuText());
        this.putValue("popupText", Bundle.CTL_ExportKmzFileAction_PopupText());
        this.result = lookup.lookupResult(ProductSceneView.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        ProductSceneView view = SnapApp.getDefault().getSelectedProductSceneView();
        GeoCoding geoCoding = view.getProduct().getSceneGeoCoding();
        boolean isGeographic = false;
        if (geoCoding instanceof MapGeoCoding) {
            MapGeoCoding mapGeoCoding = (MapGeoCoding)geoCoding;
            MapTransformDescriptor transformDescriptor = mapGeoCoding.getMapInfo().getMapProjection().getMapTransform().getDescriptor();
            String typeID = transformDescriptor.getTypeID();
            if (typeID.equals("Identity")) {
                isGeographic = true;
            }
        } else if (geoCoding instanceof CrsGeoCoding) {
            isGeographic = CRS.equalsIgnoreMetadata((Object)geoCoding.getMapCRS(), (Object)DefaultGeographicCRS.WGS84);
        }
        if (isGeographic) {
            this.exportImage(view);
        } else {
            String message = "Product must be in ''Geographic Lat/Lon'' projection.";
            Dialogs.showInformation(message, null);
        }
    }

    public HelpCtx getHelpCtx() {
        return new HelpCtx(HELP_ID);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ExportKmzFileAction(lookup);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnabled(SnapApp.getDefault().getSelectedProductSceneView() != null);
    }

    private void exportImage(ProductSceneView sceneView) {
        SnapApp snapApp = SnapApp.getDefault();
        String lastDir = Config.instance().load().preferences().get(IMAGE_EXPORT_DIR_PREFERENCES_KEY, SystemUtils.getUserHomeDir().getPath());
        File currentDir = new File(lastDir);
        SnapFileChooser fileChooser = new SnapFileChooser();
        HelpCtx.setHelpIDString((JComponent)fileChooser, (String)this.getHelpCtx().getHelpID());
        SnapFileFilter kmzFileFilter = new SnapFileFilter(KMZ_FORMAT_DESCRIPTION[0], KMZ_FORMAT_DESCRIPTION[1], KMZ_FORMAT_DESCRIPTION[2]);
        fileChooser.setCurrentDirectory(currentDir);
        fileChooser.addChoosableFileFilter((FileFilter)kmzFileFilter);
        fileChooser.setAcceptAllFileFilterUsed(false);
        fileChooser.setDialogTitle(snapApp.getInstanceName() + " - " + "export KMZ");
        String currentFilename = sceneView.isRGB() ? "RGB" : sceneView.getRaster().getName();
        fileChooser.setCurrentFilename(currentFilename);
        fileChooser.setFileSelectionMode(0);
        Dimension fileChooserSize = fileChooser.getPreferredSize();
        if (fileChooserSize != null) {
            fileChooser.setPreferredSize(new Dimension(fileChooserSize.width + 120, fileChooserSize.height));
        } else {
            fileChooser.setPreferredSize(new Dimension(512, 256));
        }
        int result = fileChooser.showSaveDialog((Component)snapApp.getMainFrame());
        File file = fileChooser.getSelectedFile();
        fileChooser.addPropertyChangeListener(evt -> Debug.trace((String)evt.toString()));
        File currentDirectory = fileChooser.getCurrentDirectory();
        if (currentDirectory != null) {
            Config.instance().load().preferences().get(IMAGE_EXPORT_DIR_PREFERENCES_KEY, currentDirectory.getPath());
        }
        if (result != 0) {
            return;
        }
        if (file == null || file.getName().isEmpty()) {
            return;
        }
        if (!Dialogs.requestOverwriteDecision("h", file).booleanValue()) {
            return;
        }
        SaveKMLSwingWorker worker = new SaveKMLSwingWorker(snapApp, "Save KMZ", sceneView, file);
        worker.executeWithBlocking();
    }

    private static RenderedImage createImageLegend(RasterDataNode raster) {
        ImageLegend imageLegend = ExportKmzFileAction.initImageLegend(raster);
        return imageLegend.createImage();
    }

    private static String formatKML(ProductSceneView view, String imageName) {
        String description;
        String name;
        Placemark[] pins;
        RasterDataNode raster = view.getRaster();
        Product product = raster.getProduct();
        GeoCoding geoCoding = raster.getGeoCoding();
        PixelPos upperLeftPP = new PixelPos(0.0, 0.0);
        PixelPos lowerRightPP = new PixelPos((double)product.getSceneRasterWidth(), (double)product.getSceneRasterHeight());
        GeoPos upperLeftGP = geoCoding.getGeoPos(upperLeftPP, null);
        GeoPos lowerRightGP = geoCoding.getGeoPos(lowerRightPP, null);
        double eastLon = lowerRightGP.getLon();
        if (geoCoding.isCrossingMeridianAt180()) {
            eastLon += 360.0;
        }
        String pinKml = "";
        PlacemarkGroup pinGroup = product.getPinGroup();
        for (Placemark placemark : pins = (Placemark[])pinGroup.toArray((ProductNode[])new Placemark[pinGroup.getNodeCount()])) {
            GeoPos geoPos = placemark.getGeoPos();
            if (geoPos == null || !product.containsPixel(placemark.getPixelPos())) continue;
            pinKml = pinKml + String.format("<Placemark>\n  <name>%s</name>\n  <Point>\n    <coordinates>%f,%f,0</coordinates>\n  </Point>\n</Placemark>\n", placemark.getLabel(), geoPos.lon, geoPos.lat);
        }
        String legendKml = "";
        if (view.isRGB()) {
            name = "RGB";
            description = view.getSceneName() + "\n" + product.getName();
        } else {
            name = raster.getName();
            description = raster.getDescription() + "\n" + product.getName();
            legendKml = "  <ScreenOverlay>\n    <name>Legend</name>\n    <Icon>\n      <href>legend.png</href>\n    </Icon>\n    <overlayXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\" />\n    <screenXY x=\"0\" y=\"1\" xunits=\"fraction\" yunits=\"fraction\" />\n  </ScreenOverlay>\n";
        }
        return "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<kml xmlns=\"http://earth.google.com/kml/2.0\">\n<Document>\n  <name>" + name + "</name>\n" + "  <description>" + description + "</description>\n" + "  <GroundOverlay>\n" + "    <name>Raster data</name>\n" + "    <LatLonBox>\n" + "      <north>" + upperLeftGP.getLat() + "</north>\n" + "      <south>" + lowerRightGP.getLat() + "</south>\n" + "      <east>" + eastLon + "</east>\n" + "      <west>" + upperLeftGP.getLon() + "</west>\n" + "    </LatLonBox>\n" + "    <Icon>\n" + "      <href>" + imageName + "</href>\n" + "    </Icon>\n" + "  </GroundOverlay>\n" + legendKml + pinKml + "</Document>\n" + "</kml>\n";
    }

    private static ImageLegend initImageLegend(RasterDataNode raster) {
        ImageLegend imageLegend = new ImageLegend(raster.getImageInfo(), raster);
        imageLegend.setHeaderText(ExportKmzFileAction.getLegendHeaderText(raster));
        imageLegend.setOrientation(1);
        imageLegend.setBackgroundTransparency(0.0f);
        imageLegend.setBackgroundTransparencyEnabled(true);
        imageLegend.setAntialiasing(true);
        return imageLegend;
    }

    private static String getLegendHeaderText(RasterDataNode raster) {
        String unit = raster.getUnit() != null ? raster.getUnit() : "-";
        unit = unit.replace('*', ' ');
        return "(" + unit + ")";
    }

    private static class SaveKMLSwingWorker
    extends ProgressMonitorSwingWorker {
        private final SnapApp snapApp;
        private final ProductSceneView view;
        private final File file;

        SaveKMLSwingWorker(SnapApp snapApp, String message, ProductSceneView view, File file) {
            super((Component)snapApp.getMainFrame(), message);
            this.snapApp = snapApp;
            this.view = view;
            this.file = file;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Object doInBackground(ProgressMonitor pm) throws Exception {
            try {
                String message = String.format("Saving image as %s...", this.file.getPath());
                pm.beginTask(message, this.view.isRGB() ? 4 : 3);
                this.snapApp.setStatusBarMessage(message);
                this.snapApp.getMainFrame().setCursor(Cursor.getPredefinedCursor(3));
                Dimension dimension = new Dimension(this.view.getProduct().getSceneRasterWidth(), this.view.getProduct().getSceneRasterHeight());
                RenderedImage image = ExportImageAction.createImage(this.view, true, dimension, true, true);
                pm.worked(1);
                try (ZipOutputStream outStream = new ZipOutputStream(new FileOutputStream(this.file));){
                    outStream.putNextEntry(new ZipEntry(ExportKmzFileAction.OVERLAY_KML));
                    String kmlContent = ExportKmzFileAction.formatKML(this.view, ExportKmzFileAction.OVERLAY_PNG);
                    outStream.write(kmlContent.getBytes());
                    pm.worked(1);
                    outStream.putNextEntry(new ZipEntry(ExportKmzFileAction.OVERLAY_PNG));
                    ImageEncoder encoder = ImageCodec.createImageEncoder((String)ExportKmzFileAction.IMAGE_TYPE, (OutputStream)outStream, null);
                    encoder.encode(image);
                    pm.worked(1);
                    if (!this.view.isRGB()) {
                        outStream.putNextEntry(new ZipEntry(ExportKmzFileAction.LEGEND_PNG));
                        encoder = ImageCodec.createImageEncoder((String)ExportKmzFileAction.IMAGE_TYPE, (OutputStream)outStream, null);
                        encoder.encode(ExportKmzFileAction.createImageLegend(this.view.getRaster()));
                        pm.worked(1);
                    }
                }
            }
            catch (OutOfMemoryError ignored) {
                Dialogs.showOutOfMemoryError("The image could not be exported.");
            }
            catch (Throwable e) {
                this.snapApp.handleError("The Image could not be exported", e);
            }
            finally {
                this.snapApp.getMainFrame().setCursor(Cursor.getDefaultCursor());
                this.snapApp.setStatusBarMessage("");
                pm.done();
            }
            return null;
        }
    }
}

