/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file.export;

import com.bc.ceres.binding.Converter;
import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyContainer;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.PropertySet;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import com.bc.ceres.binding.converters.IntegerConverter;
import com.bc.ceres.glayer.support.ImageLayer;
import com.bc.ceres.grender.Rendering;
import com.bc.ceres.grender.Viewport;
import com.bc.ceres.grender.support.BufferedImageRendering;
import com.bc.ceres.grender.support.DefaultViewport;
import com.bc.ceres.swing.binding.BindingContext;
import com.bc.ceres.swing.binding.PropertyPane;
import java.awt.Dimension;
import java.awt.Graphics2D;
import java.awt.GridLayout;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.geom.AffineTransform;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.awt.geom.RectangularShape;
import java.awt.image.BufferedImage;
import java.awt.image.RenderedImage;
import java.util.EventListener;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.BoxLayout;
import javax.swing.ButtonGroup;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.export.AbstractExportImageAction;
import org.esa.snap.rcp.actions.file.export.Bundle;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.SnapFileChooser;
import org.esa.snap.ui.product.ProductSceneView;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class ExportImageAction
extends AbstractExportImageAction {
    private static final String[][] SCENE_IMAGE_FORMAT_DESCRIPTIONS = new String[][]{BMP_FORMAT_DESCRIPTION, PNG_FORMAT_DESCRIPTION, JPEG_FORMAT_DESCRIPTION, TIFF_FORMAT_DESCRIPTION, GEOTIFF_FORMAT_DESCRIPTION};
    private static final String HELP_ID = "exportImageFile";
    private SnapFileFilter[] sceneImageFileFilters;
    private JRadioButton buttonFullScene;
    private SizeComponent sizeComponent;
    private Lookup.Result<ProductSceneView> result;

    public ExportImageAction() {
        this(Utilities.actionsGlobalContext());
    }

    public ExportImageAction(Lookup lookup) {
        super(Bundle.CTL_ExportImageAction_MenuText(), HELP_ID);
        this.putValue("popupText", Bundle.CTL_ExportImageAction_PopupText());
        this.sceneImageFileFilters = new SnapFileFilter[SCENE_IMAGE_FORMAT_DESCRIPTIONS.length];
        for (int i = 0; i < SCENE_IMAGE_FORMAT_DESCRIPTIONS.length; ++i) {
            this.sceneImageFileFilters[i] = ExportImageAction.createFileFilter(SCENE_IMAGE_FORMAT_DESCRIPTIONS[i]);
        }
        this.result = lookup.lookupResult(ProductSceneView.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    @Override
    public void actionPerformed(ActionEvent event) {
        this.exportImage(this.sceneImageFileFilters);
    }

    public Action createContextAwareInstance(Lookup lookup) {
        return new ExportImageAction(lookup);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnabled(SnapApp.getDefault().getSelectedProductSceneView() != null);
    }

    @Override
    protected void configureFileChooser(SnapFileChooser fileChooser, ProductSceneView view, String imageBaseName) {
        fileChooser.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - " + "export Image");
        if (view.isRGB()) {
            fileChooser.setCurrentFilename(imageBaseName + "_RGB");
        } else {
            fileChooser.setCurrentFilename(imageBaseName + "_" + view.getRaster().getName());
        }
        JPanel regionPanel = new JPanel(new GridLayout(2, 1));
        regionPanel.setBorder(BorderFactory.createTitledBorder("Image Region"));
        this.buttonFullScene = new JRadioButton("Full scene", false);
        JRadioButton buttonVisibleRegion = new JRadioButton("Visible region", true);
        ButtonGroup buttonGroup = new ButtonGroup();
        buttonGroup.add(buttonVisibleRegion);
        buttonGroup.add(this.buttonFullScene);
        regionPanel.add(buttonVisibleRegion);
        regionPanel.add(this.buttonFullScene);
        this.sizeComponent = new SizeComponent(view);
        JComponent sizePanel = this.sizeComponent.createComponent();
        sizePanel.setBorder(BorderFactory.createTitledBorder("Image Dimension"));
        JPanel accessory = new JPanel();
        accessory.setLayout(new BoxLayout(accessory, 1));
        accessory.add(regionPanel);
        accessory.add(sizePanel);
        fileChooser.setAccessory((JComponent)accessory);
        this.buttonFullScene.addActionListener(e -> this.sizeComponent.updateDimensions());
        buttonVisibleRegion.addActionListener(e -> this.sizeComponent.updateDimensions());
    }

    @Override
    protected RenderedImage createImage(String imageFormat, ProductSceneView view) {
        boolean useAlpha = !BMP_FORMAT_DESCRIPTION[0].equals(imageFormat) && !JPEG_FORMAT_DESCRIPTION[0].equals(imageFormat);
        boolean entireImage = this.isEntireImageSelected();
        return ExportImageAction.createImage(view, entireImage, this.sizeComponent.getDimension(), useAlpha, GEOTIFF_FORMAT_DESCRIPTION[0].equals(imageFormat));
    }

    static RenderedImage createImage(ProductSceneView view, boolean fullScene, Dimension dimension, boolean alphaChannel, boolean geoReferenced) {
        int imageType = alphaChannel ? 6 : 5;
        BufferedImage bufferedImage = new BufferedImage(dimension.width, dimension.height, imageType);
        BufferedImageRendering imageRendering = ExportImageAction.createRendering(view, fullScene, geoReferenced, bufferedImage);
        if (!alphaChannel) {
            Graphics2D graphics = imageRendering.getGraphics();
            graphics.setColor(view.getLayerCanvas().getBackground());
            graphics.fillRect(0, 0, dimension.width, dimension.height);
        }
        view.getRootLayer().render((Rendering)imageRendering);
        return bufferedImage;
    }

    private static BufferedImageRendering createRendering(ProductSceneView view, boolean fullScene, boolean geoReferenced, BufferedImage bufferedImage) {
        Viewport vp1 = view.getLayerCanvas().getViewport();
        DefaultViewport vp2 = new DefaultViewport(new Rectangle(bufferedImage.getWidth(), bufferedImage.getHeight()), vp1.isModelYAxisDown());
        if (fullScene) {
            vp2.zoom(view.getBaseImageLayer().getModelBounds());
        } else {
            ExportImageAction.setTransform(vp1, (Viewport)vp2);
        }
        BufferedImageRendering imageRendering = new BufferedImageRendering(bufferedImage, (Viewport)vp2);
        if (geoReferenced) {
            AffineTransform m2iTransform = view.getBaseImageLayer().getModelToImageTransform(0);
            AffineTransform v2mTransform = vp2.getViewToModelTransform();
            v2mTransform.preConcatenate(m2iTransform);
            AffineTransform v2iTransform = new AffineTransform(v2mTransform);
            Graphics2D graphics2D = imageRendering.getGraphics();
            v2iTransform.concatenate(graphics2D.getTransform());
            graphics2D.setTransform(v2iTransform);
        }
        return imageRendering;
    }

    private static void setTransform(Viewport vp1, Viewport vp2) {
        vp2.setTransform(vp1);
        Rectangle rectangle1 = vp1.getViewBounds();
        Rectangle rectangle2 = vp2.getViewBounds();
        double w1 = rectangle1.getWidth();
        double w2 = rectangle2.getWidth();
        double h1 = rectangle1.getHeight();
        double h2 = rectangle2.getHeight();
        double x1 = rectangle1.getX();
        double y1 = rectangle1.getY();
        double cx = (x1 + w1) / 2.0;
        double cy = (y1 + h1) / 2.0;
        double magnification = w1 > h1 ? w2 / w1 : h2 / h1;
        Point2D modelCenter = vp1.getViewToModelTransform().transform(new Point2D.Double(cx, cy), null);
        double zoomFactor = vp1.getZoomFactor() * magnification;
        if (zoomFactor > 0.0) {
            vp2.setZoomFactor(zoomFactor, modelCenter.getX(), modelCenter.getY());
        }
    }

    @Override
    protected boolean isEntireImageSelected() {
        return this.buttonFullScene.isSelected();
    }

    private class SizeComponent {
        private static final String PROPERTY_NAME_HEIGHT = "height";
        private static final String PROPERTY_NAME_WIDTH = "width";
        private final PropertyContainer propertyContainer;
        private final ProductSceneView view;

        public SizeComponent(ProductSceneView view) {
            this.view = view;
            this.propertyContainer = new PropertyContainer();
            this.initValueContainer();
            this.updateDimensions();
        }

        public void updateDimensions() {
            Rectangle2D bounds;
            if (ExportImageAction.this.isEntireImageSelected()) {
                ImageLayer imageLayer = this.view.getBaseImageLayer();
                Rectangle2D modelBounds = imageLayer.getModelBounds();
                Rectangle2D imageBounds = imageLayer.getModelToImageTransform().createTransformedShape(modelBounds).getBounds2D();
                double mScale = modelBounds.getWidth() / modelBounds.getHeight();
                double iScale = imageBounds.getHeight() / imageBounds.getWidth();
                double scaleFactorX = mScale * iScale;
                bounds = new Rectangle2D.Double(0.0, 0.0, scaleFactorX * imageBounds.getWidth(), 1.0 * imageBounds.getHeight());
            } else {
                bounds = this.view.getLayerCanvas().getViewport().getViewBounds();
            }
            int w = this.toInteger(((RectangularShape)bounds).getWidth());
            int h = this.toInteger(((RectangularShape)bounds).getHeight());
            long freeMemory = this.getFreeMemory();
            long expectedMemory = this.getExpectedMemory(w, h);
            if (freeMemory < expectedMemory && this.showQuestionDialog() != Dialogs.Answer.YES) {
                double scale = Math.sqrt((double)freeMemory / (double)expectedMemory);
                double scaledW = (double)w * scale;
                double scaledH = (double)h * scale;
                w = this.toInteger(scaledW);
                h = this.toInteger(scaledH);
            }
            this.setWidth(w);
            this.setHeight(h);
        }

        private int toInteger(double value) {
            return MathUtils.floorInt((double)value);
        }

        public JComponent createComponent() {
            BindingContext bindingContext = new BindingContext((PropertySet)this.propertyContainer);
            PropertyPane propertyPane = new PropertyPane(bindingContext);
            return propertyPane.createPanel();
        }

        public Dimension getDimension() {
            return new Dimension(this.getWidth(), this.getHeight());
        }

        private void initValueContainer() {
            PropertyDescriptor widthDescriptor = new PropertyDescriptor(PROPERTY_NAME_WIDTH, Integer.class);
            widthDescriptor.setConverter((Converter)new IntegerConverter());
            this.propertyContainer.addProperty(new Property(widthDescriptor, (PropertyAccessor)new DefaultPropertyAccessor()));
            PropertyDescriptor heightDescriptor = new PropertyDescriptor(PROPERTY_NAME_HEIGHT, Integer.class);
            heightDescriptor.setConverter((Converter)new IntegerConverter());
            this.propertyContainer.addProperty(new Property(heightDescriptor, (PropertyAccessor)new DefaultPropertyAccessor()));
        }

        private Dialogs.Answer showQuestionDialog() {
            return Dialogs.requestDecision(Bundle.CTL_ExportImageAction_MenuText(), "There may not be enough memory to export the ima because\nthe image dimension is too large. \n Do you really want to keep the image dimension?", true, null);
        }

        private long getFreeMemory() {
            long usedMemory = Runtime.getRuntime().totalMemory() - Runtime.getRuntime().freeMemory();
            return Runtime.getRuntime().maxMemory() - usedMemory;
        }

        private long getExpectedMemory(int width, int height) {
            return (long)(width * height) * 6L;
        }

        private int getWidth() {
            return (Integer)this.propertyContainer.getValue(PROPERTY_NAME_WIDTH);
        }

        private void setWidth(Object value) {
            this.propertyContainer.setValue(PROPERTY_NAME_WIDTH, value);
        }

        private int getHeight() {
            return (Integer)this.propertyContainer.getValue(PROPERTY_NAME_HEIGHT);
        }

        private void setHeight(Object value) {
            this.propertyContainer.setValue(PROPERTY_NAME_HEIGHT, value);
        }
    }
}

