/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.event.ActionEvent;
import java.io.File;
import java.io.IOException;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import javax.swing.AbstractAction;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.dataio.dimap.DimapProductHelpers;
import org.esa.snap.core.dataio.dimap.DimapProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.image.BandOpImage;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.SaveProductAction;
import org.esa.snap.rcp.util.Dialogs;

public final class SaveProductAsAction
extends AbstractAction {
    public static final String PREFERENCES_KEY_PRODUCT_CONVERSION_REQUIRED = "product_conversion_required";
    public static final String PREFERENCES_KEY_LAST_PRODUCT_DIR = "last_product_save_dir";
    private final WeakReference<Product> productRef;

    public SaveProductAsAction(Product product) {
        this.productRef = new WeakReference<Product>(product);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public Boolean execute() {
        Product product = (Product)this.productRef.get();
        if (product != null) {
            return this.saveProductAs(product);
        }
        return true;
    }

    private Boolean saveProductAs(Product product) {
        ProductReader reader = product.getProductReader();
        if (reader != null && !(reader instanceof DimapProductReader)) {
            Dialogs.Answer answer = Dialogs.requestDecision("Save Product As", MessageFormat.format("In order to save the product\n   {0}\nit has to be converted to the BEAM-DIMAP format.\nDepending on the product size the conversion also may take a while.\n\nDo you really want to convert the product now?\n", product.getDisplayName()), true, PREFERENCES_KEY_PRODUCT_CONVERSION_REQUIRED);
            if (answer == Dialogs.Answer.NO) {
                return false;
            }
            if (answer == Dialogs.Answer.CANCELLED) {
                return null;
            }
        }
        String fileName = product.getFileLocation() != null ? product.getFileLocation().getName() : product.getName();
        File newFile = Dialogs.requestFileForSave("Save Product As", false, DimapProductHelpers.createDimapFileFilter(), ".dim", fileName, null, "last_product_open_dir");
        if (newFile == null) {
            return null;
        }
        String oldProductName = product.getName();
        File oldFile = product.getFileLocation();
        if (reader instanceof DimapProductReader && newFile.equals(oldFile)) {
            return new SaveProductAction(product).execute();
        }
        product.setFileLocation(newFile);
        Boolean status = SaveProductAction.saveProduct(product);
        if (Boolean.TRUE.equals(status)) {
            try {
                this.attachNewDimapReaderInstance(product, newFile);
            }
            catch (IOException e) {
                SnapApp.getDefault().handleError("Failed to reopen product", e);
            }
        } else {
            product.setFileLocation(oldFile);
            product.setName(oldProductName);
        }
        return status;
    }

    private void attachNewDimapReaderInstance(Product product, File newFile) throws IOException {
        Band[] bands;
        DimapProductReader productReader = (DimapProductReader)ProductIO.getProductReader((String)"BEAM-DIMAP");
        productReader.bindProduct((Object)newFile, product);
        product.setProductReader((ProductReader)productReader);
        for (Band band : bands = product.getBands()) {
            if (!band.isSourceImageSet() || !(band.getSourceImage().getImage(0) instanceof BandOpImage)) continue;
            band.setSourceImage(null);
        }
    }
}

