/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import com.bc.ceres.core.Assert;
import java.awt.event.ActionEvent;
import java.io.File;
import java.lang.ref.WeakReference;
import java.text.MessageFormat;
import java.util.EventListener;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.dataio.dimap.DimapProductReader;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.SaveProductAsAction;
import org.esa.snap.rcp.actions.file.WriteProductOperation;
import org.esa.snap.rcp.util.Dialogs;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressUtils;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public final class SaveProductAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private WeakReference<Product> productRef;
    private Lookup lookup;
    private Lookup.Result<ProductNode> result;

    public SaveProductAction(Product products) {
        this.productRef = new WeakReference<Product>(products);
    }

    public SaveProductAction() {
        this(Utilities.actionsGlobalContext());
    }

    public SaveProductAction(Lookup actionContext) {
        super(Bundle.CTL_SaveProductActionName());
        this.lookup = actionContext;
        this.result = this.lookup.lookupResult(ProductNode.class);
        this.result.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, this.result));
        this.setEnabled(false);
    }

    static Boolean saveProduct(Product product) {
        Assert.notNull((Object)product.getFileLocation());
        File file = product.getFileLocation();
        if (file.isFile() && !file.canWrite()) {
            Dialogs.showWarning(Bundle.CTL_SaveProductActionName(), MessageFormat.format("The product\n''{0}''\nexists and cannot be overwritten, because it is read only.\nPlease choose another file or remove the write protection.", file.getPath()), null);
            return false;
        }
        SnapApp.getDefault().setStatusBarMessage(MessageFormat.format("Writing product ''{0}'' to {1}...", product.getDisplayName(), file));
        boolean incremental = true;
        WriteProductOperation operation = new WriteProductOperation(product, incremental);
        ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)operation, (String)Bundle.CTL_SaveProductActionName(), (ProgressHandle)operation.getProgressHandle(), (boolean)true, (int)50, (int)1000);
        SnapApp.getDefault().setStatusBarMessage("");
        return operation.getStatus();
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new SaveProductAction(actionContext);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        ProductNode productNode = (ProductNode)this.lookup.lookup(ProductNode.class);
        this.setEnabled(productNode != null);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    public Boolean execute() {
        Product product = null;
        product = this.productRef != null ? (Product)this.productRef.get() : SnapApp.getDefault().getSelectedProduct(SnapApp.SelectionSourceHint.EXPLORER);
        if (product != null) {
            if (product.getFileLocation() != null && (product.getProductReader() == null || product.getProductReader() instanceof DimapProductReader)) {
                return SaveProductAction.saveProduct(product);
            }
            return new SaveProductAsAction(product).execute();
        }
        return true;
    }
}

