/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import com.bc.ceres.swing.TableLayout;
import java.awt.Component;
import java.awt.LayoutManager;
import java.io.File;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.prefs.Preferences;
import java.util.stream.Collectors;
import javax.swing.DefaultListCellRenderer;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.filechooser.FileFilter;
import org.esa.snap.core.dataio.DecodeQualification;
import org.esa.snap.core.dataio.ProductIOPlugInManager;
import org.esa.snap.core.dataio.ProductReaderPlugIn;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.io.SnapFileFilter;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.ProductFileChooser;
import org.esa.snap.rcp.actions.file.ReadProductOperation;
import org.esa.snap.rcp.util.Dialogs;
import org.netbeans.api.progress.ProgressHandle;
import org.netbeans.api.progress.ProgressHandleFactory;
import org.netbeans.api.progress.ProgressUtils;
import org.openide.DialogDisplayer;
import org.openide.NotifyDescriptor;
import org.openide.util.Cancellable;

public class ProductOpener {
    public static final String PREFERENCES_KEY_LAST_PRODUCT_DIR = "last_product_open_dir";
    private static final String PREFERENCES_KEY_PREFIX_ALTERNATIVE_READER = "open_alternative_reader.";
    private static final String PREFERENCES_KEY_DONT_SHOW_DIALOG = "multipleReadersDialog.dontShow";
    private String fileFormat;
    private boolean useAllFileFilter;
    private boolean subsetImportEnabled;
    private File[] files;
    private boolean multiSelectionEnabled;

    static List<File> getOpenedProductFiles() {
        return Arrays.stream(SnapApp.getDefault().getProductManager().getProducts()).map(Product::getFileLocation).filter(file -> file != null).collect(Collectors.toList());
    }

    public void setFiles(File ... files) {
        this.files = files;
    }

    public File[] getFiles() {
        return this.files;
    }

    void setFileFormat(String format) {
        this.fileFormat = format;
    }

    public String getFileFormat() {
        return this.fileFormat;
    }

    void setUseAllFileFilter(boolean useAllFileFilter) {
        this.useAllFileFilter = useAllFileFilter;
    }

    public boolean isUseAllFileFilter() {
        return this.useAllFileFilter;
    }

    void setSubsetImportEnabled(boolean subsetImportEnabled) {
        this.subsetImportEnabled = subsetImportEnabled;
    }

    public boolean isSubsetImportEnabled() {
        return this.subsetImportEnabled;
    }

    public void setMultiSelectionEnabled(boolean multiSelectionEnabled) {
        this.multiSelectionEnabled = multiSelectionEnabled;
    }

    public boolean isMultiSelectionEnabled() {
        return this.multiSelectionEnabled;
    }

    public Boolean openProduct() {
        Iterator readerPlugIns;
        File[] configuredFiles = this.getFiles();
        if (configuredFiles != null) {
            return ProductOpener.openProductFilesCheckOpened(this.getFileFormat(), configuredFiles);
        }
        if (this.getFileFormat() != null) {
            readerPlugIns = ProductIOPlugInManager.getInstance().getReaderPlugIns(this.getFileFormat());
            if (!readerPlugIns.hasNext()) {
                Dialogs.showError(Bundle.LBL_NoReaderFoundText() + String.format("%nCan't find reader for the given format '%s'.", this.getFileFormat()));
                return false;
            }
        } else {
            readerPlugIns = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
        }
        ArrayList<SnapFileFilter> filters = new ArrayList<SnapFileFilter>();
        while (readerPlugIns.hasNext()) {
            ProductReaderPlugIn readerPlugIn = (ProductReaderPlugIn)readerPlugIns.next();
            SnapFileFilter snapFileFilter = readerPlugIn.getProductFileFilter();
            if (snapFileFilter == null) continue;
            filters.add(snapFileFilter);
        }
        Collections.sort(filters, (f1, f2) -> {
            String d1 = f1.getDescription();
            String d2 = f2.getDescription();
            return d1 != null ? d1.compareTo(d2) : (d2 == null ? 0 : 1);
        });
        if (filters.isEmpty()) {
            Dialogs.showError(Bundle.LBL_NoReaderFoundText());
            return false;
        }
        Preferences preferences = SnapApp.getDefault().getPreferences();
        String userHomePath = SystemUtils.getUserHomeDir().getAbsolutePath();
        ProductFileChooser fc = new ProductFileChooser(new File(preferences.get(PREFERENCES_KEY_LAST_PRODUCT_DIR, userHomePath)));
        fc.setSubsetEnabled(this.isSubsetImportEnabled());
        fc.setDialogTitle(SnapApp.getDefault().getInstanceName() + " - " + Bundle.CTL_OpenProductActionName());
        fc.setAcceptAllFileFilterUsed(this.isUseAllFileFilter());
        filters.forEach(filter -> {
            fc.addChoosableFileFilter((FileFilter)filter);
            if (this.getFileFormat() != null && this.getFileFormat().equals(filter.getFormatName())) {
                fc.setFileFilter((FileFilter)filter);
            }
        });
        fc.setMultiSelectionEnabled(this.isMultiSelectionEnabled());
        fc.setFileSelectionMode(0);
        int returnVal = fc.showOpenDialog(SnapApp.getDefault().getMainFrame());
        if (returnVal != 0) {
            return null;
        }
        File[] files = this.getSelectedFiles(fc);
        if (files == null || files.length == 0) {
            return null;
        }
        File currentDirectory = fc.getCurrentDirectory();
        if (currentDirectory != null) {
            preferences.put(PREFERENCES_KEY_LAST_PRODUCT_DIR, currentDirectory.toString());
        }
        if (fc.getSubsetProduct() != null) {
            SnapApp.getDefault().getProductManager().addProduct(fc.getSubsetProduct());
            return true;
        }
        String formatName = fc.getFileFilter() instanceof SnapFileFilter ? ((SnapFileFilter)fc.getFileFilter()).getFormatName() : null;
        return ProductOpener.openProductFilesCheckOpened(formatName, files);
    }

    private File[] getSelectedFiles(ProductFileChooser fc) {
        File[] files = new File[]{};
        if (this.isMultiSelectionEnabled()) {
            files = fc.getSelectedFiles();
        } else {
            File file = fc.getSelectedFile();
            if (file != null) {
                files = new File[]{file};
            }
        }
        return files;
    }

    private static Boolean openProductFilesCheckOpened(String formatName, File ... files) {
        List<File> openedFiles = ProductOpener.getOpenedProductFiles();
        ArrayList<File> fileList = new ArrayList<File>(Arrays.asList(files));
        for (File file : files) {
            if (!openedFiles.contains(file)) continue;
            Dialogs.Answer answer = Dialogs.requestDecision(Bundle.CTL_OpenProductActionName(), MessageFormat.format("Product\n{0}\nis already opened.\nDo you want to open another instance?", file), true, null);
            if (answer == Dialogs.Answer.NO) {
                fileList.remove(file);
                continue;
            }
            if (answer != Dialogs.Answer.CANCELLED) continue;
            return null;
        }
        Boolean summaryStatus = true;
        for (File file : fileList) {
            Boolean status;
            String fileFormatName;
            if (formatName == null) {
                PluginEntry entry;
                List<PluginEntry> intendedPlugIns = ProductOpener.getPluginsForFile(file, DecodeQualification.INTENDED);
                List<PluginEntry> suitablePlugIns = ProductOpener.getPluginsForFile(file, DecodeQualification.SUITABLE);
                if (intendedPlugIns.isEmpty() && suitablePlugIns.isEmpty()) {
                    Dialogs.showError(Bundle.LBL_NoReaderFoundText() + String.format("%nFile '%s' can not be opened.", file));
                    continue;
                }
                if (intendedPlugIns.size() == 1) {
                    entry = intendedPlugIns.get(0);
                    fileFormatName = entry.plugin.getFormatNames()[0];
                } else if (intendedPlugIns.size() == 0 && suitablePlugIns.size() == 1) {
                    entry = suitablePlugIns.get(0);
                    fileFormatName = entry.plugin.getFormatNames()[0];
                } else {
                    Collections.sort(intendedPlugIns);
                    Collections.sort(suitablePlugIns);
                    fileFormatName = ProductOpener.getUserSelection(intendedPlugIns, suitablePlugIns);
                    if (fileFormatName == null) {
                        return null;
                    }
                }
            } else {
                fileFormatName = formatName;
            }
            if ((status = ProductOpener.openProductFileDoNotCheckOpened(file, fileFormatName)) == null) {
                summaryStatus = null;
                break;
            }
            if (Boolean.TRUE.equals(status)) continue;
            summaryStatus = status;
        }
        return summaryStatus;
    }

    private static List<PluginEntry> getPluginsForFile(File file, DecodeQualification desiredQualification) {
        Iterator allReaderPlugIns = ProductIOPlugInManager.getInstance().getAllReaderPlugIns();
        ArrayList<PluginEntry> possiblePlugIns = new ArrayList<PluginEntry>();
        allReaderPlugIns.forEachRemaining(plugIn -> {
            DecodeQualification qualification = plugIn.getDecodeQualification((Object)file);
            if (qualification == desiredQualification) {
                possiblePlugIns.add(new PluginEntry((ProductReaderPlugIn)plugIn, qualification));
            }
        });
        return possiblePlugIns;
    }

    private static String getUserSelection(List<PluginEntry> intendedPlugins, List<PluginEntry> suitablePlugIns) {
        PluginEntry leadPlugin = !intendedPlugins.isEmpty() ? intendedPlugins.get(0) : suitablePlugIns.get(0);
        boolean dontShowDialog = SnapApp.getDefault().getPreferences().getBoolean(PREFERENCES_KEY_DONT_SHOW_DIALOG, false);
        String prefKeyFormat = PREFERENCES_KEY_PREFIX_ALTERNATIVE_READER + leadPlugin.plugin.getClass().getSimpleName();
        String storedSelection = SnapApp.getDefault().getPreferences().get(prefKeyFormat, null);
        if (dontShowDialog && storedSelection != null) {
            return storedSelection;
        }
        TableLayout layout = new TableLayout(1);
        layout.setTableAnchor(TableLayout.Anchor.WEST);
        layout.setTableFill(TableLayout.Fill.HORIZONTAL);
        layout.setTablePadding(4, 4);
        JPanel readerSelectionPanel = new JPanel((LayoutManager)layout);
        readerSelectionPanel.add(new JLabel("<html>Multiple readers are available for the selected file.<br>The readers might interpret the data differently.<br>Please select one of the following:"));
        JComboBox<Object> pluginsCombobox = new JComboBox<Object>();
        DefaultListCellRenderer cellRenderer = new DefaultListCellRenderer(){

            @Override
            public Component getListCellRendererComponent(JList<?> list, Object value, int index, boolean isSelected, boolean cellHasFocus) {
                super.getListCellRendererComponent(list, value, index, isSelected, cellHasFocus);
                this.setText(((ProductReaderPlugIn)value).getDescription(Locale.getDefault()));
                return this;
            }
        };
        pluginsCombobox.setRenderer(cellRenderer);
        for (PluginEntry plugin : intendedPlugins) {
            pluginsCombobox.addItem(plugin.plugin);
        }
        for (PluginEntry plugin : suitablePlugIns) {
            pluginsCombobox.addItem(plugin.plugin);
        }
        readerSelectionPanel.add(pluginsCombobox);
        JCheckBox decisionCheckBox = new JCheckBox("Remember my decision and don't ask again.", false);
        decisionCheckBox.setHorizontalAlignment(4);
        readerSelectionPanel.add(decisionCheckBox);
        NotifyDescriptor d = new NotifyDescriptor((Object)readerSelectionPanel, Dialogs.getDialogTitle("Multiple Readers Available"), 2, 3, null, NotifyDescriptor.OK_OPTION);
        Object answer = DialogDisplayer.getDefault().notify(d);
        if (NotifyDescriptor.OK_OPTION.equals(answer)) {
            boolean storeResult = decisionCheckBox.isSelected();
            String selectedFormatName = ((ProductReaderPlugIn)pluginsCombobox.getSelectedItem()).getFormatNames()[0];
            if (storeResult) {
                SnapApp.getDefault().getPreferences().put(prefKeyFormat, selectedFormatName);
                SnapApp.getDefault().getPreferences().put(PREFERENCES_KEY_DONT_SHOW_DIALOG, "true");
            }
            return selectedFormatName;
        }
        return null;
    }

    private static Boolean openProductFileDoNotCheckOpened(File file, String formatName) {
        SnapApp.getDefault().setStatusBarMessage(MessageFormat.format("Reading product ''{0}''...", file.getName()));
        ReadProductOperation operation = new ReadProductOperation(file, formatName);
        ProgressHandle progressHandle = ProgressHandleFactory.createHandle((String)"Please wait while the data product is being read...", (Cancellable)operation);
        ProgressUtils.runOffEventThreadWithProgressDialog((Runnable)operation, (String)"Reading Product", (ProgressHandle)progressHandle, (boolean)false, (int)50, (int)2000);
        progressHandle.start();
        progressHandle.switchToIndeterminate();
        SnapApp.getDefault().setStatusBarMessage("");
        return operation.getStatus();
    }

    private static class PluginEntry
    implements Comparable<PluginEntry> {
        ProductReaderPlugIn plugin;
        DecodeQualification qualification;

        public PluginEntry(ProductReaderPlugIn plugin, DecodeQualification qualification) {
            this.plugin = plugin;
            this.qualification = qualification;
        }

        @Override
        public int compareTo(PluginEntry other) {
            int qualificationComparison = this.qualification.compareTo((Enum)other.qualification);
            if (qualificationComparison == 0) {
                String description1 = this.plugin.getDescription(Locale.getDefault());
                String description2 = other.plugin.getDescription(Locale.getDefault());
                return description1.compareTo(description2);
            }
            return qualificationComparison;
        }
    }
}

