/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.rcp.actions.file;

import java.awt.event.ActionEvent;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.EventListener;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.swing.AbstractAction;
import javax.swing.Action;
import org.esa.snap.core.dataio.ProductReader;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.core.jexp.ParseException;
import org.esa.snap.netbeans.docwin.DocumentWindow;
import org.esa.snap.netbeans.docwin.DocumentWindowManager;
import org.esa.snap.netbeans.docwin.WindowUtilities;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.actions.file.Bundle;
import org.esa.snap.rcp.actions.file.SaveProductAction;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;
import org.openide.util.WeakSet;

public final class CloseProductAction
extends AbstractAction
implements ContextAwareAction,
LookupListener {
    private final WeakSet<Product> productSet = new WeakSet();
    private Lookup lkp;

    public CloseProductAction() {
        this(Utilities.actionsGlobalContext());
    }

    public CloseProductAction(Lookup actionContext) {
        super(Bundle.CTL_CloseProductActionName());
        this.lkp = actionContext;
        Lookup.Result productNode = this.lkp.lookupResult(ProductNode.class);
        productNode.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)this, (Object)productNode));
        this.setEnableState();
    }

    public CloseProductAction(List<Product> products) {
        this.productSet.addAll(products);
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new CloseProductAction(actionContext);
    }

    public void resultChanged(LookupEvent lookupEvent) {
        this.setEnableState();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.execute();
    }

    private void setEnableState() {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        this.setEnabled(productNode != null);
    }

    public Boolean execute() {
        Boolean status;
        if (!this.productSet.isEmpty()) {
            status = CloseProductAction.closeProducts(new HashSet<Product>((Collection<Product>)this.productSet));
            this.productSet.clear();
        } else {
            ProductNode productNode = SnapApp.getDefault().getSelectedProductNode(SnapApp.SelectionSourceHint.EXPLORER);
            if (productNode != null) {
                Product product = productNode.getProduct();
                status = CloseProductAction.closeProducts(new HashSet<Product>(Collections.singletonList(product)));
            } else {
                status = false;
            }
        }
        return status;
    }

    private static Boolean closeProducts(Set<Product> products) {
        ArrayList<Product> closeList = new ArrayList<Product>(products);
        ArrayList<Product> saveList = new ArrayList<Product>();
        Product[] products1 = SnapApp.getDefault().getProductManager().getProducts();
        HashSet<Product> stillOpenProducts = new HashSet<Product>(Arrays.asList(products1));
        stillOpenProducts.removeAll(closeList);
        if (!stillOpenProducts.isEmpty()) {
            for (Product productToBeClosed : closeList) {
                Product firstSourceProduct = CloseProductAction.findFirstSourceProduct(productToBeClosed, stillOpenProducts);
                if (firstSourceProduct == null) continue;
                Dialogs.showInformation("Close Not Possible", String.format("Can't close product '%s' because it is in use%nby product '%s'.%nPlease close the latter first.", productToBeClosed.getName(), firstSourceProduct.getName()), null);
                return false;
            }
        }
        for (Product product : products) {
            if (!product.isModified()) continue;
            Dialogs.Answer answer = Dialogs.requestDecision(Bundle.CTL_OpenProductActionName(), MessageFormat.format("Product ''{0}'' has been modified.\nDo you want to save it?", product.getName()), true, null);
            if (answer == Dialogs.Answer.YES) {
                saveList.add(product);
                continue;
            }
            if (answer != Dialogs.Answer.CANCELLED) continue;
            return null;
        }
        for (Product product : saveList) {
            Boolean status = new SaveProductAction(product).execute();
            if (status != null) continue;
            return null;
        }
        for (Product product : closeList) {
            WindowUtilities.getOpened(DocumentWindow.class).filter(dw -> dw.getDocument() instanceof ProductNode && ((ProductNode)dw.getDocument()).getProduct() == product).forEach(dw -> DocumentWindowManager.getDefault().closeWindow(dw));
            SnapApp.getDefault().getProductManager().removeProduct(product);
        }
        closeList.forEach(Product::dispose);
        return true;
    }

    static Product findFirstSourceProduct(Product productToClose, Set<Product> productsStillOpen) {
        Product firstSourceProduct = CloseProductAction.findFirstDirectSourceProduct(productToClose, productsStillOpen);
        if (firstSourceProduct != null) {
            return firstSourceProduct;
        }
        return CloseProductAction.findFirstExpressionSourceProduct(productToClose, productsStillOpen);
    }

    private static Product findFirstDirectSourceProduct(Product productToBeClosed, Set<Product> productsStillOpen) {
        for (Product openProduct : productsStillOpen) {
            ProductReader reader = openProduct.getProductReader();
            if (reader == null) continue;
            Object input = reader.getInput();
            if (input instanceof Product) {
                Product sourceProduct = (Product)input;
                if (productToBeClosed.equals(sourceProduct)) {
                    return openProduct;
                }
                Product indirectSourceProduct = CloseProductAction.findFirstDirectSourceProduct(sourceProduct, productsStillOpen);
                if (indirectSourceProduct == null || !productToBeClosed.equals(indirectSourceProduct)) continue;
                return openProduct;
            }
            if (!(input instanceof Product[])) continue;
            for (Product sourceProduct : (Product[])input) {
                if (productToBeClosed.equals(sourceProduct)) {
                    return openProduct;
                }
                Product indirectSourceProduct = CloseProductAction.findFirstDirectSourceProduct(sourceProduct, productsStillOpen);
                if (indirectSourceProduct == null || !productToBeClosed.equals(indirectSourceProduct)) continue;
                return openProduct;
            }
        }
        return null;
    }

    static Product findFirstExpressionSourceProduct(Product productToBeClosed, Set<Product> productsStillOpen) {
        for (Product openProduct : productsStillOpen) {
            Band[] bands;
            for (Band band : bands = openProduct.getBands()) {
                if (!(band instanceof VirtualBand)) continue;
                VirtualBand virtualBand = (VirtualBand)band;
                try {
                    RasterDataNode[] nodes;
                    for (RasterDataNode node : nodes = openProduct.getRefRasterDataNodes(virtualBand.getExpression())) {
                        if (!productToBeClosed.equals(node.getProduct())) continue;
                        return openProduct;
                    }
                }
                catch (ParseException parseException) {
                    // empty catch block
                }
            }
        }
        return null;
    }
}

