/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf.texture;

import java.awt.image.Raster;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.gpf.GPF;
import org.junit.Assert;
import org.junit.Test;

public class GLCMOp_IntegrationTest {
    private static final String SOURCE_PRODUCT_NAME = "subset_0_of_S2B_MSIL1C_20170718T101029_N0205_R022_T34VCL_20170718T101346_idepix_c2rcc_normal.dim";

    @Test
    public void testGLCMOp_Integration() throws IOException {
        URL resource = this.getClass().getResource(SOURCE_PRODUCT_NAME);
        Product sourceProduct = ProductIO.readProduct((String)resource.getFile());
        HashMap<String, String> parameters = new HashMap<String, String>();
        parameters.put("sourceBands", "conc_chl,conc_chl_masked");
        Product glcmProduct = GPF.createProduct((String)"GLCM", parameters, (Product)sourceProduct);
        Assert.assertNotNull((Object)glcmProduct);
        assert (glcmProduct.getBandGroup().contains("conc_chl_Contrast"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_Dissimilarity"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_Homogeneity"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_ASM"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_Energy"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_MAX"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_Entropy"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_GLCMMean"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_GLCMVariance"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_GLCMCorrelation"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_masked_Contrast"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_masked_Dissimilarity"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_masked_Homogeneity"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_masked_ASM"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_masked_Energy"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_masked_MAX"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_masked_Entropy"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_masked_GLCMMean"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_masked_GLCMVariance"));
        assert (glcmProduct.getBandGroup().contains("conc_chl_masked_GLCMCorrelation"));
        Band concChlContrastBand = glcmProduct.getBand("conc_chl_Contrast");
        Raster concChlContrastData = concChlContrastBand.getSourceImage().getData();
        Assert.assertEquals((double)0.0, (double)concChlContrastData.getSampleDouble(5, 5, 0), (double)1.0E-8);
        Assert.assertEquals((double)15.342857360839844, (double)concChlContrastData.getSampleDouble(200, 300, 0), (double)1.0E-8);
    }
}

