/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.util.Arrays;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.engine_utilities.util.TestUtils;
import org.esa.snap.raster.gpf.ConvertDataTypeOp;
import org.junit.Assert;
import org.junit.Test;

public class TestConvertDataTypeOperator {
    private static final OperatorSpi spi = new ConvertDataTypeOp.Spi();
    private static final int width = 4;
    private static final int height = 2;

    @Test
    public void testDoubleToInt32Linear() throws Exception {
        double[] values = this.convert("int32", "Linear (slope and intercept)");
        double[] expectedValues = new double[]{100000.0, 150000.0, 200000.0, 250000.0, 300000.0, 350000.0, 400000.0, 450000.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToInt16Linear() throws Exception {
        double[] values = this.convert("int16", "Linear (slope and intercept)");
        double[] expectedValues = new double[]{-32768.0, -23406.0, -14044.0, -4682.0, 4681.0, 14043.0, 23405.0, 32767.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToInt8Linear() throws Exception {
        double[] values = this.convert("int8", "Linear (slope and intercept)");
        double[] expectedValues = new double[]{-128.0, -92.0, -55.0, -19.0, 18.0, 54.0, 91.0, 127.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToUInt32Linear() throws Exception {
        double[] values = this.convert("uint32", "Truncate");
        double[] expectedValues = new double[]{100000.0, 150000.0, 200000.0, 250000.0, 300000.0, 350000.0, 400000.0, 450000.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToUInt16Linear() throws Exception {
        double[] values = this.convert("uint16", "Linear (slope and intercept)");
        double[] expectedValues = new double[]{0.0, 9362.0, 18724.0, 28086.0, 37449.0, 46811.0, 56173.0, 65535.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToUInt8Linear() throws Exception {
        double[] values = this.convert("uint8", "Linear (slope and intercept)");
        double[] expectedValues = new double[]{0.0, 36.0, 73.0, 109.0, 146.0, 182.0, 219.0, 255.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToInt32Truncate() throws Exception {
        double[] values = this.convert("int32", "Truncate");
        double[] expectedValues = new double[]{100000.0, 150000.0, 200000.0, 250000.0, 300000.0, 350000.0, 400000.0, 450000.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToInt16Truncate() throws Exception {
        double[] values = this.convert("int16", "Truncate");
        double[] expectedValues = new double[]{32767.0, 32767.0, 32767.0, 32767.0, 32767.0, 32767.0, 32767.0, 32767.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToInt8Truncate() throws Exception {
        double[] values = this.convert("int8", "Truncate");
        double[] expectedValues = new double[]{127.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0, 127.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToInt32LogScale() throws Exception {
        double[] values = this.convert("int32", "Logarithmic");
        double[] expectedValues = new double[]{100000.0, 150000.0, 200000.0, 250000.0, 300000.0, 350000.0, 400000.0, 450000.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToInt16LogScale() throws Exception {
        double[] values = this.convert("int16", "Logarithmic");
        double[] expectedValues = new double[]{0.0, 0.0, 0.0, 0.0, 37.0, 41.0, 44.0, 45.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    @Test
    public void testDoubleToInt8LogScale() throws Exception {
        double[] values = this.convert("int8", "Logarithmic");
        double[] expectedValues = new double[]{0.0, 0.0, 0.0, 0.0, 12.0, 17.0, 20.0, 21.0};
        Assert.assertTrue((boolean)Arrays.equals(expectedValues, values));
    }

    private double[] convert(String targetType, String scaling) throws Exception {
        Product sourceProduct = TestConvertDataTypeOperator.createTestProduct(4, 2, 100000, 500000);
        ConvertDataTypeOp op = (ConvertDataTypeOp)spi.createOperator();
        Assert.assertNotNull((Object)op);
        op.setSourceProduct(sourceProduct);
        op.setTargetDataType(targetType);
        op.setScaling(scaling);
        Product targetProduct = op.getTargetProduct();
        TestUtils.verifyProduct((Product)targetProduct, (boolean)true, (boolean)true);
        Band band = targetProduct.getBandAt(0);
        Assert.assertNotNull((Object)band);
        double[] values = new double[8];
        band.readPixels(0, 0, 4, 2, values, ProgressMonitor.NULL);
        return values;
    }

    private static void outputValues(String title, double[] values) {
        System.out.println(title);
        for (double v : values) {
            System.out.print(v + ", ");
        }
        System.out.println();
    }

    private static Product createTestProduct(int w, int h, int min, int max) {
        Product testProduct = TestUtils.createProduct((String)"ASA_IMM_1P", (int)w, (int)h);
        Band band1 = testProduct.addBand("band1", 31);
        band1.setUnit("amplitude");
        int range = w * h;
        double[] values = new double[range];
        double slope = (max - min) / range;
        for (int i = 0; i < range; ++i) {
            values[i] = (double)i * slope + (double)min;
        }
        band1.setData(ProductData.createInstance((double[])values));
        return testProduct;
    }
}

