/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.rcp.actions;

import java.awt.event.ActionEvent;
import java.util.EventListener;
import javax.swing.Action;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.raster.rcp.actions.Bundle;
import org.esa.snap.rcp.actions.AbstractSnapAction;
import org.esa.snap.rcp.util.Dialogs;
import org.openide.util.ContextAwareAction;
import org.openide.util.Lookup;
import org.openide.util.LookupEvent;
import org.openide.util.LookupListener;
import org.openide.util.Utilities;
import org.openide.util.WeakListeners;

public class LinearTodBAction
extends AbstractSnapAction
implements ContextAwareAction,
LookupListener {
    private static final String dBStr = "_db";
    private final Lookup lkp;

    public LinearTodBAction() {
        this(Utilities.actionsGlobalContext());
    }

    public LinearTodBAction(Lookup lkp) {
        this.lkp = lkp;
        Lookup.Result lkpContext = lkp.lookupResult(ProductNode.class);
        lkpContext.addLookupListener((LookupListener)WeakListeners.create(LookupListener.class, (EventListener)((Object)this), (Object)lkpContext));
        this.setEnableState();
        this.putValue("Name", Bundle.CTL_LinearTodBAction_Text());
        this.putValue("ShortDescription", Bundle.CTL_LinearTodBAction_Description());
    }

    public Action createContextAwareInstance(Lookup actionContext) {
        return new LinearTodBAction(actionContext);
    }

    public void resultChanged(LookupEvent ev) {
        this.setEnableState();
    }

    public void actionPerformed(ActionEvent event) {
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        if (productNode != null && productNode instanceof Band) {
            Band band = (Band)productNode;
            Product product = band.getProduct();
            String unit = band.getUnit();
            if (!unit.contains("db")) {
                if (Dialogs.requestDecision((String)"Convert to dB", (String)("Would you like to convert band " + band.getName() + " into dB in a new virtual band?"), (boolean)true, null) == Dialogs.Answer.YES) {
                    LinearTodBAction.convert(product, band, true);
                }
            } else if (Dialogs.requestDecision((String)"Convert to linear", (String)("Would you like to convert band " + band.getName() + " into linear in a new virtual band?"), (boolean)true, null) == Dialogs.Answer.YES) {
                LinearTodBAction.convert(product, band, false);
            }
        }
    }

    public void setEnableState() {
        Band band;
        String unit;
        ProductNode productNode = (ProductNode)this.lkp.lookup(ProductNode.class);
        if (productNode != null && productNode instanceof Band && (unit = (band = (Band)productNode).getUnit()) != null && !unit.contains("phase")) {
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public static void convert(Product product, Band band, boolean todB) {
        String expression;
        String bandName = band.getName();
        String unit = band.getUnit();
        if (todB) {
            expression = bandName + "==0 ? 0 : 10 * log10(abs(" + bandName + "))";
            bandName = bandName + dBStr;
            unit = unit + dBStr;
        } else {
            expression = "pow(10," + bandName + "/10.0)";
            if (bandName.contains(dBStr)) {
                bandName = bandName.substring(0, bandName.indexOf(dBStr));
            }
            if (unit.contains(dBStr)) {
                unit = unit.substring(0, unit.indexOf(dBStr));
            }
        }
        String newBandName = bandName;
        int i = 2;
        while (product.getBand(newBandName) != null) {
            newBandName = bandName + i;
            ++i;
        }
        VirtualBand virtBand = new VirtualBand(newBandName, 30, band.getRasterWidth(), band.getRasterHeight(), expression);
        virtBand.setUnit(unit);
        virtBand.setDescription(band.getDescription());
        virtBand.setNoDataValueUsed(true);
        product.addBand((Band)virtBand);
    }
}

