/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.rcp.actions;

import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Window;
import javax.swing.JCheckBox;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.JTextField;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VirtualBand;
import org.esa.snap.graphbuilder.rcp.utils.DialogUtils;
import org.esa.snap.rcp.SnapApp;
import org.esa.snap.rcp.util.Dialogs;
import org.esa.snap.ui.ModelessDialog;

class ScaleDataDialog
extends ModelessDialog {
    private final JTextField gainField = new JTextField("1");
    private final JTextField biasField = new JTextField("0");
    private final JTextField expField = new JTextField("1");
    private final JCheckBox logCheck = new JCheckBox();
    private final Product _product;
    private final Band _band;

    public ScaleDataDialog(String title, Product product, Band band) {
        super((Window)SnapApp.getDefault().getMainFrame(), title, 33, null);
        this._product = product;
        this._band = band;
        this.setContent(this.createEditPanel());
    }

    private JPanel createEditPanel() {
        JPanel editPanel = new JPanel();
        editPanel.setPreferredSize(new Dimension(400, 200));
        editPanel.setLayout(new GridBagLayout());
        GridBagConstraints gbc = DialogUtils.createGridBagConstraints();
        gbc.ipady = 5;
        gbc.weightx = 1.0;
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)editPanel, (GridBagConstraints)gbc, (String)"Gain:", (JComponent)this.gainField);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)editPanel, (GridBagConstraints)gbc, (String)"Bias:", (JComponent)this.biasField);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)editPanel, (GridBagConstraints)gbc, (String)"Exponential Scaling:", (JComponent)this.expField);
        ++gbc.gridy;
        DialogUtils.addComponent((JPanel)editPanel, (GridBagConstraints)gbc, (String)"Logarithmic Scaling:", (JComponent)this.logCheck);
        ++gbc.gridy;
        DialogUtils.fillPanel((JPanel)editPanel, (GridBagConstraints)gbc);
        return editPanel;
    }

    protected void onOK() {
        try {
            double gain = Double.parseDouble(this.gainField.getText());
            double bias = Double.parseDouble(this.biasField.getText());
            double exp = Double.parseDouble(this.expField.getText());
            boolean isLog = this.logCheck.isSelected();
            ScaleDataDialog.applyScaling(this._product, this._band, gain, bias, exp, isLog);
            this.hide();
        }
        catch (Exception e) {
            Dialogs.showError((String)e.getMessage());
        }
    }

    private static void applyScaling(Product product, Band band, double gain, double bias, double exp, boolean isLog) {
        String bandName = band.getName();
        String unit = band.getUnit();
        String expression = gain + " * " + bandName + " + " + bias;
        String targetName = bandName + "_Scaled";
        int cnt = 0;
        while (product.getBand(targetName) != null) {
            targetName = bandName + "_Scaled" + ++cnt;
        }
        if (exp != 1.0) {
            expression = "pow( " + expression + ", " + exp + " )";
        }
        if (isLog) {
            expression = bandName + "==0 ? 0 : log10( " + expression + " )";
        }
        VirtualBand virtBand = new VirtualBand(targetName, 30, band.getRasterWidth(), band.getRasterHeight(), expression);
        virtBand.setUnit(unit);
        virtBand.setDescription(band.getDescription());
        virtBand.setNoDataValueUsed(true);
        product.addBand((Band)virtBand);
    }
}

