/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.dat;

import java.util.Arrays;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.engine_utilities.util.TestUtils;
import org.esa.snap.raster.rcp.actions.LinearTodBAction;
import org.junit.Assert;
import org.junit.Test;

public class TestLinearTodB {
    private static final String dBStr = "_db";

    @Test
    public void testLinearTodB() {
        Product product = TestLinearTodB.createTestProduct(16, 4);
        Band band1 = product.getBandAt(0);
        LinearTodBAction.convert((Product)product, (Band)band1, (boolean)true);
        Assert.assertTrue((product.getNumBands() == 2 ? 1 : 0) != 0);
        Band band2 = product.getBandAt(1);
        Assert.assertTrue((boolean)band2.getUnit().endsWith(dBStr));
        Assert.assertTrue((boolean)band2.getName().endsWith(dBStr));
    }

    @Test
    public void testdBToLinear() {
        Product product = TestLinearTodB.createTestProduct(16, 4);
        Band band1 = product.getBandAt(0);
        band1.setName(band1.getName() + dBStr);
        band1.setUnit(band1.getUnit() + dBStr);
        LinearTodBAction.convert((Product)product, (Band)band1, (boolean)false);
        Assert.assertTrue((product.getNumBands() == 2 ? 1 : 0) != 0);
        Band band2 = product.getBandAt(1);
        Assert.assertTrue((boolean)band2.getUnit().equals("amplitude"));
        Assert.assertTrue((boolean)band2.getName().equals("Amplitude"));
    }

    private static Product createTestProduct(int w, int h) {
        Product testProduct = TestUtils.createProduct((String)"ASA_APG_1P", (int)w, (int)h);
        Band band1 = testProduct.addBand("Amplitude", 12);
        band1.setUnit("amplitude");
        int[] intValues = new int[w * h];
        for (int i = 0; i < w * h; ++i) {
            intValues[i] = i + 1;
        }
        band1.setData(ProductData.createInstance((int[])intValues));
        float[] incidence_angle = new float[64];
        Arrays.fill(incidence_angle, 30.0f);
        testProduct.addTiePointGrid(new TiePointGrid("incident_angle", 16, 4, 0.0, 0.0, 1.0, 1.0, incidence_angle));
        return testProduct;
    }
}

