/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.raster.gpf;

import java.util.HashMap;
import java.util.Map;
import javax.swing.JComponent;
import javax.swing.JTree;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.engine_utilities.util.TestUtils;
import org.esa.snap.raster.gpf.FilterOperator;
import org.esa.snap.raster.gpf.ui.FilterOpUI;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class TestFilterOpUI {
    private static final OperatorSpi spi;
    private static final String operatorName = "Image-Filter";
    private FilterOpUI filterOpUI = new FilterOpUI();
    private final Map<String, Object> parameterMap = new HashMap<String, Object>(5);

    @Before
    public void Setup() {
        GPF.getDefaultInstance().getOperatorSpiRegistry().addOperatorSpi(spi);
    }

    @Test
    public void testCreateOpTab() {
        JComponent component = this.filterOpUI.CreateOpTab(operatorName, this.parameterMap, null);
        Assert.assertNotNull((Object)component);
    }

    @Test
    public void testLoadParameters() {
        this.parameterMap.put("selectedFilterName", "High-Pass 5x5");
        JComponent component = this.filterOpUI.CreateOpTab(operatorName, this.parameterMap, null);
        Assert.assertNotNull((Object)component);
        FilterOperator.Filter filter = FilterOpUI.getSelectedFilter((JTree)this.filterOpUI.getTree());
        Assert.assertNotNull((Object)filter);
        this.filterOpUI.setSelectedFilter("Arithmetic 5x5 Mean");
        this.filterOpUI.updateParameters();
        Object o = this.parameterMap.get("selectedFilterName");
        Assert.assertTrue((boolean)((String)o).equals("Arithmetic 5x5 Mean"));
    }

    static {
        TestUtils.initTestEnvironment();
        spi = new FilterOperator.Spi();
    }
}

