/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.python.gpf;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.io.IOException;
import java.util.Map;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.Tile;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.python.PyBridge;
import org.esa.snap.python.gpf.PyOperatorDelegate;
import org.jpy.PyLib;
import org.jpy.PyModule;
import org.jpy.PyObject;

@OperatorMetadata(alias="PyOp", description="Uses Python code to process data products", version="1.0", authors="Norman Fomferra", internal=true)
public class PyOperator
extends Operator {
    private final int COMPUTE_METHOD = 1;
    private final int COMPUTE_TILE_METHOD = 2;
    private final int COMPUTE_TILE_STACK_METHOD = 4;
    private final int DO_EXECUTE_METHOD = 8;
    @Parameter(description="Path to the Python module(s). Can be either an absolute path or relative to the current working directory.", defaultValue=".")
    private String pythonModulePath;
    @Parameter(description="Name of the Python module.")
    private String pythonModuleName;
    @Parameter(description="Name of the Python class which implements the operator. Please refer to the SNAP help for details.")
    private String pythonClassName;
    private transient PyModule pyModule;
    private transient PyOperatorDelegate pythonProcessor;
    private transient int computeMethodFlags;

    public String getPythonModulePath() {
        return this.pythonModulePath;
    }

    public void setPythonModulePath(String pythonModulePath) {
        this.pythonModulePath = pythonModulePath;
    }

    public String getPythonModuleName() {
        return this.pythonModuleName;
    }

    public void setPythonModuleName(String pythonModuleName) {
        this.pythonModuleName = pythonModuleName;
    }

    public String getPythonClassName() {
        return this.pythonClassName;
    }

    public void setPythonClassName(String pythonClassName) {
        this.pythonClassName = pythonClassName;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws OperatorException {
        if (this.pythonModuleName == null || this.pythonModuleName.isEmpty()) {
            throw new OperatorException("Missing parameter 'pythonModuleName'");
        }
        if (this.pythonClassName == null || this.pythonClassName.isEmpty()) {
            throw new OperatorException("Missing value for parameter 'pythonClassName'");
        }
        try {
            PyBridge.establish();
        }
        catch (IOException e) {
            throw new OperatorException("Failed to establish Python bridge", (Throwable)e);
        }
        Class<PyLib> clazz = PyLib.class;
        synchronized (PyLib.class) {
            PyBridge.extendSysPath(this.pythonModulePath);
            String code = String.format("if '%s' in globals(): del %s", this.pythonModuleName, this.pythonModuleName);
            PyLib.execScript((String)code);
            this.pyModule = PyModule.importModule((String)this.pythonModuleName);
            PyObject pythonProcessorImpl = this.pyModule.call(this.pythonClassName, new Object[0]);
            try {
                pythonProcessorImpl.getAttribute("compute");
                this.computeMethodFlags |= 1;
                SystemUtils.LOG.warning(String.format("Python class %s.%s (path %s):\nThe method compute(self, context, tiles, rectangle) is deprecated.\nPlease replace it by computeTileStack(self, context, tiles, rectangle) or\ncomputeTile(self, context, band, tile) if your band's tiles can be\ncomputed independently.", this.pythonModuleName, this.pythonClassName, this.pythonModulePath));
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                pythonProcessorImpl.getAttribute("doExecute");
                this.computeMethodFlags |= 8;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                pythonProcessorImpl.getAttribute("computeTile");
                this.computeMethodFlags |= 2;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            try {
                pythonProcessorImpl.getAttribute("computeTileStack");
                this.computeMethodFlags |= 4;
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
            if (this.computeMethodFlags == 0) {
                throw new OperatorException("Neither doExecute(self, pm), computeTile(self, context, band, tile), nor computeTileStack(self, context, tiles, rectangle) method found.");
            }
            this.pythonProcessor = (PyOperatorDelegate)pythonProcessorImpl.createProxy(PyOperatorDelegate.class);
            this.pythonProcessor.initialize(this);
            // ** MonitorExit[var1_2] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void doExecute(ProgressMonitor pm) {
        Class<PyLib> clazz = PyLib.class;
        synchronized (PyLib.class) {
            if ((this.computeMethodFlags & 8) != 0) {
                this.pythonProcessor.doExecute(pm);
            }
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return;
        }
    }

    public boolean canComputeTile() {
        return (this.computeMethodFlags & 2) != 0;
    }

    public boolean canComputeTileStack() {
        return (this.computeMethodFlags & 1) != 0 || (this.computeMethodFlags & 4) != 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTile(Band targetBand, Tile targetTile, ProgressMonitor pm) throws OperatorException {
        Class<PyLib> clazz = PyLib.class;
        synchronized (PyLib.class) {
            if ((this.computeMethodFlags & 2) == 0) {
                throw new OperatorException("Missing computeTile(self, context, band, tile) method.");
            }
            this.pythonProcessor.computeTile(this, targetBand, targetTile);
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void computeTileStack(Map<Band, Tile> targetTiles, Rectangle targetRectangle, ProgressMonitor pm) throws OperatorException {
        Class<PyLib> clazz = PyLib.class;
        synchronized (PyLib.class) {
            if ((this.computeMethodFlags & 1) != 0) {
                this.pythonProcessor.compute(this, targetTiles, targetRectangle);
            } else if ((this.computeMethodFlags & 4) != 0) {
                this.pythonProcessor.computeTileStack(this, targetTiles, targetRectangle);
            } else {
                throw new OperatorException("Missing computeTileStack(self, context, tiles, rectangle) method.");
            }
            // ** MonitorExit[var4_4] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void dispose() {
        Class<PyLib> clazz = PyLib.class;
        synchronized (PyLib.class) {
            this.pythonProcessor.dispose(this);
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return;
        }
    }
}

