/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.python.gpf;

import java.io.File;
import java.net.URI;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.esa.snap.core.gpf.GPF;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.OperatorSpiRegistry;
import org.esa.snap.python.gpf.PyOperator;
import org.esa.snap.python.gpf.PyOperatorTest;
import org.esa.snap.runtime.Config;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.BeforeClass;
import org.junit.Test;

public class PyOperatorSpiTest {
    @BeforeClass
    public static void init() {
        File file = PyOperatorTest.getResourceFile("/");
        Assert.assertTrue((boolean)file.isDirectory());
        Config.instance().preferences().put("snap.pythonExtraPaths", file.getPath());
    }

    @Test
    public void testOperatorSpiIsLoaded() throws Exception {
        OperatorSpiRegistry registry = GPF.getDefaultInstance().getOperatorSpiRegistry();
        OperatorSpi ndviOpSpi = registry.getOperatorSpi("py_ndvi_op");
        Assert.assertNotNull((Object)ndviOpSpi);
        Assert.assertEquals((Object)"py_ndvi_op", (Object)ndviOpSpi.getOperatorAlias());
        Assert.assertSame(PyOperator.class, (Object)ndviOpSpi.getOperatorClass());
        Assert.assertNotNull((Object)ndviOpSpi.getOperatorDescriptor());
        Assert.assertEquals((Object)"org.esa.snap.python.NdviOp", (Object)ndviOpSpi.getOperatorDescriptor().getName());
        Assert.assertSame(PyOperator.class, (Object)ndviOpSpi.getOperatorDescriptor().getOperatorClass());
    }

    @Test
    public void testPathUriWithSpaces() throws Exception {
        Assume.assumeTrue((boolean)System.getProperty("os.name").contains("Win"));
        File file1 = new File("C:\\Program Files (x86)");
        URI uri1 = file1.toURI();
        Assert.assertEquals((Object)"file:/C:/Program%20Files%20(x86)/", (Object)uri1.toString());
        Path file2 = Paths.get("C:\\Program Files (x86)", new String[0]);
        URI uri2 = file2.toUri();
        Assert.assertEquals((Object)"file:///C:/Program%20Files%20(x86)/", (Object)uri2.toString());
        Assert.assertEquals((Object)uri1, (Object)uri2);
        Assert.assertNotEquals((Object)uri1.toString(), (Object)uri2.toString());
        Path path1 = Paths.get(uri1);
        Assert.assertEquals((Object)"C:\\Program Files (x86)", (Object)path1.toString());
        Path path2 = Paths.get(URI.create(file2.toUri().toString()));
        Assert.assertEquals((Object)"C:\\Program Files (x86)", (Object)path2.toString());
        Assert.assertEquals((Object)path1, (Object)path2);
    }
}

