/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.model.dataprovider;

import com.bc.ceres.core.ProgressMonitor;
import java.awt.Color;
import java.awt.Component;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.util.Comparator;
import javax.swing.AbstractCellEditor;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableColumn;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.datamodel.quicklooks.Quicklook;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.productlibrary.rcp.toolviews.model.dataprovider.DataProvider;

public class QuicklookProvider
implements DataProvider {
    private static final Comparator quickLookComparator = new QuickLookComparator();
    private TableColumn quickLookColumn;
    private static final int preferredWidth = 150;
    private static final int preferredHeight = 100;

    @Override
    public Comparator getComparator() {
        return quickLookComparator;
    }

    @Override
    public TableColumn getTableColumn() {
        if (this.quickLookColumn == null) {
            try {
                this.quickLookColumn = new TableColumn();
                this.quickLookColumn.setHeaderValue("Quick Look");
                this.quickLookColumn.setPreferredWidth(150);
                this.quickLookColumn.setResizable(true);
                this.quickLookColumn.setCellRenderer(new QuickLookRenderer(100));
                this.quickLookColumn.setCellEditor(new QuickLookEditor());
            }
            catch (Throwable e) {
                SystemUtils.LOG.severe("QuicklookProvider: " + e.getMessage());
            }
        }
        return this.quickLookColumn;
    }

    private static BufferedImage getImage(ProductEntry productEntry) {
        if (productEntry.quickLookExists()) {
            Quicklook quicklook = productEntry.getQuickLook();
            if (!quicklook.hasProduct() && !quicklook.hasCachedImage() && quicklook.getProductFile() != null) {
                try {
                    quicklook.setProduct(ProductIO.readProduct((File)quicklook.getProductFile()));
                }
                catch (IOException e) {
                    SystemUtils.LOG.warning("Quicklook unable to load product " + quicklook.getProductFile());
                }
            }
            return quicklook.getImage(ProgressMonitor.NULL);
        }
        return null;
    }

    private static class QuickLookComparator
    implements Comparator {
        private QuickLookComparator() {
        }

        public int compare(Object o1, Object o2) {
            if (o1 == o2) {
                return 0;
            }
            if (o1 == null) {
                return -1;
            }
            if (o2 == null) {
                return 1;
            }
            Quicklook image1 = ((ProductEntry)o1).getQuickLook();
            Quicklook image2 = ((ProductEntry)o2).getQuickLook();
            if (image1 == null) {
                return -1;
            }
            if (image2 == null) {
                return 1;
            }
            if (!image1.hasImage()) {
                return -1;
            }
            if (!image2.hasImage()) {
                return 1;
            }
            return 0;
        }
    }

    public static class QuickLookEditor
    extends AbstractCellEditor
    implements TableCellEditor {
        private final JScrollPane scrollPane = new JScrollPane();

        public QuickLookEditor() {
            this.scrollPane.setVerticalScrollBarPolicy(20);
            this.scrollPane.setHorizontalScrollBarPolicy(30);
            this.scrollPane.getViewport().setOpaque(false);
        }

        @Override
        public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
            try {
                if (!(value instanceof ProductEntry)) {
                    return this.scrollPane;
                }
                BufferedImage image = QuicklookProvider.getImage((ProductEntry)value);
                if (image == null) {
                    return this.scrollPane;
                }
                this.scrollPane.setViewportView(new JLabel(new ImageIcon(image.getScaledInstance(-1, -1, 16))));
                Color backgroundColor = table.getSelectionBackground();
                this.scrollPane.setBackground(backgroundColor);
                this.scrollPane.setBorder(BorderFactory.createLineBorder(backgroundColor, 3));
            }
            catch (Throwable e) {
                SystemUtils.LOG.severe("QuicklookEditor: " + e.getMessage());
            }
            return this.scrollPane;
        }

        @Override
        public Object getCellEditorValue() {
            return null;
        }
    }

    private static class QuickLookRenderer
    extends DefaultTableCellRenderer {
        private final int rowHeight;
        private JLabel tableComponent;

        public QuickLookRenderer(int height) {
            this.rowHeight = height + 3;
        }

        @Override
        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            try {
                if (this.tableComponent == null) {
                    this.tableComponent = (JLabel)super.getTableCellRendererComponent(table, value, isSelected, hasFocus, row, column);
                    this.tableComponent.setText("");
                    this.tableComponent.setVerticalAlignment(0);
                    this.tableComponent.setHorizontalAlignment(0);
                }
                this.setBackground(table, isSelected);
                if (value == null) {
                    this.tableComponent.setIcon(null);
                    this.tableComponent.setText("");
                    return this.tableComponent;
                }
                if (value instanceof ProductEntry) {
                    BufferedImage image = QuicklookProvider.getImage((ProductEntry)value);
                    if (image == null) {
                        this.tableComponent.setIcon(null);
                        this.tableComponent.setText("Not available!");
                    } else {
                        TableColumn tableColumn = table.getColumnModel().getColumn(column);
                        int cellWidth = tableColumn.getWidth();
                        int cellHeight = tableColumn.getWidth();
                        if (image.getHeight() > image.getWidth()) {
                            cellWidth = -1;
                        } else {
                            cellHeight = -1;
                        }
                        this.tableComponent.setIcon(new ImageIcon(image.getScaledInstance(cellWidth, cellHeight, 2)));
                        this.tableComponent.setText("");
                        this.setTableRowHeight(table, row);
                    }
                } else {
                    this.tableComponent.setIcon(null);
                }
            }
            catch (Throwable e) {
                SystemUtils.LOG.severe("QuicklookRenderer: " + e.getMessage());
            }
            return this.tableComponent;
        }

        private void setBackground(JTable table, boolean isSelected) {
            if (this.tableComponent == null) {
                return;
            }
            Color backGroundColor = table.getBackground();
            if (isSelected) {
                backGroundColor = table.getSelectionBackground();
            }
            this.tableComponent.setBorder(BorderFactory.createLineBorder(backGroundColor, 3));
            this.tableComponent.setBackground(backGroundColor);
        }

        private void setTableRowHeight(JTable table, int row) {
            if (table.getRowHeight(row) < this.rowHeight) {
                table.setRowHeight(row, this.rowHeight);
            }
        }
    }
}

