/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.productlibrary.rcp.toolviews.model;

import java.util.ArrayList;
import java.util.List;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableColumnModel;
import javax.swing.table.TableColumn;
import javax.swing.table.TableColumnModel;
import org.esa.snap.engine_utilities.db.ProductEntry;
import org.esa.snap.productlibrary.rcp.toolviews.model.dataprovider.DataProvider;
import org.esa.snap.productlibrary.rcp.toolviews.model.dataprovider.IDProvider;
import org.esa.snap.productlibrary.rcp.toolviews.model.dataprovider.PropertiesProvider;
import org.esa.snap.productlibrary.rcp.toolviews.model.dataprovider.QuicklookProvider;
import org.esa.snap.rcp.util.Dialogs;

public class ProductEntryTableModel
extends AbstractTableModel {
    private final ProductEntry[] productEntryList;
    final List<DataProvider> dataProviders = new ArrayList<DataProvider>(5);
    private final List<TableColumn> columnList = new ArrayList<TableColumn>();

    public ProductEntryTableModel(ProductEntry[] productList, boolean minimalView) {
        this.productEntryList = productList;
        this.dataProviders.add(new IDProvider());
        this.dataProviders.add(new PropertiesProvider(minimalView));
        if (!minimalView) {
            try {
                this.dataProviders.add(new QuicklookProvider());
            }
            catch (Exception e) {
                e.printStackTrace();
                Dialogs.showError((String)e.getMessage());
            }
        }
        for (DataProvider provider : this.dataProviders) {
            TableColumn tableColumn = provider.getTableColumn();
            tableColumn.setModelIndex(this.getColumnCount());
            this.columnList.add(tableColumn);
        }
    }

    public DataProvider getDataProvider(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.dataProviders.size()) {
            return this.dataProviders.get(columnIndex);
        }
        return null;
    }

    public TableColumnModel getColumnModel() {
        DefaultTableColumnModel columnModel = new DefaultTableColumnModel();
        for (TableColumn aColumnList : this.columnList) {
            columnModel.addColumn(aColumnList);
        }
        return columnModel;
    }

    @Override
    public int getRowCount() {
        return this.productEntryList != null ? this.productEntryList.length : 0;
    }

    @Override
    public int getColumnCount() {
        return this.columnList.size();
    }

    @Override
    public Object getValueAt(int rowIndex, int columnIndex) {
        ProductEntry entry;
        if (this.productEntryList != null && (entry = this.productEntryList[rowIndex]) != null) {
            return entry;
        }
        return null;
    }

    @Override
    public String getColumnName(int columnIndex) {
        if (columnIndex >= 0 && columnIndex < this.columnList.size()) {
            TableColumn column = this.columnList.get(columnIndex);
            return column.getHeaderValue().toString();
        }
        return "";
    }

    @Override
    public boolean isCellEditable(int rowIndex, int columnIndex) {
        if (columnIndex >= this.columnList.size()) {
            return false;
        }
        TableColumn column = this.columnList.get(columnIndex);
        return column.getCellEditor() != null;
    }
}

