/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import com.bc.ceres.glevel.MultiLevelImage;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductNode;
import org.esa.snap.core.datamodel.ProductNodeGroup;
import org.esa.snap.core.datamodel.TiePointGrid;
import org.esa.snap.pixex.aggregators.AggregatorStrategy;
import org.esa.snap.pixex.calvalus.ma.Record;
import org.esa.snap.pixex.output.PixExRasterNamesFactory;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class PixExRasterNamesFactoryTest {
    private Product product;

    @Before
    public void setUp() throws Exception {
        this.product = new Product("name", "type", 10, 10);
        this.product.addBand("val1", 11);
        this.product.addBand("val2", 11);
        this.product.addBand("val3", 11);
        this.product.addTiePointGrid(this.newTiePointGrid("tp1"));
        this.product.addTiePointGrid(this.newTiePointGrid("tp2"));
        this.product.addTiePointGrid(this.newTiePointGrid("tp3"));
        ProductNodeGroup maskGroup = this.product.getMaskGroup();
        maskGroup.add((ProductNode)this.newMask("mask1"));
        maskGroup.add((ProductNode)this.newMask("mask2"));
        maskGroup.add((ProductNode)this.newMask("mask3"));
    }

    @Test
    public void testGetRasterNamesToBeExported_exportAll() {
        boolean exportBands = true;
        boolean exportTiePoints = true;
        boolean exportMasks = true;
        PixExRasterNamesFactory pixExRasterNamesFactory = new PixExRasterNamesFactory(true, true, true, null);
        String[] rasterNames = pixExRasterNamesFactory.getRasterNames(this.product);
        String[] expected = new String[]{"val1", "val2", "val3", "tp1", "tp2", "tp3", "mask1", "mask2", "mask3"};
        Assert.assertThat((Object)rasterNames, (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testGetRasterNamesToBeExported_exportBandsOnly() {
        boolean exportBands = true;
        PixExRasterNamesFactory pixExRasterNamesFactory = new PixExRasterNamesFactory(true, false, false, null);
        String[] rasterNames = pixExRasterNamesFactory.getRasterNames(this.product);
        String[] expected = new String[]{"val1", "val2", "val3"};
        Assert.assertThat((Object)rasterNames, (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testGetRasterNamesToBeExported_exportTiepointsOnyl() {
        boolean exportTiePoints = true;
        PixExRasterNamesFactory pixExRasterNamesFactory = new PixExRasterNamesFactory(false, true, false, null);
        String[] rasterNames = pixExRasterNamesFactory.getRasterNames(this.product);
        String[] expected = new String[]{"tp1", "tp2", "tp3"};
        Assert.assertThat((Object)rasterNames, (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testGetRasterNamesToBeExported_exportMasksOnly() {
        boolean exportMasks = true;
        PixExRasterNamesFactory pixExRasterNamesFactory = new PixExRasterNamesFactory(false, false, true, null);
        String[] rasterNames = pixExRasterNamesFactory.getRasterNames(this.product);
        String[] expected = new String[]{"mask1", "mask2", "mask3"};
        Assert.assertThat((Object)rasterNames, (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    @Test
    public void testGetRasterNamesWithAggregationStrategy() {
        AggregatorStrategy aggregatorStrategy = new AggregatorStrategy(){

            public Number[] getValues(Record record, int rasterIndex) {
                return new Number[0];
            }

            public int getValueCount() {
                return 3;
            }

            public String[] getSuffixes() {
                return new String[]{"first", "second", "last"};
            }
        };
        PixExRasterNamesFactory pixExRasterNamesFactory = new PixExRasterNamesFactory(true, false, false, aggregatorStrategy);
        String[] rasterNames = pixExRasterNamesFactory.getRasterNames(this.product);
        String[] expected = new String[]{"val1_first", "val1_second", "val1_last", "val2_first", "val2_second", "val2_last", "val3_first", "val3_second", "val3_last"};
        Assert.assertThat((Object)rasterNames, (Matcher)CoreMatchers.equalTo((Object)expected));
    }

    private TiePointGrid newTiePointGrid(String name) {
        return new TiePointGrid(name, 10, 10, 0.0, 0.0, 1.0, 1.0, new float[100]);
    }

    private Mask newMask(String name) {
        return new Mask(name, 10, 10, (Mask.ImageType)new TestImageType());
    }

    private static class TestImageType
    extends Mask.ImageType {
        public TestImageType() {
            super("type");
        }

        public MultiLevelImage createImage(Mask mask) {
            return null;
        }
    }
}

