/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Date;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.pixex.output.DefaultFormatStrategy;
import org.esa.snap.pixex.output.RasterNamesFactory;
import org.hamcrest.BaseMatcher;
import org.hamcrest.CoreMatchers;
import org.hamcrest.Description;
import org.hamcrest.Matcher;
import org.junit.Assert;
import org.junit.Test;

public class PixExFormatStrategyTest_writeHeader {
    @Test
    public void testWriteHeaderWithExpression() throws Exception {
        RasterNamesFactory rasterNamesFactory = this.newRasterNamesFactory(new String[]{"rad_1", "rad_2", "uncert"});
        DefaultFormatStrategy pixExFormatStrategy = new DefaultFormatStrategy(rasterNamesFactory, 9, "expression", true);
        StringWriter stringWriter = new StringWriter(200);
        pixExFormatStrategy.writeHeader(new PrintWriter(stringWriter), null);
        BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"# SNAP pixel extraction export table"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"#"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"# Window size: 9"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"# Expression: expression"));
        Assert.assertThat((Object)reader.readLine(), this.startsWith("# Created on:\t" + ProductData.UTC.createDateFormat((String)"yyyy-MM-dd").format(new Date())));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"Expression result\tProdID\tCoordID\tName\tLatitude\tLongitude\tPixelX\tPixelY\tDate(yyyy-MM-dd)\tTime(HH_mm_ss)\trad_1\trad_2\tuncert"));
    }

    @Test
    public void testWriteHeaderWithExpression_NotExporting() throws Exception {
        RasterNamesFactory rasterNamesFactory = this.newRasterNamesFactory(new String[]{"rad_1", "rad_2", "uncert"});
        DefaultFormatStrategy pixExFormatStrategy = new DefaultFormatStrategy(rasterNamesFactory, 9, "expression", false);
        StringWriter stringWriter = new StringWriter(200);
        pixExFormatStrategy.writeHeader(new PrintWriter(stringWriter), null);
        BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"# SNAP pixel extraction export table"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"#"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"# Window size: 9"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"# Expression: expression"));
        Assert.assertThat((Object)reader.readLine(), this.startsWith("# Created on:\t" + ProductData.UTC.createDateFormat((String)"yyyy-MM-dd").format(new Date())));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"ProdID\tCoordID\tName\tLatitude\tLongitude\tPixelX\tPixelY\tDate(yyyy-MM-dd)\tTime(HH_mm_ss)\trad_1\trad_2\tuncert"));
    }

    @Test
    public void testWriteHeaderWithoutExpression() throws Exception {
        RasterNamesFactory rasterNamesFactory = this.newRasterNamesFactory(new String[]{"varA", "varB", "var C"});
        DefaultFormatStrategy pixExFormatStrategy = new DefaultFormatStrategy(rasterNamesFactory, 3, null, false);
        StringWriter stringWriter = new StringWriter(200);
        pixExFormatStrategy.writeHeader(new PrintWriter(stringWriter), null);
        BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"# SNAP pixel extraction export table"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"#"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"# Window size: 3"));
        Assert.assertThat((Object)reader.readLine(), this.startsWith("# Created on:\t" + ProductData.UTC.createDateFormat((String)"yyyy-MM-dd").format(new Date())));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"ProdID\tCoordID\tName\tLatitude\tLongitude\tPixelX\tPixelY\tDate(yyyy-MM-dd)\tTime(HH_mm_ss)\tvarA\tvarB\tvar C"));
    }

    @Test
    public void testWriteHeaderWithoutExpression_WithProduct() throws Exception {
        String[] rasterNames = new String[]{"varA", "varB", "var C"};
        RasterNamesFactory rasterNamesFactory = this.newRasterNamesFactory(rasterNames);
        DefaultFormatStrategy pixExFormatStrategy = new DefaultFormatStrategy(rasterNamesFactory, 3, null, false);
        StringWriter stringWriter = new StringWriter(200);
        Product product = new Product("p", "t", 10, 10);
        float wavelength = 500.0f;
        for (String rasterName : rasterNames) {
            Band band = product.addBand(rasterName, 12);
            float f = wavelength;
            wavelength = f + 1.0f;
            band.setSpectralWavelength(f);
        }
        pixExFormatStrategy.writeHeader(new PrintWriter(stringWriter), product);
        BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"# SNAP pixel extraction export table"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"#"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"# Window size: 3"));
        Assert.assertThat((Object)reader.readLine(), this.startsWith("# Created on:\t" + ProductData.UTC.createDateFormat((String)"yyyy-MM-dd").format(new Date())));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)""));
        Assert.assertThat((Object)reader.readLine(), this.startsWith("# Wavelength:\t \t \t \t \t \t \t \t \t500.0\t501.0\t502.0"));
        Assert.assertThat((Object)reader.readLine(), (Matcher)CoreMatchers.equalTo((Object)"ProdID\tCoordID\tName\tLatitude\tLongitude\tPixelX\tPixelY\tDate(yyyy-MM-dd)\tTime(HH_mm_ss)\tvarA\tvarB\tvar C"));
    }

    private Matcher<String> startsWith(final String start) {
        return new BaseMatcher<String>(){

            public boolean matches(Object o) {
                return ((String)o).startsWith(start);
            }

            public void describeTo(Description description) {
                description.appendText("Does not start with \"" + start + "\"");
            }
        };
    }

    private RasterNamesFactory newRasterNamesFactory(final String[] rasterNames) {
        return new RasterNamesFactory(){

            public String[] getRasterNames(Product product) {
                return rasterNames;
            }

            public String[] getUniqueRasterNames(Product product) {
                return this.getRasterNames(product);
            }
        };
    }
}

