/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.pixex.output.ProductIdentifier;
import org.esa.snap.pixex.output.ProductRegistry;

public class PixExProductRegistry
implements ProductRegistry {
    private static final String PRODUCT_MAP_FILE_NAME_PATTERN = "%s_productIdMap.txt";
    private final List<ProductIdentifier> productList = new ArrayList<ProductIdentifier>();
    private final String filenamePrefix;
    private final File outputDir;
    private PrintWriter productMapWriter;

    public PixExProductRegistry(String filenamePrefix, File outputDir) {
        this.filenamePrefix = filenamePrefix;
        this.outputDir = outputDir;
    }

    @Override
    public long getProductId(Product product) throws IOException {
        ProductIdentifier identifier = ProductIdentifier.create(product);
        if (!this.productList.contains(identifier)) {
            if (this.productMapWriter == null) {
                this.productMapWriter = this.createProductMapWriter();
            }
            this.productList.add(identifier);
            String productType = product.getProductType();
            this.productMapWriter.printf("%d\t%s\t%s%n", this.productList.indexOf(identifier), productType, identifier.getLocation());
            if (this.productMapWriter.checkError()) {
                throw new IOException("Error occurred while writing measurement.");
            }
        }
        return this.productList.indexOf(identifier);
    }

    @Override
    public void close() {
        if (this.productMapWriter != null) {
            this.productMapWriter.close();
        }
    }

    private PrintWriter createProductMapWriter() throws FileNotFoundException {
        String fileName = String.format(PRODUCT_MAP_FILE_NAME_PATTERN, this.filenamePrefix);
        File file = new File(this.outputDir, fileName);
        PrintWriter printWriter = new PrintWriter(new FileOutputStream(file), true);
        this.writeProductMapHeader(printWriter);
        return printWriter;
    }

    private void writeProductMapHeader(PrintWriter printWriter) {
        printWriter.printf("# Product ID Map%n", new Object[0]);
        printWriter.printf("ProductID\tProductType\tProductLocation%n", new Object[0]);
    }
}

