/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex;

import com.bc.ceres.core.ProgressMonitor;
import com.vividsolutions.jts.geom.Geometry;
import com.vividsolutions.jts.geom.Point;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.List;
import org.esa.snap.core.dataio.geometry.VectorDataNodeReader;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.PointDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.VectorDataNode;
import org.esa.snap.core.util.FeatureUtils;
import org.geotools.data.simple.SimpleFeatureIterator;
import org.geotools.feature.simple.SimpleFeatureBuilder;
import org.geotools.feature.simple.SimpleFeatureTypeBuilder;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.simple.SimpleFeatureType;
import org.opengis.feature.type.AttributeDescriptor;
import org.opengis.referencing.crs.CoordinateReferenceSystem;

public class PixExOpUtils {
    public static GeoPos getGeoPos(SimpleFeature feature) throws IOException {
        Geometry defaultGeometry = (Geometry)feature.getDefaultGeometry();
        if (defaultGeometry == null) {
            throw new IOException("Could not read geometry of feature '" + feature.getID() + "'.");
        }
        Point centroid = defaultGeometry.getCentroid();
        return new GeoPos(centroid.getY(), centroid.getX());
    }

    public static SimpleFeatureType getExtendedFeatureType(SimpleFeatureType featureType) {
        SimpleFeatureTypeBuilder builder = new SimpleFeatureTypeBuilder();
        builder.init(featureType);
        SimpleFeatureType pointFeatureType = Placemark.createPointFeatureType((String)featureType.getName().getLocalPart());
        for (AttributeDescriptor attributeDescriptor : pointFeatureType.getAttributeDescriptors()) {
            builder.add(attributeDescriptor);
        }
        List attributeDescriptors = featureType.getAttributeDescriptors();
        SimpleFeatureType extendedFeatureType = builder.buildFeatureType();
        extendedFeatureType.getUserData().put("originalAttributeDescriptors", attributeDescriptors);
        return extendedFeatureType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static List<SimpleFeature> extractFeatures(File matchupFile) throws IOException {
        ArrayList<SimpleFeature> result = new ArrayList<SimpleFeature>();
        Product dummyProduct = new Product("dummy", "dummy", 10, 10);
        SimpleFeatureIterator featureIterator = null;
        FileReader reader = null;
        try {
            reader = new FileReader(matchupFile);
            FeatureUtils.FeatureCrsProvider featureCrsProvider = new FeatureUtils.FeatureCrsProvider(){

                public CoordinateReferenceSystem getFeatureCrs(Product product) {
                    return DefaultGeographicCRS.WGS84;
                }

                public boolean clipToProductBounds() {
                    return true;
                }
            };
            VectorDataNode vdn = VectorDataNodeReader.read((String)matchupFile.getName(), (Reader)reader, (Product)dummyProduct, (FeatureUtils.FeatureCrsProvider)featureCrsProvider, (VectorDataNodeReader.PlacemarkDescriptorProvider)new VectorDataNodeReader.PlacemarkDescriptorProvider(){

                public PlacemarkDescriptor getPlacemarkDescriptor(SimpleFeatureType simpleFeatureType) {
                    return PointDescriptor.getInstance();
                }
            }, (CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, (char)'\t', (boolean)false, (ProgressMonitor)ProgressMonitor.NULL);
            SimpleFeatureType extendedFeatureType = PixExOpUtils.getExtendedFeatureType(vdn.getFeatureType());
            SimpleFeatureBuilder simpleFeatureBuilder = new SimpleFeatureBuilder(extendedFeatureType);
            featureIterator = null;
            featureIterator = vdn.getFeatureCollection().features();
            while (featureIterator.hasNext()) {
                SimpleFeature simpleFeature = (SimpleFeature)featureIterator.next();
                simpleFeatureBuilder.init(simpleFeature);
                SimpleFeature extendedFeature = simpleFeatureBuilder.buildFeature(simpleFeature.getID());
                extendedFeature.setDefaultGeometry(simpleFeature.getDefaultGeometry());
                extendedFeature.getUserData().put("originalAttributes", simpleFeature.getAttributes());
                result.add(extendedFeature);
            }
        }
        finally {
            if (featureIterator != null) {
                featureIterator.close();
            }
            if (reader != null) {
                reader.close();
            }
        }
        return result;
    }
}

