/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.Map;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.measurement.writer.FormatStrategy;
import org.esa.snap.pixex.PixExOp;
import org.esa.snap.pixex.output.PixExRasterNamesFactory;
import org.esa.snap.pixex.output.ProductRegistry;
import org.esa.snap.pixex.output.RasterNamesFactory;
import org.esa.snap.pixex.output.ScatterPlotDecoratingStrategy;
import org.jfree.chart.JFreeChart;
import org.jfree.data.xy.XYDataset;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class ScatterPlotDecoratingStrategyTest {
    private static final long PRODUCT_ID_0 = 0L;
    private static final long PRODUCT_ID_1 = 1L;
    private ScatterPlotDecoratingStrategy strategy;
    private PixExOp.VariableCombination[] variableCombinations;

    @Before
    public void setUp() throws Exception {
        Measurement[] originalMeasurements = new Measurement[]{new Measurement(0, "someName", -1L, -1.0, -1.0, null, null, new Object[]{6, 3.0}, new String[]{"original_sst", "original_tsm"}, true), new Measurement(1, "someOtherName", -1L, -1.0, -1.0, null, null, new Object[]{8, 2.0}, new String[]{"original_sst", "original_tsm"}, true)};
        this.variableCombinations = new PixExOp.VariableCombination[2];
        this.variableCombinations[0] = new PixExOp.VariableCombination();
        this.variableCombinations[0].originalVariableName = "original_sst";
        this.variableCombinations[0].productVariableName = "product_sst";
        this.variableCombinations[1] = new PixExOp.VariableCombination();
        this.variableCombinations[1].originalVariableName = "original_tsm";
        this.variableCombinations[1].productVariableName = "product_tsm";
        this.strategy = new ScatterPlotDecoratingStrategy(originalMeasurements, (FormatStrategy)new NullStrategy(), this.variableCombinations, (RasterNamesFactory)new PixExRasterNamesFactory(true, true, true, null), new ProductRegistry(){

            public long getProductId(Product product) throws IOException {
                return product.getName().equals("newProduct") ? 0L : 1L;
            }

            public void close() {
            }
        }, null, "test");
    }

    @Test
    public void testCreateScatterPlotsForSingleProduct() throws Exception {
        Measurement[] productMeasurements = new Measurement[]{new Measurement(0, "someName", 0L, -1.0, -1.0, null, null, new Object[]{7, 4.0}, true), new Measurement(1, "someOtherName", 0L, -1.0, -1.0, null, null, new Object[]{9, 3.0}, true)};
        Assert.assertTrue((boolean)this.strategy.plotMaps.isEmpty());
        Product product = ScatterPlotDecoratingStrategyTest.createProduct("newProduct");
        this.strategy.writeHeader(null, product);
        this.strategy.writeMeasurements(product, null, productMeasurements);
        Assert.assertEquals((long)1L, (long)this.strategy.plotMaps.size());
        int scatterPlotCountForProduct = ((Map)this.strategy.plotMaps.get(0L)).size();
        Assert.assertEquals((long)2L, (long)scatterPlotCountForProduct);
        JFreeChart sstPlot = (JFreeChart)((Map)this.strategy.plotMaps.get(0L)).get(this.variableCombinations[0]);
        Assert.assertEquals((Object)"original_sst", (Object)sstPlot.getXYPlot().getDomainAxis().getLabel());
        Assert.assertEquals((Object)"product_sst", (Object)sstPlot.getXYPlot().getRangeAxis().getLabel());
        Assert.assertEquals((Object)"Scatter plot of 'original_sst' and 'product_sst' for product 'newProduct'", (Object)sstPlot.getTitle().getText());
        XYDataset sstDataset = sstPlot.getXYPlot().getDataset();
        Assert.assertNotNull((Object)sstDataset);
        Assert.assertEquals((long)1L, (long)sstDataset.getSeriesCount());
        int seriesIndex = 0;
        Assert.assertEquals((long)2L, (long)sstDataset.getItemCount(0));
        Assert.assertEquals((Object)6, (Object)sstDataset.getX(seriesIndex, 0));
        Assert.assertEquals((Object)7, (Object)sstDataset.getY(seriesIndex, 0));
        Assert.assertEquals((Object)8, (Object)sstDataset.getX(seriesIndex, 1));
        Assert.assertEquals((Object)9, (Object)sstDataset.getY(seriesIndex, 1));
        JFreeChart tsmPlot = (JFreeChart)((Map)this.strategy.plotMaps.get(0L)).get(this.variableCombinations[1]);
        Assert.assertEquals((Object)"original_tsm", (Object)tsmPlot.getXYPlot().getDomainAxis().getLabel());
        Assert.assertEquals((Object)"product_tsm", (Object)tsmPlot.getXYPlot().getRangeAxis().getLabel());
        Assert.assertEquals((Object)"Scatter plot of 'original_tsm' and 'product_tsm' for product 'newProduct'", (Object)tsmPlot.getTitle().getText());
        XYDataset tsmDataset = tsmPlot.getXYPlot().getDataset();
        Assert.assertNotNull((Object)tsmDataset);
        Assert.assertEquals((long)1L, (long)tsmDataset.getSeriesCount());
        Assert.assertEquals((long)2L, (long)tsmDataset.getItemCount(0));
        Assert.assertEquals((Object)2.0, (Object)tsmDataset.getX(seriesIndex, 0));
        Assert.assertEquals((Object)3.0, (Object)tsmDataset.getY(seriesIndex, 0));
        Assert.assertEquals((Object)3.0, (Object)tsmDataset.getX(seriesIndex, 1));
        Assert.assertEquals((Object)4.0, (Object)tsmDataset.getY(seriesIndex, 1));
    }

    @Test
    public void testCreateScatterPlotsForMultipleProducts() throws Exception {
        Measurement[] productMeasurements = new Measurement[]{new Measurement(0, "someName", 0L, -1.0, -1.0, null, null, new Object[]{7, 4.0}, true), new Measurement(1, "someOtherName", 1L, -1.0, -1.0, null, null, new Object[]{9, 3.0}, true)};
        Assert.assertTrue((boolean)this.strategy.plotMaps.isEmpty());
        this.strategy.updateRasterNamesMaps(ScatterPlotDecoratingStrategyTest.createProduct("newProduct"));
        this.strategy.writeMeasurements(ScatterPlotDecoratingStrategyTest.createProduct("newProduct_1"), null, productMeasurements);
        Assert.assertEquals((long)2L, (long)this.strategy.plotMaps.size());
        int scatterPlotCountForFirstProduct = ((Map)this.strategy.plotMaps.get(0L)).size();
        Assert.assertEquals((long)2L, (long)scatterPlotCountForFirstProduct);
        int scatterPlotCountForSecondProduct = ((Map)this.strategy.plotMaps.get(1L)).size();
        Assert.assertEquals((long)2L, (long)scatterPlotCountForSecondProduct);
    }

    @Test
    public void testFillRasterNamesIndicesMap() {
        Product product = ScatterPlotDecoratingStrategyTest.createProduct("newProduct");
        this.strategy.updateRasterNamesMaps(product);
        Map rasterIndices = (Map)this.strategy.rasterNamesIndices.get(0L);
        Assert.assertNotNull((Object)rasterIndices);
        Assert.assertEquals((long)2L, (long)rasterIndices.size());
        Assert.assertEquals((long)0L, (long)((Integer)rasterIndices.get("product_sst")).intValue());
        Assert.assertEquals((long)1L, (long)((Integer)rasterIndices.get("product_tsm")).intValue());
    }

    private static Product createProduct(String productName) {
        Product product = new Product(productName, "type", 10, 10);
        product.addBand("product_sst", 12);
        product.addBand("product_tsm", 30);
        return product;
    }

    private class NullStrategy
    implements FormatStrategy {
        private NullStrategy() {
        }

        public void writeHeader(PrintWriter writer, Product product) {
        }

        public void writeMeasurements(Product product, PrintWriter writer, Measurement[] measurements) {
        }

        public void finish() {
        }
    }
}

