/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.BufferedReader;
import java.io.PrintWriter;
import java.io.StringReader;
import java.io.StringWriter;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.pixex.output.MatchupFormatStrategy;
import org.junit.Assert;
import org.junit.Test;

public class MatchupFormatStrategyTest {
    @Test
    public void testWriteMeasurements_oneMeasurement_withNaN() throws Exception {
        Object[] values = new Number[]{12.4, Double.NaN, 1.0345, 7};
        Measurement measurement = new Measurement(14, "name", 13L, 1.0, 1.0, null, new GeoPos(10.0, 10.0), values, true);
        Object[] originalValues = new Number[]{13.4, Double.NaN, 2.0345, 12};
        Measurement originalMeasurement = new Measurement(14, null, -1L, -1.0, -1.0, null, new GeoPos((double)10.1f, (double)10.01f), originalValues, new String[]{"sst", "tsm", "pigs", "cows"}, true);
        MatchupFormatStrategy pixExFormat = new MatchupFormatStrategy(new Measurement[]{originalMeasurement}, null, 1, "expression", false);
        StringWriter stringWriter = new StringWriter();
        pixExFormat.writeMeasurements(null, new PrintWriter(stringWriter), new Measurement[]{measurement});
        BufferedReader reader = new BufferedReader(new StringReader(stringWriter.toString()));
        String originalMeasurementString = "13.4\t\t2.0345\t12";
        String newMeasurementString = "\t13\t14\tname\t10.000000\t10.000000\t1.000\t1.000\t \t \t12.4\t\t1.0345\t7";
        junit.framework.Assert.assertEquals((String)(originalMeasurementString + newMeasurementString), (String)reader.readLine());
        Assert.assertNull((Object)reader.readLine());
    }

    @Test
    public void testWriteTwoMeasurements() throws Exception {
        Measurement originalMeasurement1 = MatchupFormatStrategyTest.createMeasurement(14, new String[]{"sst", "tsm"}, "_1");
        Measurement originalMeasurement2 = MatchupFormatStrategyTest.createMeasurement(23, new String[]{"pigs", "cows"}, "_2");
        Object[] values = new Number[]{12.4, 7};
        Measurement additionalMeasurement = new Measurement(14, "name", 13L, 1.0, 1.0, null, new GeoPos(10.0, 10.0), values, true);
        MatchupFormatStrategy pixExFormat = new MatchupFormatStrategy(new Measurement[]{originalMeasurement1, originalMeasurement2}, null, 1, "expression", false);
        StringWriter stringWriter = new StringWriter();
        pixExFormat.writeMeasurements(null, new PrintWriter(stringWriter), new Measurement[]{additionalMeasurement});
        String originalMeasurementString = "value1_1\tvalue2_1\t\t";
        String newMeasurementString = "\t13\t14\tname\t10.000000\t10.000000\t1.000\t1.000\t \t \t12.4\t7\n";
        junit.framework.Assert.assertEquals((String)(originalMeasurementString + newMeasurementString), (String)stringWriter.toString());
        additionalMeasurement = new Measurement(23, "name", 13L, 1.0, 1.0, null, new GeoPos(10.0, 10.0), values, true);
        stringWriter = new StringWriter();
        pixExFormat.writeMeasurements(null, new PrintWriter(stringWriter), new Measurement[]{additionalMeasurement});
        originalMeasurementString = "\t\tvalue1_2\tvalue2_2";
        newMeasurementString = "\t13\t23\tname\t10.000000\t10.000000\t1.000\t1.000\t \t \t12.4\t7\n";
        junit.framework.Assert.assertEquals((String)(originalMeasurementString + newMeasurementString), (String)stringWriter.toString());
    }

    private static Measurement createMeasurement(int coordinateId, String[] attributeNames, String msmntIndex) {
        Object[] originalValues = new Object[]{"value1" + msmntIndex, "value2" + msmntIndex};
        return new Measurement(coordinateId, null, -1L, -1.0, -1.0, null, new GeoPos((double)10.1f, (double)10.01f), originalValues, attributeNames, true);
    }
}

