/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.awt.Rectangle;
import java.io.PrintWriter;
import java.io.StringWriter;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.pixex.output.AbstractFormatStrategy;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AbstractFormatStrategyTest_writeData {
    private AbstractFormatStrategy abstractFormatStrategy;
    private PrintWriter printWriter;
    private StringWriter stringWriter;

    @Before
    public void setUp() throws Exception {
        this.abstractFormatStrategy = new AbstractFormatStrategy(null, null, 1, true){

            public void writeHeader(PrintWriter writer, Product product) {
            }

            public void writeMeasurements(Product product, PrintWriter writer, Measurement[] measurements) {
            }
        };
        this.stringWriter = new StringWriter();
        this.printWriter = new PrintWriter(this.stringWriter);
    }

    @After
    public void tearDown() throws Exception {
    }

    @Test
    public void testWriteValue_Double_NAN() {
        this.abstractFormatStrategy.writeValue(this.printWriter, (Object)Double.NaN);
        Assert.assertEquals((Object)"", (Object)this.stringWriter.toString());
    }

    @Test
    public void testWriteValue_Double_24Dot65() {
        this.abstractFormatStrategy.writeValue(this.printWriter, (Object)24.65);
        Assert.assertEquals((Object)"24.65", (Object)this.stringWriter.toString());
    }

    @Test
    public void testWriteValue_Float_16Dot23() {
        this.abstractFormatStrategy.writeValue(this.printWriter, (Object)Float.valueOf(16.23f));
        Assert.assertEquals((Object)"16.23", (Object)this.stringWriter.toString());
    }

    @Test
    public void testWriteValue_AnyObject_egRectangle() {
        this.abstractFormatStrategy.writeValue(this.printWriter, (Object)new Rectangle(3, 4, 5, 6));
        Assert.assertEquals((Object)"java.awt.Rectangle[x=3,y=4,width=5,height=6]", (Object)this.stringWriter.toString());
    }

    @Test
    public void testWriteValue_null() {
        this.abstractFormatStrategy.writeValue(this.printWriter, null);
        Assert.assertEquals((Object)"", (Object)this.stringWriter.toString());
    }
}

