/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex;

import java.awt.Rectangle;
import java.awt.image.Raster;
import java.io.File;
import java.util.ArrayList;
import java.util.Date;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import junit.framework.Assert;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.measurement.writer.FormatStrategy;
import org.esa.snap.measurement.writer.MeasurementFactory;
import org.esa.snap.measurement.writer.MeasurementWriter;
import org.esa.snap.pixex.MeasurementWriterTest;
import org.esa.snap.pixex.PixExMeasurementReader;
import org.esa.snap.pixex.output.DefaultFormatStrategy;
import org.esa.snap.pixex.output.PixExMeasurementFactory;
import org.esa.snap.pixex.output.PixExProductRegistry;
import org.esa.snap.pixex.output.PixExRasterNamesFactory;
import org.esa.snap.pixex.output.ProductRegistry;
import org.esa.snap.pixex.output.RasterNamesFactory;
import org.esa.snap.pixex.output.TargetWriterFactoryAndMap;
import org.junit.Before;
import org.junit.Test;

public class PixExMeasurementReaderTest {
    private File inputDir;
    private int windowSize;

    @Before
    public void setup() throws Exception {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.inputDir = new File(tmpDir, this.getClass().getSimpleName());
        if (!this.inputDir.mkdir()) {
            for (File file : this.inputDir.listFiles()) {
                file.delete();
            }
        }
        this.windowSize = 3;
        int upperLeftX = 20;
        int upperLeftY = 42;
        int centerX = 21;
        int centerY = 43;
        int width = 360;
        int height = 180;
        boolean exportMasks = false;
        String filenamePrefix = "MeasurementReaderTest";
        String expression = "expression";
        boolean exportExpressionResult = true;
        PixExRasterNamesFactory rasterNamesFactory = new PixExRasterNamesFactory(true, true, false, null);
        PixExProductRegistry productRegistry = new PixExProductRegistry("MeasurementReaderTest", this.inputDir);
        PixExMeasurementFactory measurementFactory = new PixExMeasurementFactory((RasterNamesFactory)rasterNamesFactory, this.windowSize, (ProductRegistry)productRegistry);
        TargetWriterFactoryAndMap targetFactory = new TargetWriterFactoryAndMap("MeasurementReaderTest", this.inputDir);
        DefaultFormatStrategy formatStrategy = new DefaultFormatStrategy((RasterNamesFactory)rasterNamesFactory, this.windowSize, "expression", true);
        MeasurementWriter writer = new MeasurementWriter((MeasurementFactory)measurementFactory, targetFactory, (FormatStrategy)formatStrategy);
        String[] radianceNames = new String[]{"rad_1", "rad_2", "rad_3"};
        Product p1 = MeasurementWriterTest.createTestProduct("N1", "T1", radianceNames, 360, 180);
        Product p2 = MeasurementWriterTest.createTestProduct("N2", "T1", radianceNames, 360, 180);
        String[] reflectNames = new String[]{"refl_1", "refl_2", "refl_3"};
        Product p3 = MeasurementWriterTest.createTestProduct("N3", "T2", reflectNames, 360, 180);
        RenderedOp renderedOp = ConstantDescriptor.create((Float)Float.valueOf(360.0f), (Float)Float.valueOf(180.0f), (Number[])new Byte[]{(byte)-1}, null);
        Raster validData = renderedOp.getData(new Rectangle(20, 42, this.windowSize, this.windowSize));
        writer.writeMeasurements(21, 43, 0, "coord0", p1, validData);
        writer.writeMeasurements(21, 43, 1, "coord1", p1, validData);
        writer.writeMeasurements(21, 43, 2, "coord2", p2, validData);
        writer.writeMeasurements(21, 43, 3, "coord3", p2, validData);
        writer.writeMeasurements(21, 43, 4, "coord4", p3, validData);
        writer.writeMeasurements(21, 43, 5, "coord5", p3, validData);
    }

    @Test
    public void testReading() {
        PixExMeasurementReader reader = new PixExMeasurementReader(this.inputDir);
        ArrayList<Measurement> measurementList = new ArrayList<Measurement>();
        while (reader.hasNext()) {
            measurementList.add(reader.next());
        }
        Assert.assertEquals((int)(this.windowSize * this.windowSize * 6), (int)measurementList.size());
        this.testForExistingMeasurement(measurementList, 0, "coord0");
        this.testForExistingMeasurement(measurementList, 1, "coord1");
        this.testForExistingMeasurement(measurementList, 2, "coord2");
        this.testForExistingMeasurement(measurementList, 3, "coord3");
        this.testForExistingMeasurement(measurementList, 4, "coord4");
        this.testForExistingMeasurement(measurementList, 5, "coord5");
    }

    @Test
    public void testReadingWithEmptyColumns() throws Exception {
        Measurement measurement = PixExMeasurementReader.readMeasurement((String)"12\t83744\t10083743\t57.936592\t10.130839\t520.5\t240.5\t2005-07-09\t10:12:03\t65.272634\t \t42.278252\t0\t500", (boolean)false);
        Assert.assertEquals((long)12L, (long)measurement.getProductId());
        Assert.assertEquals((int)83744, (int)measurement.getCoordinateID());
        Assert.assertEquals((String)"10083743", (String)measurement.getCoordinateName());
        Assert.assertEquals((double)57.93659210205078, (double)measurement.getLat(), (double)1.0E-6);
        Assert.assertEquals((double)10.130839, (double)measurement.getLon(), (double)1.0E-6);
        Assert.assertEquals((double)520.5, (double)measurement.getPixelX(), (double)1.0E-6);
        Assert.assertEquals((double)240.5, (double)measurement.getPixelY(), (double)1.0E-6);
        Date expectedDate = ProductData.UTC.parse((String)"2005-07-09T10:12:03", (String)"yyyy-MM-dd'T'hh:mm:ss").getAsDate();
        Assert.assertEquals((Object)expectedDate, (Object)measurement.getTime().getAsDate());
        Object[] values = measurement.getValues();
        Assert.assertEquals((double)65.272634, (double)((Number)values[0]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)Double.NaN, (double)((Number)values[1]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((double)42.278252, (double)((Number)values[2]).doubleValue(), (double)1.0E-6);
        Assert.assertEquals((int)0, (int)((Number)values[3]).intValue());
        Assert.assertEquals((int)500, (int)((Number)values[4]).intValue());
    }

    @Test(expected=UnsupportedOperationException.class)
    public void testRemoveThrowsException() {
        PixExMeasurementReader reader = new PixExMeasurementReader(this.inputDir);
        reader.remove();
    }

    private void testForExistingMeasurement(ArrayList<Measurement> measurementList, int coordId, String coordName) {
        for (Measurement measurement : measurementList) {
            if (measurement.getCoordinateID() != coordId || !measurement.getCoordinateName().equals(coordName) || Double.compare(measurement.getPixelX(), 20.5) != 0 || Double.compare(measurement.getPixelY(), 42.5) != 0) continue;
            return;
        }
        Assert.fail((String)("Measurement with name '" + coordName + "' not found"));
    }
}

