/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.aggregators;

import org.esa.snap.pixex.aggregators.MeanAggregatorStrategy;
import org.esa.snap.pixex.calvalus.ma.DefaultRecord;
import org.esa.snap.pixex.calvalus.ma.Record;
import org.junit.Assert;
import org.junit.Test;

public class MeanAggregatorStrategyTest {
    @Test
    public void testGetValueForAggregatedNumber() throws Exception {
        MeanAggregatorStrategy meanStrategy = new MeanAggregatorStrategy();
        Float[] valuesForBand1 = new Float[]{Float.valueOf(1.0f), Float.valueOf(2.0f), Float.valueOf(3.0f), Float.valueOf(4.0f), Float.valueOf(5.0f), Float.valueOf(6.0f)};
        Integer[] valuesForBand2 = new Integer[]{2, 3, 4, 5, 6, 7};
        Number[][] numbers = new Number[][]{valuesForBand1, valuesForBand2};
        DefaultRecord defaultRecord = new DefaultRecord((Object[])numbers);
        Assert.assertEquals((long)3L, (long)meanStrategy.getValueCount());
        Number[] firstBandValues = meanStrategy.getValues((Record)defaultRecord, 0);
        Number[] secondBandValues = meanStrategy.getValues((Record)defaultRecord, 1);
        Assert.assertEquals((long)3L, (long)firstBandValues.length);
        Assert.assertEquals((long)3L, (long)secondBandValues.length);
        Assert.assertEquals((double)3.5, (double)firstBandValues[0].doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.8708f, (double)firstBandValues[1].doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)4.5, (double)secondBandValues[0].doubleValue(), (double)1.0E-4);
        Assert.assertEquals((double)1.8708f, (double)secondBandValues[1].doubleValue(), (double)1.0E-4);
    }
}

