/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.IOException;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.pixex.aggregators.AggregatorStrategy;
import org.esa.snap.pixex.aggregators.MaxAggregatorStrategy;
import org.esa.snap.pixex.aggregators.MeanAggregatorStrategy;
import org.esa.snap.pixex.aggregators.MedianAggregatorStrategy;
import org.esa.snap.pixex.aggregators.MinAggregatorStrategy;
import org.esa.snap.pixex.output.AggregatingPixExMeasurementFactory;
import org.esa.snap.pixex.output.ProductRegistry;
import org.esa.snap.pixex.output.RasterNamesFactory;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class AggregatingPixExMeasurementFactoryTest {
    private Product product;
    private RasterNamesFactory rasterNamesFactory;
    private ProductRegistry productRegistry;
    private int windowSize;

    @Before
    public void setUp() throws Exception {
        this.product = new Product("name", "type", 4, 4);
        Band band1 = this.product.addBand("val1", 12);
        this.fillValues(band1, 11);
        Band band2 = this.product.addBand("val2", 30);
        this.fillValues(band2, 20);
        this.rasterNamesFactory = this.createNewRasterNamesFactory();
        this.productRegistry = this.createNewProductRegistry();
        this.windowSize = 3;
    }

    @Test
    public void testCreateMeasurementsWithMeanMeasurementAggregator() throws Exception {
        MeanAggregatorStrategy aggregatorStrategy = new MeanAggregatorStrategy();
        AggregatingPixExMeasurementFactory factory = new AggregatingPixExMeasurementFactory(this.rasterNamesFactory, this.windowSize, this.productRegistry, (AggregatorStrategy)aggregatorStrategy);
        boolean pixelX = true;
        boolean pixelY = true;
        int coordinateID = 2345;
        String coordsName = "coordsName";
        Measurement[] measurements = factory.createMeasurements(1, 1, 2345, "coordsName", this.product, null);
        Assert.assertEquals((long)1L, (long)measurements.length);
        Measurement expectedMeasurement = new Measurement(2345, "coordsName", 1234L, 1.5, 1.5, null, new GeoPos(), (Object[])new Number[]{Float.valueOf(17.0f), Float.valueOf(3.5707142f), 9, Float.valueOf(25.5f), Float.valueOf(3.5707142f), 9}, true);
        Assert.assertEquals((Object)expectedMeasurement, (Object)measurements[0]);
    }

    @Test
    public void testCreateMeasurementsWithMinMeasurementAggregator() throws Exception {
        MinAggregatorStrategy aggregatorStrategy = new MinAggregatorStrategy();
        AggregatingPixExMeasurementFactory factory = new AggregatingPixExMeasurementFactory(this.rasterNamesFactory, this.windowSize, this.productRegistry, (AggregatorStrategy)aggregatorStrategy);
        boolean pixelX = true;
        boolean pixelY = true;
        int coordinateID = 2345;
        String coordsName = "coordsName";
        Measurement[] measurements = factory.createMeasurements(1, 1, 2345, "coordsName", this.product, null);
        Assert.assertEquals((long)1L, (long)measurements.length);
        Measurement expectedMeasurement = this.createExpectedMeasurement(1, 1, 2345, "coordsName", Float.valueOf(12.0f), 9, Float.valueOf(20.5f), 9);
        Assert.assertEquals((Object)expectedMeasurement, (Object)measurements[0]);
    }

    @Test
    public void testCreateMeasurementsWithMaxMeasurementAggregator() throws Exception {
        MaxAggregatorStrategy aggregatorStrategy = new MaxAggregatorStrategy();
        AggregatingPixExMeasurementFactory factory = new AggregatingPixExMeasurementFactory(this.rasterNamesFactory, this.windowSize, this.productRegistry, (AggregatorStrategy)aggregatorStrategy);
        boolean pixelX = true;
        boolean pixelY = true;
        int coordinateID = 2345;
        String coordsName = "coordsName";
        Measurement[] measurements = factory.createMeasurements(1, 1, 2345, "coordsName", this.product, null);
        Assert.assertEquals((long)1L, (long)measurements.length);
        Measurement expectedMeasurement = this.createExpectedMeasurement(1, 1, 2345, "coordsName", Float.valueOf(22.0f), 9, Float.valueOf(30.5f), 9);
        Assert.assertEquals((Object)expectedMeasurement, (Object)measurements[0]);
    }

    @Test
    public void testCreateMeasurementsWithMedianMeasurementAggregator() throws Exception {
        MedianAggregatorStrategy aggregatorStrategy = new MedianAggregatorStrategy();
        AggregatingPixExMeasurementFactory factory = new AggregatingPixExMeasurementFactory(this.rasterNamesFactory, this.windowSize, this.productRegistry, (AggregatorStrategy)aggregatorStrategy);
        boolean pixelX = true;
        boolean pixelY = true;
        int coordinateID = 2345;
        String coordsName = "coordsName";
        Measurement[] measurements = factory.createMeasurements(1, 1, 2345, "coordsName", this.product, null);
        Assert.assertEquals((long)1L, (long)measurements.length);
        Measurement expectedMeasurement = this.createExpectedMeasurement(1, 1, 2345, "coordsName", Float.valueOf(17.0f), 9, Float.valueOf(25.5f), 9);
        Assert.assertEquals((Object)expectedMeasurement, (Object)measurements[0]);
    }

    @Test
    public void testMeanWithFillValues_float() throws Exception {
        MeanAggregatorStrategy aggregatorStrategy = new MeanAggregatorStrategy();
        AggregatingPixExMeasurementFactory factory = new AggregatingPixExMeasurementFactory(this.rasterNamesFactory, 5, this.productRegistry, (AggregatorStrategy)aggregatorStrategy);
        Product fillValueContainingProduct = new Product("p0", "t0", 5, 5);
        Band band = fillValueContainingProduct.addBand("b0", 30);
        band.setNoDataValue(-1.0);
        band.setData((ProductData)new ProductData.Float(new float[]{1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, 1.0f, -1.0f, -1.0f, -1.0f, -1.0f, -1.0f}));
        int pixelX = 2;
        int pixelY = 2;
        int coordinateID = 2345;
        String coordsName = "coordsName";
        Measurement[] measurements = factory.createMeasurements(2, 2, 2345, "coordsName", fillValueContainingProduct, null);
        Assert.assertEquals((long)1L, (long)measurements.length);
        Object[] expectedValues = new Number[]{Float.valueOf(1.0f), Float.valueOf(0.0f), 20};
        Measurement expectedMeasurement = new Measurement(2345, "coordsName", 1234L, 2.5, 2.5, null, new GeoPos(), expectedValues, true);
        Assert.assertEquals((Object)expectedMeasurement, (Object)measurements[0]);
    }

    @Test
    public void testMeanWithFillValues_int() throws Exception {
        MeanAggregatorStrategy aggregatorStrategy = new MeanAggregatorStrategy();
        AggregatingPixExMeasurementFactory factory = new AggregatingPixExMeasurementFactory(this.rasterNamesFactory, 5, this.productRegistry, (AggregatorStrategy)aggregatorStrategy);
        Product fillValueContainingProduct = new Product("p0", "t0", 5, 5);
        Band band = fillValueContainingProduct.addBand("b0", 11);
        band.setNoDataValue(16.0);
        band.setData((ProductData)new ProductData.Short(new short[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 16, 16, 16, 16, 16}));
        int pixelX = 2;
        int pixelY = 2;
        int coordinateID = 2345;
        String coordsName = "coordsName";
        Measurement[] measurements = factory.createMeasurements(2, 2, 2345, "coordsName", fillValueContainingProduct, null);
        Assert.assertEquals((long)1L, (long)measurements.length);
        Object[] expectedValues = new Number[]{Float.valueOf(1.0f), Float.valueOf(0.0f), 20};
        Measurement expectedMeasurement = new Measurement(2345, "coordsName", 1234L, 2.5, 2.5, null, new GeoPos(), expectedValues, true);
        Assert.assertEquals((Object)expectedMeasurement, (Object)measurements[0]);
    }

    @Test
    public void testMeanWithFillValues_uint32() throws Exception {
        MeanAggregatorStrategy aggregatorStrategy = new MeanAggregatorStrategy();
        AggregatingPixExMeasurementFactory factory = new AggregatingPixExMeasurementFactory(this.rasterNamesFactory, 5, this.productRegistry, (AggregatorStrategy)aggregatorStrategy);
        Product fillValueContainingProduct = new Product("p0", "t0", 5, 5);
        Band band = fillValueContainingProduct.addBand("b0", 22);
        band.setNoDataValue(16.0);
        band.setData((ProductData)new ProductData.UInt(new int[]{1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 16, 16, 16, 16, 16}));
        int pixelX = 2;
        int pixelY = 2;
        int coordinateID = 2345;
        String coordsName = "coordsName";
        Measurement[] measurements = factory.createMeasurements(2, 2, 2345, "coordsName", fillValueContainingProduct, null);
        Assert.assertEquals((long)1L, (long)measurements.length);
        Object[] expectedValues = new Number[]{Float.valueOf(1.0f), Float.valueOf(0.0f), 20};
        Measurement expectedMeasurement = new Measurement(2345, "coordsName", 1234L, 2.5, 2.5, null, new GeoPos(), expectedValues, true);
        Assert.assertEquals((Object)expectedMeasurement, (Object)measurements[0]);
    }

    private Measurement createExpectedMeasurement(int pixelX, int pixelY, int coordinateID, String coordsName, Number ... expectedValues) throws IOException {
        Object[] values = new Number[expectedValues.length];
        System.arraycopy(expectedValues, 0, values, 0, values.length);
        long productId = this.productRegistry.getProductId(this.product);
        return new Measurement(coordinateID, coordsName, productId, (double)((float)pixelX + 0.5f), (double)((float)pixelY + 0.5f), null, new GeoPos(), values, true);
    }

    private ProductRegistry createNewProductRegistry() {
        return new ProductRegistry(){

            public long getProductId(Product product) {
                return 1234L;
            }

            public void close() {
            }
        };
    }

    private RasterNamesFactory createNewRasterNamesFactory() {
        return new RasterNamesFactory(){

            public String[] getRasterNames(Product product) {
                return product.getBandNames();
            }

            public String[] getUniqueRasterNames(Product product) {
                return this.getRasterNames(product);
            }
        };
    }

    private void fillValues(Band band, int offset) {
        ProductData data = band.createCompatibleRasterData();
        int numElems = data.getNumElems();
        for (int i = 0; i < numElems; ++i) {
            data.setElemFloatAt(i, (float)(0.5 + (double)i + (double)offset));
        }
        band.setData(data);
    }
}

