/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.io.File;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.HashMap;
import java.util.Map;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.measurement.writer.FormatStrategy;
import org.esa.snap.pixex.PixExOp;
import org.esa.snap.pixex.output.MatchupFormatStrategy;
import org.esa.snap.pixex.output.ProductRegistry;
import org.esa.snap.pixex.output.RasterNamesFactory;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartUtilities;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.data.xy.XYDataset;
import org.jfree.data.xy.XYSeries;
import org.jfree.data.xy.XYSeriesCollection;

public class ScatterPlotDecoratingStrategy
implements FormatStrategy {
    private final Measurement[] originalMeasurements;
    private final FormatStrategy decoratedStrategy;
    private final PixExOp.VariableCombination[] scatterPlotVariableCombinations;
    final Map<Long, Map<String, Integer>> rasterNamesIndices = new HashMap<Long, Map<String, Integer>>();
    final Map<Long, Map<PixExOp.VariableCombination, JFreeChart>> plotMaps = new HashMap<Long, Map<PixExOp.VariableCombination, JFreeChart>>();
    private final RasterNamesFactory rasterNamesFactory;
    private final ProductRegistry productRegistry;
    private final Map<Long, String> productNames = new HashMap<Long, String>();
    private final File parent;
    private final String filePrefix;

    public ScatterPlotDecoratingStrategy(Measurement[] originalMeasurements, FormatStrategy decoratedStrategy, PixExOp.VariableCombination[] scatterPlotVariableCombinations, RasterNamesFactory rasterNamesFactory, ProductRegistry productRegistry, File parentDirectory, String filePrefix) {
        this.originalMeasurements = originalMeasurements;
        this.decoratedStrategy = decoratedStrategy;
        this.scatterPlotVariableCombinations = scatterPlotVariableCombinations;
        this.rasterNamesFactory = rasterNamesFactory;
        this.productRegistry = productRegistry;
        this.parent = parentDirectory;
        this.filePrefix = filePrefix;
    }

    @Override
    public void writeHeader(PrintWriter writer, Product product) {
        this.decoratedStrategy.writeHeader(writer, product);
    }

    void updateRasterNamesMaps(Product product) {
        long productId = this.getProductId(product);
        this.productNames.put(productId, product.getName());
        if (!this.rasterNamesIndices.containsKey(productId)) {
            this.rasterNamesIndices.put(productId, new HashMap());
        }
        String[] rasterNames = this.rasterNamesFactory.getRasterNames(product);
        for (int i = 0; i < rasterNames.length; ++i) {
            String rasterName = rasterNames[i];
            this.rasterNamesIndices.get(productId).put(rasterName, i);
        }
    }

    private long getProductId(Product product) {
        long productId;
        try {
            productId = this.productRegistry.getProductId(product);
        }
        catch (IOException e) {
            throw new IllegalStateException("Should never come here", e);
        }
        return productId;
    }

    @Override
    public void writeMeasurements(Product product, PrintWriter writer, Measurement[] measurements) {
        this.updateRasterNamesMaps(product);
        this.decoratedStrategy.writeMeasurements(product, writer, measurements);
        for (PixExOp.VariableCombination variableCombination : this.scatterPlotVariableCombinations) {
            if (!this.combinationHasData(variableCombination.productVariableName, measurements)) continue;
            this.addData(variableCombination, measurements);
        }
    }

    @Override
    public void finish() {
        for (Map.Entry<Long, Map<PixExOp.VariableCombination, JFreeChart>> mapEntry : this.plotMaps.entrySet()) {
            Map<PixExOp.VariableCombination, JFreeChart> plots = mapEntry.getValue();
            Long productId = mapEntry.getKey();
            for (Map.Entry<PixExOp.VariableCombination, JFreeChart> entry : plots.entrySet()) {
                PixExOp.VariableCombination variableCombination = entry.getKey();
                try {
                    File targetFile = new File(this.parent, String.format("%s_scatter_plot_%s_%s_%s.png", this.filePrefix, variableCombination.originalVariableName, variableCombination.productVariableName, this.productNames.get(productId)));
                    ChartUtilities.saveChartAsPNG((File)targetFile, (JFreeChart)entry.getValue(), (int)600, (int)400);
                }
                catch (IOException e) {
                    SystemUtils.LOG.warning(e.getMessage());
                }
            }
        }
    }

    private void addData(PixExOp.VariableCombination variableCombination, Measurement[] measurements) {
        for (Measurement measurement : measurements) {
            this.addData(variableCombination, measurement);
        }
    }

    private void addData(PixExOp.VariableCombination variableCombination, Measurement measurement) {
        long productId = measurement.getProductId();
        this.initPlotMaps(productId);
        XYSeries xySeries = this.getXYSeries(variableCombination, productId);
        Measurement originalMeasurement = MatchupFormatStrategy.findMatchingMeasurement(measurement, this.originalMeasurements);
        if (!this.combinationHasData(variableCombination.productVariableName, measurement.getProductId())) {
            return;
        }
        String[] originalAttributeNames = originalMeasurement.getOriginalAttributeNames();
        String originalValue = "";
        for (int i = 0; i < originalAttributeNames.length; ++i) {
            String attributeName = originalAttributeNames[i];
            if (!attributeName.equals(variableCombination.originalVariableName)) continue;
            originalValue = originalMeasurement.getValues()[i].toString();
            break;
        }
        Object value = this.getValue(variableCombination.productVariableName, measurement);
        xySeries.add(this.getOriginalMeasurementAsNumber(originalValue), (Number)value);
    }

    private XYSeries getXYSeries(PixExOp.VariableCombination variableCombination, long productId) {
        XYSeries xySeries;
        if (this.plotMaps.get(productId).containsKey(variableCombination)) {
            xySeries = ((XYSeriesCollection)this.plotMaps.get(productId).get(variableCombination).getXYPlot().getDataset()).getSeries(0);
        } else {
            xySeries = new XYSeries((Comparable)((Object)"data"));
            JFreeChart scatterPlot = this.createScatterPlot(variableCombination, xySeries, productId);
            this.plotMaps.get(productId).put(variableCombination, scatterPlot);
        }
        return xySeries;
    }

    private JFreeChart createScatterPlot(PixExOp.VariableCombination variableCombination, XYSeries dataset, long productId) {
        XYSeriesCollection data = new XYSeriesCollection();
        data.addSeries(dataset);
        String scatterPlotName = String.format("Scatter plot of '%s' and '%s' for product '%s'", variableCombination.originalVariableName, variableCombination.productVariableName, this.productNames.get(productId));
        return ChartFactory.createScatterPlot((String)scatterPlotName, (String)variableCombination.originalVariableName, (String)variableCombination.productVariableName, (XYDataset)data, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)false, (boolean)false, (boolean)false);
    }

    private void initPlotMaps(long productId) {
        if (!this.plotMaps.containsKey(productId)) {
            this.plotMaps.put(productId, new HashMap());
        }
    }

    private Number getOriginalMeasurementAsNumber(String value) {
        if (StringUtils.isNumeric((String)value, Integer.class)) {
            return Integer.parseInt(value);
        }
        if (StringUtils.isNumeric((String)value, Double.class)) {
            return Double.parseDouble(value);
        }
        if (StringUtils.isNumeric((String)value, Byte.class)) {
            return Byte.parseByte(value);
        }
        if (StringUtils.isNumeric((String)value, Float.class)) {
            return Float.valueOf(Float.parseFloat(value));
        }
        if (StringUtils.isNumeric((String)value, Long.class)) {
            return Long.parseLong(value);
        }
        if (StringUtils.isNumeric((String)value, Short.class)) {
            return Short.parseShort(value);
        }
        return Double.NaN;
    }

    private Object getValue(String productVariableName, Measurement measurement) {
        long productId = measurement.getProductId();
        int columnIndex = this.rasterNamesIndices.get(productId).get(productVariableName);
        return measurement.getValues()[columnIndex];
    }

    private boolean combinationHasData(String productVariableName, Measurement[] measurements) {
        for (Measurement measurement : measurements) {
            long productId = measurement.getProductId();
            if (!this.combinationHasData(productVariableName, productId)) continue;
            return true;
        }
        return false;
    }

    private boolean combinationHasData(String productVariableName, long productId) {
        return this.rasterNamesIndices.containsKey(productId) && this.rasterNamesIndices.get(productId).containsKey(productVariableName);
    }
}

