/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import java.awt.image.Raster;
import java.io.IOException;
import java.util.ArrayList;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.pixex.output.AbstractMeasurementFactory;
import org.esa.snap.pixex.output.ProductRegistry;
import org.esa.snap.pixex.output.RasterNamesFactory;

public class PixExMeasurementFactory
extends AbstractMeasurementFactory {
    private final RasterNamesFactory rasterNamesFactory;
    private final int windowSize;
    private final ProductRegistry productRegistry;

    public PixExMeasurementFactory(RasterNamesFactory rasterNamesFactory, int windowSize, ProductRegistry productRegistry) {
        this.rasterNamesFactory = rasterNamesFactory;
        this.windowSize = windowSize;
        this.productRegistry = productRegistry;
    }

    @Override
    public Measurement[] createMeasurements(int centerX, int centerY, int coordinateID, String coordinateName, Product product, Raster validData) throws IOException {
        long productId = this.productRegistry.getProductId(product);
        int numPixels = this.windowSize * this.windowSize;
        ArrayList<Measurement> measurements = new ArrayList<Measurement>();
        String[] rasterNames = this.rasterNamesFactory.getRasterNames(product);
        Number[] values = new Number[rasterNames.length];
        int windowBorder = this.windowSize / 2;
        for (int idx = 0; idx < numPixels; ++idx) {
            int offsetX = idx % this.windowSize;
            int offsetY = idx / this.windowSize;
            int x = centerX - windowBorder + offsetX;
            int y = centerY - windowBorder + offsetY;
            PixExMeasurementFactory.setBandValues(product, rasterNames, x, y, values);
            boolean isValid = validData == null || validData.getSample(x, y, 0) != 0;
            measurements.add(PixExMeasurementFactory.createMeasurement(product, productId, coordinateID, coordinateName, values, isValid, x, y));
        }
        return measurements.toArray(new Measurement[measurements.size()]);
    }

    @Override
    public void close() {
        this.productRegistry.close();
    }
}

