/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex.output;

import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Mask;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.datamodel.RasterDataNode;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.measurement.writer.MeasurementFactory;

public abstract class AbstractMeasurementFactory
implements MeasurementFactory {
    protected static Measurement createMeasurement(Product product, long productId, int coordinateID, String coordinateName, Number[] values, boolean isValid, int x, int y) {
        PixelPos pixelPos = new PixelPos((double)((float)x + 0.5f), (double)((float)y + 0.5f));
        GeoCoding geoCoding = product.getSceneGeoCoding();
        GeoPos currentGeoPos = geoCoding != null ? geoCoding.getGeoPos(pixelPos, null) : new GeoPos();
        ProductData.UTC scanLineTime = ProductUtils.getScanLineTime((Product)product, (double)pixelPos.y);
        return new Measurement(coordinateID, coordinateName, productId, pixelPos.x, pixelPos.y, scanLineTime, currentGeoPos, values, isValid);
    }

    protected static void setBandValues(Product product, String[] rasterNames, int x, int y, Number[] bandValues) {
        for (int i = 0; i < rasterNames.length; ++i) {
            RasterDataNode raster = product.getRasterDataNode(rasterNames[i]);
            if (raster == null || !product.containsPixel((double)x, (double)y)) continue;
            if (AbstractMeasurementFactory.pixelIsNotInBounds(raster, x, y) || !raster.isPixelValid(x, y)) {
                bandValues[i] = Double.NaN;
                continue;
            }
            if (raster.isFloatingPointType()) {
                bandValues[i] = (double)raster.getSampleFloat(x, y);
                continue;
            }
            int temp = raster.getSampleInt(x, y);
            bandValues[i] = raster instanceof Mask ? (Number)(temp == 0 ? 0 : 1) : (Number)(raster.getDataType() == 22 ? (Number)((long)temp & 0xFFFFFFFFL) : (Number)temp);
        }
    }

    private static boolean pixelIsNotInBounds(RasterDataNode raster, int x, int y) {
        int height = raster.getRasterHeight();
        int width = raster.getRasterWidth();
        return x < 0 || x >= width || y < 0 || y >= height;
    }
}

