/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.Validator;
import com.bc.ceres.core.ProgressMonitor;
import java.awt.Rectangle;
import java.awt.geom.Point2D;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Comparator;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import java.util.zip.ZipOutputStream;
import javax.media.jai.PlanarImage;
import javax.media.jai.operator.ConstantDescriptor;
import org.esa.snap.core.dataio.ProductIO;
import org.esa.snap.core.dataio.ProductSubsetBuilder;
import org.esa.snap.core.dataio.ProductSubsetDef;
import org.esa.snap.core.dataio.placemark.PlacemarkIO;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.PinDescriptor;
import org.esa.snap.core.datamodel.PixelPos;
import org.esa.snap.core.datamodel.Placemark;
import org.esa.snap.core.datamodel.PlacemarkDescriptor;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.core.gpf.Operator;
import org.esa.snap.core.gpf.OperatorException;
import org.esa.snap.core.gpf.OperatorSpi;
import org.esa.snap.core.gpf.annotations.OperatorMetadata;
import org.esa.snap.core.gpf.annotations.Parameter;
import org.esa.snap.core.gpf.annotations.SourceProducts;
import org.esa.snap.core.gpf.annotations.TargetProperty;
import org.esa.snap.core.image.VirtualBandOpImage;
import org.esa.snap.core.util.ProductUtils;
import org.esa.snap.core.util.StringUtils;
import org.esa.snap.core.util.SystemUtils;
import org.esa.snap.core.util.TimeStampExtractor;
import org.esa.snap.core.util.io.WildcardMatcher;
import org.esa.snap.core.util.kmz.KmlDocument;
import org.esa.snap.core.util.kmz.KmlFeature;
import org.esa.snap.core.util.kmz.KmlPlacemark;
import org.esa.snap.core.util.kmz.KmzExporter;
import org.esa.snap.core.util.math.MathUtils;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.measurement.writer.FormatStrategy;
import org.esa.snap.measurement.writer.MeasurementWriter;
import org.esa.snap.pixex.Coordinate;
import org.esa.snap.pixex.PixExMeasurementReader;
import org.esa.snap.pixex.PixExOpUtils;
import org.esa.snap.pixex.aggregators.AggregatorStrategy;
import org.esa.snap.pixex.aggregators.MaxAggregatorStrategy;
import org.esa.snap.pixex.aggregators.MeanAggregatorStrategy;
import org.esa.snap.pixex.aggregators.MedianAggregatorStrategy;
import org.esa.snap.pixex.aggregators.MinAggregatorStrategy;
import org.esa.snap.pixex.output.AbstractFormatStrategy;
import org.esa.snap.pixex.output.AbstractMeasurementFactory;
import org.esa.snap.pixex.output.AggregatingPixExMeasurementFactory;
import org.esa.snap.pixex.output.DefaultFormatStrategy;
import org.esa.snap.pixex.output.MatchupFormatStrategy;
import org.esa.snap.pixex.output.PixExMeasurementFactory;
import org.esa.snap.pixex.output.PixExProductRegistry;
import org.esa.snap.pixex.output.PixExRasterNamesFactory;
import org.esa.snap.pixex.output.ProductRegistry;
import org.esa.snap.pixex.output.RasterNamesFactory;
import org.esa.snap.pixex.output.ScatterPlotDecoratingStrategy;
import org.esa.snap.pixex.output.TargetWriterFactoryAndMap;
import org.opengis.feature.simple.SimpleFeature;
import org.opengis.feature.type.AttributeDescriptor;

@OperatorMetadata(alias="PixEx", category="Raster", version="1.3", authors="Marco Peters, Thomas Storm, Norman Fomferra", copyright="(c) 2011 by Brockmann Consult", description="Extracts pixels from given locations and source products.", autoWriteDisabled=true)
public class PixExOp
extends Operator {
    public static final String RECURSIVE_INDICATOR = "**";
    private static final String SUB_SCENES_DIR_NAME = "subScenes";
    public static final String NO_AGGREGATION = "no aggregation";
    public static final String MEAN_AGGREGATION = "mean";
    public static final String MIN_AGGREGATION = "min";
    public static final String MAX_AGGREGATION = "max";
    public static final String MEDIAN_AGGREGATION = "median";
    @SourceProducts(description="The source products from which pixels shall be extracted.")
    private Product[] sourceProducts;
    @TargetProperty
    private PixExMeasurementReader measurements;
    @Parameter(description="A comma-separated list of file paths specifying the source products.\nEach path may contain the wildcards '**' (matches recursively any directory),\n'*' (matches any character sequence in path names) and\n'?' (matches any single character).")
    private String[] sourceProductPaths;
    @Parameter(description="Specifies if bands are to be exported", defaultValue="true")
    private Boolean exportBands;
    @Parameter(description="Specifies if tie-points are to be exported", defaultValue="true")
    private Boolean exportTiePoints;
    @Parameter(description="Specifies if masks are to be exported", defaultValue="true")
    private Boolean exportMasks;
    @Parameter(description="The geo-coordinates", itemAlias="coordinate")
    private Coordinate[] coordinates;
    @Parameter(description="The acceptable time difference compared to the time given for a coordinate.\nThe format is a number followed by (D)ay, (H)our or (M)inute. If no time difference is provided, all input products are considered regardless of their time.", defaultValue="")
    private String timeDifference = "";
    @Parameter(description="Path to a file containing geo-coordinates. BEAM's placemark files can be used.")
    private File coordinatesFile;
    @Parameter(description="Path to a CSV-file containing geo-coordinates associated with measurements accordingto BEAM CSV format specification")
    private File matchupFile;
    @Parameter(description="Side length of surrounding window (uneven)", defaultValue="1", validator=WindowSizeValidator.class)
    private Integer windowSize;
    @Parameter(description="The output directory.", notNull=true)
    private File outputDir;
    @Parameter(description="The prefix is used to name the output files.", defaultValue="pixEx")
    private String outputFilePrefix;
    @Parameter(description="Band maths expression (optional). Defines valid pixels.")
    private String expression;
    @Parameter(description="If true, the expression result is exported per pixel, otherwise the expression \nis used as filter (all pixels in given window must be valid).", defaultValue="true")
    private Boolean exportExpressionResult;
    @Parameter(description="If the window size is larger than 1, this parameter describes by which method a single \nvalue shall be derived from the pixels.", defaultValue="no aggregation", valueSet={"no aggregation", "mean", "min", "max", "median"})
    private String aggregatorStrategyType;
    @Parameter(description="If set to true, sub-scenes of the regions, where pixels are found, are exported.", defaultValue="false")
    private boolean exportSubScenes;
    @Parameter(description="An additional border around the region where pixels are found.", defaultValue="0")
    private int subSceneBorderSize;
    @Parameter(description="If set to true, a Google KMZ file will be created, which contains the coordinates where pixels are found.", defaultValue="false")
    private boolean exportKmz;
    @Parameter(description="If set to true, the sensing start and sensing stop should be extracted from the filename of each input product.", defaultValue="false", label="Extract time from product filename")
    private boolean extractTimeFromFilename;
    @Parameter(description="Describes how a date/time section inside a product filename should be interpreted. E.G. yyyyMMdd_hhmmss", validator=TimeStampExtractor.DateInterpretationPatternValidator.class, defaultValue="yyyyMMdd", label="Date/Time pattern")
    private String dateInterpretationPattern;
    @Parameter(description="Describes how the filename of a product should be interpreted.", validator=TimeStampExtractor.FilenameInterpretationPatternValidator.class, defaultValue="*${startDate}*${endDate}*", label="Time extraction pattern in filename")
    private String filenameInterpretationPattern;
    @Parameter(defaultValue="false", description="Determines if the original input measurements shall be included in the output.")
    private boolean includeOriginalInput;
    @Parameter(description="Array of 2-tuples of variable names; for each of these tuples a scatter plot will be exported.", notNull=false, itemAlias="variableCombination")
    private VariableCombination[] scatterPlotVariableCombinations;
    private List<Coordinate> coordinateList;
    private boolean isTargetProductInitialized;
    private int timeDelta;
    private int calendarField = -1;
    private MeasurementWriter measurementWriter;
    private File subScenesDir;
    private KmlDocument kmlDocument;
    private ArrayList<String> knownKmzPlacemarks;
    private TimeStampExtractor timeStampExtractor;
    private AggregatorStrategy aggregatorStrategy;
    private FormatStrategy formatStrategy;

    public static Coordinate.OriginalValue[] getOriginalValues(SimpleFeature feature) {
        List originalAttributeDescriptors = (List)feature.getFeatureType().getUserData().get("originalAttributeDescriptors");
        Coordinate.OriginalValue[] originalValues = originalAttributeDescriptors == null ? new Coordinate.OriginalValue[]{} : new Coordinate.OriginalValue[originalAttributeDescriptors.size()];
        List attributes = (List)feature.getUserData().get("originalAttributes");
        for (int j = 0; j < originalValues.length; ++j) {
            String value = "";
            if (attributes.get(j) != null) {
                value = attributes.get(j).toString();
            }
            originalValues[j] = new Coordinate.OriginalValue(((AttributeDescriptor)originalAttributeDescriptors.get(j)).getLocalName(), value);
        }
        return originalValues;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initialize() throws OperatorException {
        if (this.coordinatesFile == null && (this.coordinates == null || this.coordinates.length == 0) && this.matchupFile == null) {
            throw new OperatorException("No coordinates specified.");
        }
        if (this.outputDir != null && !this.outputDir.exists() && !this.outputDir.mkdirs()) {
            throw new OperatorException("Output directory does not exist and could not be created.");
        }
        if (this.exportSubScenes) {
            this.subScenesDir = new File(this.outputDir, SUB_SCENES_DIR_NAME);
            if (!this.subScenesDir.exists() && !this.subScenesDir.mkdirs()) {
                throw new OperatorException("Directory for sub-scenes does not exist and could not be created.");
            }
        }
        if (this.exportKmz) {
            this.kmlDocument = new KmlDocument("placemarks", null);
            this.knownKmzPlacemarks = new ArrayList();
        }
        if (this.extractTimeFromFilename) {
            this.timeStampExtractor = new TimeStampExtractor(this.dateInterpretationPattern, this.filenameInterpretationPattern);
        }
        this.initAggregatorStrategy();
        Set<File> sourceProductFileSet = PixExOp.getSourceProductFileSet(this.sourceProductPaths, this.getLogger());
        this.coordinateList = this.initCoordinateList();
        Measurement[] originalMeasurements = this.createOriginalMeasurements(this.coordinateList);
        this.parseTimeDelta(this.timeDifference);
        PixExRasterNamesFactory rasterNamesFactory = new PixExRasterNamesFactory(this.exportBands, this.exportTiePoints, this.exportMasks, this.aggregatorStrategy);
        PixExProductRegistry productRegistry = new PixExProductRegistry(this.outputFilePrefix, this.outputDir);
        this.formatStrategy = this.initFormatStrategy(rasterNamesFactory, originalMeasurements, productRegistry);
        AbstractMeasurementFactory measurementFactory = this.aggregatorStrategy == null || this.windowSize == 1 ? new PixExMeasurementFactory(rasterNamesFactory, this.windowSize, productRegistry) : new AggregatingPixExMeasurementFactory(rasterNamesFactory, this.windowSize, productRegistry, this.aggregatorStrategy);
        TargetWriterFactoryAndMap targetFactory = new TargetWriterFactoryAndMap(this.outputFilePrefix, this.outputDir);
        this.measurementWriter = new MeasurementWriter(measurementFactory, targetFactory, this.formatStrategy);
        try {
            boolean measurementsFound = false;
            if (this.sourceProducts != null) {
                Arrays.sort(this.sourceProducts, new ProductComparator());
                for (Product product : this.sourceProducts) {
                    measurementsFound |= this.extractMeasurements(product);
                }
            }
            if (!sourceProductFileSet.isEmpty()) {
                measurementsFound |= this.extractMeasurements(sourceProductFileSet);
            }
            this.setDummyTargetProduct();
            if (this.exportKmz && measurementsFound) {
                KmzExporter kmzExporter = new KmzExporter();
                ZipOutputStream zos = null;
                try {
                    FileOutputStream fos = new FileOutputStream(new File(this.outputDir, this.outputFilePrefix + "_coordinates.kmz"));
                    zos = new ZipOutputStream(fos);
                    kmzExporter.export((KmlFeature)this.kmlDocument, zos, ProgressMonitor.NULL);
                }
                catch (IOException e) {
                    this.getLogger().log(Level.SEVERE, "Problem writing KMZ file.", e);
                }
                finally {
                    if (zos != null) {
                        try {
                            zos.close();
                        }
                        catch (IOException iOException) {}
                    }
                }
            }
            if (!measurementsFound) {
                this.getLogger().log(Level.WARNING, "No measurements extracted.");
            }
        }
        finally {
            this.measurementWriter.close();
        }
        this.measurements = new PixExMeasurementReader(this.outputDir);
    }

    private Measurement[] createOriginalMeasurements(List<Coordinate> coordinateList) {
        if (!(this.includeOriginalInput || this.scatterPlotVariableCombinations != null && this.scatterPlotVariableCombinations.length != 0)) {
            return null;
        }
        Measurement[] result = new Measurement[coordinateList.size()];
        for (int i = 0; i < coordinateList.size(); ++i) {
            Coordinate coordinate = coordinateList.get(i);
            Coordinate.OriginalValue[] originalValues = coordinate.getOriginalValues();
            Object[] values = new Object[]{};
            String[] originalVariableNames = new String[]{};
            if (originalValues != null) {
                values = new Object[originalValues.length];
                originalVariableNames = new String[originalValues.length];
                for (int valueIndex = 0; valueIndex < originalValues.length; ++valueIndex) {
                    Coordinate.OriginalValue originalValue = originalValues[valueIndex];
                    values[valueIndex] = originalValue.value;
                    originalVariableNames[valueIndex] = originalValue.variableName;
                }
            }
            result[i] = new Measurement(coordinate.getID(), "", -1L, -1.0, -1.0, null, new GeoPos(coordinate.getLat().doubleValue(), coordinate.getLon().doubleValue()), values, originalVariableNames, true);
        }
        return result;
    }

    private Object[] getAttributeValues(SimpleFeature feature) {
        List attributes = (List)feature.getUserData().get("originalAttributes");
        Object[] values = new Object[attributes.size()];
        values[0] = feature.getID();
        for (int i1 = 1; i1 < values.length; ++i1) {
            values[i1] = attributes.get(i1);
        }
        return values;
    }

    private FormatStrategy initFormatStrategy(PixExRasterNamesFactory rasterNamesFactory, Measurement[] originalMeasurements, ProductRegistry productRegistry) {
        AbstractFormatStrategy decoratedStrategy = this.includeOriginalInput ? new MatchupFormatStrategy(originalMeasurements, rasterNamesFactory, this.windowSize, this.expression, this.exportExpressionResult) : new DefaultFormatStrategy((RasterNamesFactory)rasterNamesFactory, this.windowSize, this.expression, (boolean)this.exportExpressionResult);
        if (this.scatterPlotVariableCombinations != null && this.scatterPlotVariableCombinations.length != 0) {
            return new ScatterPlotDecoratingStrategy(originalMeasurements, decoratedStrategy, this.scatterPlotVariableCombinations, rasterNamesFactory, productRegistry, this.outputDir, this.outputFilePrefix);
        }
        return decoratedStrategy;
    }

    private void initAggregatorStrategy() {
        if (this.windowSize == 1) {
            this.aggregatorStrategy = null;
            return;
        }
        switch (this.aggregatorStrategyType) {
            case "mean": {
                this.aggregatorStrategy = new MeanAggregatorStrategy();
                break;
            }
            case "min": {
                this.aggregatorStrategy = new MinAggregatorStrategy();
                break;
            }
            case "max": {
                this.aggregatorStrategy = new MaxAggregatorStrategy();
                break;
            }
            case "median": {
                this.aggregatorStrategy = new MedianAggregatorStrategy();
                break;
            }
            case "no aggregation": {
                this.aggregatorStrategy = null;
            }
        }
    }

    public static Set<File> getSourceProductFileSet(String[] sourceProductPaths, Logger logger) {
        TreeSet<File> sourceProductFileSet = new TreeSet<File>();
        String[] paths = PixExOp.trimSourceProductPaths(sourceProductPaths);
        if (paths != null && paths.length != 0) {
            for (String path : paths) {
                try {
                    WildcardMatcher.glob((String)path, sourceProductFileSet);
                }
                catch (IOException e) {
                    logger.severe("I/O problem occurred while scanning source product files: " + e.getMessage());
                }
            }
            if (sourceProductFileSet.isEmpty()) {
                logger.log(Level.WARNING, "No valid source product path found.");
            }
        }
        return sourceProductFileSet;
    }

    public void dispose() {
        try {
            this.measurements.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        super.dispose();
    }

    int getTimeDelta() {
        return this.timeDelta;
    }

    int getCalendarField() {
        return this.calendarField;
    }

    Iterator<Measurement> getMeasurements() {
        return this.measurements;
    }

    private boolean extractMeasurement(Product product, Coordinate coordinate, int coordinateID, RenderedImage validMaskImage) throws IOException {
        Raster validData;
        int centerY;
        int upperLeftY;
        ProductData.UTC scanLineTime;
        PixelPos centerPos = this.getPixelPosition(product, coordinate);
        if (!product.containsPixel(centerPos)) {
            return false;
        }
        if (this.considerTimeDifference(this.timeDifference) && coordinate.getDateTime() != null && ((scanLineTime = ProductUtils.getScanLineTime((Product)product, (double)centerPos.y)) == null || !this.isPixelInTimeSpan(coordinate, this.timeDelta, this.calendarField, scanLineTime))) {
            return false;
        }
        int offset = MathUtils.floorInt((double)(this.windowSize / 2));
        int centerX = MathUtils.floorInt((double)centerPos.x);
        int upperLeftX = centerX - offset;
        boolean isAnyPixelValid = this.isAnyPixelInWindowValid(upperLeftX, upperLeftY = (centerY = MathUtils.floorInt((double)centerPos.y)) - offset, validData = validMaskImage.getData(new Rectangle(upperLeftX, upperLeftY, this.windowSize, this.windowSize)));
        if (isAnyPixelValid) {
            this.measurementWriter.writeMeasurements(centerX, centerY, coordinateID, coordinate.getName(), product, validData);
            return true;
        }
        return false;
    }

    private PixelPos getPixelPosition(Product product, Coordinate coordinate) {
        return product.getSceneGeoCoding().getPixelPos(new GeoPos(coordinate.getLat().doubleValue(), coordinate.getLon().doubleValue()), null);
    }

    private boolean isAnyPixelInWindowValid(int upperLeftX, int upperLeftY, Raster validData) {
        int numPixels = this.windowSize * this.windowSize;
        for (int n = 0; n < numPixels; ++n) {
            int y;
            boolean isPixelValid;
            int x = upperLeftX + n % this.windowSize;
            boolean bl = isPixelValid = validData.getSample(x, y = upperLeftY + n / this.windowSize, 0) != 0;
            if (!isPixelValid) continue;
            return true;
        }
        return false;
    }

    PlanarImage createValidMaskImage(Product product) {
        if (this.expression != null && product.isCompatibleBandArithmeticExpression(this.expression)) {
            return VirtualBandOpImage.builder((String)this.expression, (Product)product).dataType(20).fillValue((Number)0).create();
        }
        return ConstantDescriptor.create((Float)Float.valueOf(product.getSceneRasterWidth()), (Float)Float.valueOf(product.getSceneRasterHeight()), (Number[])new Byte[]{(byte)-1}, null);
    }

    private boolean isPixelInTimeSpan(Coordinate coordinate, int timeDiff, int calendarField, ProductData.UTC timeAtPixel) {
        if (this.timeDifference.isEmpty()) {
            return true;
        }
        Calendar currentDate = timeAtPixel.getAsCalendar();
        Calendar lowerTimeBound = (Calendar)currentDate.clone();
        lowerTimeBound.add(calendarField, -timeDiff);
        Calendar upperTimeBound = (Calendar)currentDate.clone();
        upperTimeBound.add(calendarField, timeDiff);
        Calendar coordinateCal = ProductData.UTC.createCalendar();
        coordinateCal.setTime(coordinate.getDateTime());
        return lowerTimeBound.compareTo(coordinateCal) <= 0 && upperTimeBound.compareTo(coordinateCal) >= 0;
    }

    private void parseTimeDelta(String timeDifference) {
        String s;
        if (!this.considerTimeDifference(timeDifference)) {
            return;
        }
        this.timeDelta = Integer.parseInt(timeDifference.substring(0, timeDifference.length() - 1));
        switch (s = timeDifference.substring(timeDifference.length() - 1).toUpperCase()) {
            case "D": {
                this.calendarField = 5;
                break;
            }
            case "H": {
                this.calendarField = 10;
                break;
            }
            case "M": {
                this.calendarField = 12;
                break;
            }
            default: {
                this.calendarField = 5;
            }
        }
    }

    private boolean considerTimeDifference(String timeDifference) {
        return !StringUtils.isNullOrEmpty((String)timeDifference);
    }

    private List<Coordinate> initCoordinateList() {
        ArrayList<Coordinate> list = new ArrayList<Coordinate>();
        if (this.coordinatesFile != null) {
            list.addAll(this.extractCoordinates(this.coordinatesFile));
        }
        if (this.coordinates != null) {
            list.addAll(Arrays.asList(this.coordinates));
        }
        if (this.matchupFile != null) {
            list.addAll(PixExOp.extractMatchupCoordinates(this.matchupFile));
        }
        for (int i = 0; i < list.size(); ++i) {
            Coordinate coordinate = (Coordinate)list.get(i);
            coordinate.setID(i + 1);
        }
        return list;
    }

    static List<Coordinate> extractMatchupCoordinates(File matchupFile) {
        List<SimpleFeature> simpleFeatures;
        ArrayList<Coordinate> result = new ArrayList<Coordinate>();
        try {
            simpleFeatures = PixExOpUtils.extractFeatures(matchupFile);
        }
        catch (IOException e) {
            SystemUtils.LOG.warning(String.format("Unable to read matchups from file '%s'. Reason: %s", matchupFile.getAbsolutePath(), e.getMessage()));
            return result;
        }
        for (SimpleFeature extendedFeature : simpleFeatures) {
            try {
                Coordinate.OriginalValue[] originalValues = PixExOp.getOriginalValues(extendedFeature);
                GeoPos geoPos = PixExOpUtils.getGeoPos(extendedFeature);
                Date dateTime = (Date)extendedFeature.getAttribute("dateTime");
                result.add(new Coordinate(extendedFeature.getID(), geoPos.lat, geoPos.lon, dateTime, originalValues));
            }
            catch (IOException e) {
                SystemUtils.LOG.warning(e.getMessage());
            }
        }
        return result;
    }

    private List<Coordinate> extractCoordinates(File coordinatesFile) {
        ArrayList<Coordinate> extractedCoordinates = new ArrayList<Coordinate>();
        FileReader fileReader = null;
        try {
            fileReader = new FileReader(coordinatesFile);
            List pins = PlacemarkIO.readPlacemarks((Reader)fileReader, null, (PlacemarkDescriptor)PinDescriptor.getInstance());
            for (Placemark pin : pins) {
                GeoPos geoPos = pin.getGeoPos();
                if (geoPos == null) continue;
                Date dateTimeValue = (Date)pin.getFeature().getAttribute("dateTime");
                Coordinate coordinate = new Coordinate(pin.getName(), geoPos.lat, geoPos.lon, dateTimeValue);
                extractedCoordinates.add(coordinate);
            }
        }
        catch (IOException cause) {
            throw new OperatorException((Throwable)cause);
        }
        finally {
            if (fileReader != null) {
                try {
                    fileReader.close();
                }
                catch (IOException iOException) {}
            }
        }
        return extractedCoordinates;
    }

    private boolean extractMeasurements(Set<File> fileSet) {
        boolean measurementsFound = false;
        for (File file : fileSet) {
            measurementsFound |= this.extractMeasurements(file);
        }
        return measurementsFound;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractMeasurements(File file) {
        boolean bl;
        Product product = ProductIO.readProduct((File)file);
        if (product == null) {
            this.getLogger().warning("Unable to read product from file '" + file.getAbsolutePath() + "'.");
            return false;
        }
        try {
            bl = this.extractMeasurements(product);
        }
        catch (Throwable throwable) {
            try {
                product.dispose();
                throw throwable;
            }
            catch (Exception e) {
                Logger logger = this.getLogger();
                logger.warning("Unable to extract measurements from product file '" + file.getAbsolutePath() + "'.");
                logger.log(Level.WARNING, e.getMessage());
                logger.log(Level.FINER, e.getMessage(), e);
                return false;
            }
        }
        product.dispose();
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean extractMeasurements(Product product) {
        if (!this.isAbleToExtractPixels(product)) {
            return false;
        }
        ProductData.UTC[] oldTimeStamps = new ProductData.UTC[]{product.getStartTime(), product.getEndTime()};
        try {
            File file = product.getFileLocation();
            if (this.extractTimeFromFilename && file != null) {
                String fileName = file.getName();
                ProductData.UTC[] timeStamps = this.timeStampExtractor.extractTimeStamps(fileName);
                product.setStartTime(timeStamps[0]);
                product.setEndTime(timeStamps[1]);
            }
        }
        catch (ValidationException e) {
            throw new OperatorException((Throwable)e);
        }
        PlanarImage validMaskImage = this.createValidMaskImage(product);
        try {
            ArrayList<Coordinate> matchedCoordinates = new ArrayList<Coordinate>();
            boolean coordinatesFound = false;
            for (Coordinate coordinate : this.coordinateList) {
                try {
                    boolean measurementExtracted = this.extractMeasurement(product, coordinate, coordinate.getID(), (RenderedImage)validMaskImage);
                    coordinatesFound |= measurementExtracted;
                    if (!measurementExtracted || !this.exportSubScenes && !this.exportKmz) continue;
                    matchedCoordinates.add(coordinate);
                }
                catch (IOException e) {
                    this.getLogger().warning(e.getMessage());
                }
            }
            this.formatStrategy.finish();
            if (coordinatesFound) {
                if (this.exportSubScenes) {
                    try {
                        this.exportSubScene(product, matchedCoordinates);
                    }
                    catch (IOException e) {
                        this.getLogger().log(Level.WARNING, "Could not export sub-scene for product: " + product.getFileLocation(), e);
                    }
                }
                if (this.exportKmz) {
                    for (Coordinate matchedCoordinate : matchedCoordinates) {
                        String coordinateName = matchedCoordinate.getName();
                        if (this.knownKmzPlacemarks.contains(coordinateName)) continue;
                        Point2D.Double position = new Point2D.Double(matchedCoordinate.getLon(), matchedCoordinate.getLat());
                        this.kmlDocument.addChild((KmlFeature)new KmlPlacemark(coordinateName, null, (Point2D)position));
                        this.knownKmzPlacemarks.add(coordinateName);
                    }
                }
            }
            boolean bl = coordinatesFound;
            return bl;
        }
        finally {
            validMaskImage.dispose();
            product.setStartTime(oldTimeStamps[0]);
            product.setEndTime(oldTimeStamps[1]);
        }
    }

    private void exportSubScene(Product product, List<Coordinate> coordinates) throws IOException {
        ProductSubsetDef subsetDef = new ProductSubsetDef(product.getName() + "_subScene");
        int x1 = Integer.MAX_VALUE;
        int x2 = Integer.MIN_VALUE;
        int y1 = Integer.MAX_VALUE;
        int y2 = Integer.MIN_VALUE;
        int width = (this.windowSize - 1) / 2;
        for (Coordinate coordinate : coordinates) {
            PixelPos pixelPos = this.getPixelPosition(product, coordinate);
            x1 = Math.min(x1, (int)Math.floor(pixelPos.x - (double)width));
            x2 = Math.max(x2, (int)Math.floor(pixelPos.x + (double)width));
            y1 = Math.min(y1, (int)Math.floor(pixelPos.y - (double)width));
            y2 = Math.max(y2, (int)Math.floor(pixelPos.y + (double)width));
        }
        Rectangle region = new Rectangle(x1, y1, x2 - x1 + 1, y2 - y1 + 1);
        region.grow(this.subSceneBorderSize, this.subSceneBorderSize);
        Rectangle productBounds = new Rectangle(0, 0, product.getSceneRasterWidth(), product.getSceneRasterHeight());
        Rectangle finalRegion = productBounds.intersection(region);
        subsetDef.setRegion(finalRegion);
        Product subset = ProductSubsetBuilder.createProductSubset((Product)product, (ProductSubsetDef)subsetDef, null, null);
        String[] extension = ProductIO.getProductWriterExtensions((String)"BEAM-DIMAP");
        File productFile = new File(this.subScenesDir, product.getName() + extension[0]);
        ProductIO.writeProduct((Product)subset, (String)productFile.getAbsolutePath(), (String)"BEAM-DIMAP");
    }

    private void setDummyTargetProduct() {
        Product product = new Product("dummy", "dummy", 2, 2);
        product.addBand("dummy", 10);
        this.setTargetProduct(product);
    }

    private boolean isAbleToExtractPixels(Product product) {
        Logger logger = this.getLogger();
        if (product == null) {
            return false;
        }
        if (product.isMultiSize()) {
            String msgPattern = "Product [%s] refused. Cause: Product has rasters of different size. Please consider resampling it so that all rasters have the same size.";
            logger.warning(String.format("Product [%s] refused. Cause: Product has rasters of different size. Please consider resampling it so that all rasters have the same size.", product.getFileLocation()));
            return false;
        }
        GeoCoding geoCoding = product.getSceneGeoCoding();
        if (geoCoding == null) {
            String msgPattern = "Product [%s] refused. Cause: Product is not geo-coded.";
            logger.warning(String.format("Product [%s] refused. Cause: Product is not geo-coded.", product.getFileLocation()));
            return false;
        }
        if (!geoCoding.canGetPixelPos()) {
            String msgPattern = "Product [%s] refused. Cause: Pixel position can not be determined.";
            logger.warning(String.format("Product [%s] refused. Cause: Pixel position can not be determined.", product.getFileLocation()));
            return false;
        }
        return true;
    }

    private static String[] trimSourceProductPaths(String[] sourceProductPaths) {
        String[] paths = sourceProductPaths != null ? (String[])sourceProductPaths.clone() : null;
        if (paths != null) {
            for (int i = 0; i < paths.length; ++i) {
                paths[i] = paths[i].trim();
            }
        }
        return paths;
    }

    public static class VariableCombination {
        @Parameter(description="The name of the variable from the original measurements")
        public String originalVariableName;
        @Parameter(description="The name of the variable from the product")
        public String productVariableName;
    }

    public static class WindowSizeValidator
    implements Validator {
        public void validateValue(Property property, Object value) throws ValidationException {
            if ((Integer)value % 2 == 0) {
                throw new ValidationException("Value of 'windowSize' must be uneven");
            }
        }
    }

    public static class Spi
    extends OperatorSpi {
        public Spi() {
            super(PixExOp.class);
        }
    }

    private static class ProductComparator
    implements Comparator<Product> {
        private ProductComparator() {
        }

        @Override
        public int compare(Product p1, Product p2) {
            return p1.getName().compareTo(p2.getName());
        }
    }
}

