/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.pixex;

import java.awt.Rectangle;
import java.awt.geom.AffineTransform;
import java.awt.image.Raster;
import java.awt.image.RenderedImage;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.text.ParseException;
import java.util.Locale;
import java.util.Scanner;
import javax.media.jai.RenderedOp;
import javax.media.jai.operator.ConstantDescriptor;
import junit.framework.Assert;
import org.esa.snap.core.datamodel.Band;
import org.esa.snap.core.datamodel.CrsGeoCoding;
import org.esa.snap.core.datamodel.GeoCoding;
import org.esa.snap.core.datamodel.GeoPos;
import org.esa.snap.core.datamodel.Product;
import org.esa.snap.core.datamodel.ProductData;
import org.esa.snap.measurement.Measurement;
import org.esa.snap.measurement.writer.FormatStrategy;
import org.esa.snap.measurement.writer.MeasurementFactory;
import org.esa.snap.measurement.writer.MeasurementWriter;
import org.esa.snap.pixex.output.DefaultFormatStrategy;
import org.esa.snap.pixex.output.PixExMeasurementFactory;
import org.esa.snap.pixex.output.PixExProductRegistry;
import org.esa.snap.pixex.output.PixExRasterNamesFactory;
import org.esa.snap.pixex.output.ProductRegistry;
import org.esa.snap.pixex.output.RasterNamesFactory;
import org.esa.snap.pixex.output.TargetWriterFactoryAndMap;
import org.geotools.referencing.crs.DefaultGeographicCRS;
import org.junit.After;
import org.junit.Before;
import org.junit.Test;
import org.opengis.referencing.FactoryException;
import org.opengis.referencing.crs.CoordinateReferenceSystem;
import org.opengis.referencing.operation.TransformException;

public class MeasurementWriterTest {
    private File outputDir;
    private MeasurementWriter writer;

    @Before
    public void setup() throws IOException {
        File tmpDir = new File(System.getProperty("java.io.tmpdir"));
        this.outputDir = new File(tmpDir, this.getClass().getSimpleName());
        if (!this.outputDir.mkdir()) {
            for (File file : this.outputDir.listFiles()) {
                file.delete();
            }
        }
    }

    @After
    public void tearDown() throws Exception {
        if (this.writer != null) {
            this.writer.close();
        }
        this.deleteOutputFiles();
        this.outputDir.deleteOnExit();
        this.outputDir.delete();
    }

    @Test
    public void testFileCreation() throws Exception {
        boolean windowSize = true;
        String filenamePrefix = "testFileCreation";
        String expression = "";
        boolean exportExpressionResult = true;
        this.writer = this.createMeasurementWriter(1, "testFileCreation", "", true);
        File productMapFile = new File(this.outputDir, "testFileCreation_productIdMap.txt");
        File t1CoordFile = new File(this.outputDir, "testFileCreation_T1_measurements.txt");
        File t2CoordFile = new File(this.outputDir, "testFileCreation_T2_measurements.txt");
        Assert.assertEquals((int)0, (int)this.outputDir.listFiles().length);
        Assert.assertFalse((boolean)productMapFile.exists());
        Assert.assertFalse((boolean)t1CoordFile.exists());
        Assert.assertFalse((boolean)t2CoordFile.exists());
        Product p1 = MeasurementWriterTest.createTestProduct("N1", "T1", new String[0], 360, 180);
        this.writeRegion(this.writer, p1, 1, 1);
        Assert.assertEquals((int)2, (int)this.outputDir.listFiles().length);
        Assert.assertTrue((boolean)productMapFile.exists());
        Assert.assertTrue((boolean)t1CoordFile.exists());
        Product p2 = MeasurementWriterTest.createTestProduct("N2", "T2", new String[0], 360, 180);
        this.writeRegion(this.writer, p2, 1, 1);
        Assert.assertEquals((int)3, (int)this.outputDir.listFiles().length);
        Assert.assertTrue((boolean)productMapFile.exists());
        Assert.assertTrue((boolean)t1CoordFile.exists());
        Assert.assertTrue((boolean)t2CoordFile.exists());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritingMeasurements() throws Exception {
        boolean windowSize = true;
        String filenamePrefix = "testWritingMeasurements";
        this.writer = this.createMeasurementWriter(1, false, "testWritingMeasurements", null, true);
        String[] varNames = new String[]{"abc", "def"};
        Product testProduct1 = MeasurementWriterTest.createTestProduct("N1", "T1", varNames, 360, 180);
        Product testProduct2 = MeasurementWriterTest.createTestProduct("N2", "T1", varNames, 360, 180);
        Product testProduct3 = MeasurementWriterTest.createTestProduct("N3", "T2", varNames, 360, 180);
        this.writeRegion(this.writer, testProduct1, 1, 1);
        this.writeRegion(this.writer, testProduct1, 2, 1);
        this.writeRegion(this.writer, testProduct2, 3, 1);
        this.writeRegion(this.writer, testProduct3, 4, 1);
        File t1CoordFile = new File(this.outputDir, "testWritingMeasurements_T1_measurements.txt");
        try (BufferedReader reader = new BufferedReader(new FileReader(t1CoordFile));){
            this.skipLines(reader, 7);
            this.assertMeasurementEquals(MeasurementWriterTest.getMeasurement(1, 0), reader.readLine(), false);
            this.assertMeasurementEquals(MeasurementWriterTest.getMeasurement(2, 0), reader.readLine(), false);
            this.assertMeasurementEquals(MeasurementWriterTest.getMeasurement(3, 1), reader.readLine(), false);
        }
        File t2CoordFile = new File(this.outputDir, "testWritingMeasurements_T2_measurements.txt");
        reader = new BufferedReader(new FileReader(t2CoordFile));
        try {
            this.skipLines(reader, 7);
            this.assertMeasurementEquals(MeasurementWriterTest.getMeasurement(4, 2), reader.readLine(), false);
        }
        finally {
            reader.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritingMeasurementsWithExpression() throws Exception {
        boolean withExpression = true;
        boolean windowSize = true;
        String filenamePrefix = "testWritingMeasurementsWithExpression";
        this.writer = this.createMeasurementWriter(1, false, "testWritingMeasurementsWithExpression", "Is Valid", true);
        String[] varNames = new String[]{"abc", "def"};
        Product testProduct = MeasurementWriterTest.createTestProduct("N1", "T1", varNames, 360, 180);
        this.writeRegion(this.writer, testProduct, 1, 1);
        this.writeRegion(this.writer, testProduct, 2, 1);
        File t1CoordFile = new File(this.outputDir, "testWritingMeasurementsWithExpression_T1_measurements.txt");
        try (BufferedReader reader = new BufferedReader(new FileReader(t1CoordFile));){
            this.skipLines(reader, 8);
            this.assertMeasurementEquals(MeasurementWriterTest.getMeasurement(1, 0), reader.readLine(), true);
            this.assertMeasurementEquals(MeasurementWriterTest.getMeasurement(2, 0), reader.readLine(), true);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testWritingProductMap() throws Exception {
        int windowSize = 3;
        String filenamePrefix = "testWritingProductMap";
        String expression = null;
        boolean exportExpressionResult = true;
        this.writer = this.createMeasurementWriter(3, "testWritingProductMap", expression, true);
        String[] varNames = new String[]{"abc", "def"};
        Product testProduct = MeasurementWriterTest.createTestProduct("N1", "T1", varNames, 360, 180);
        testProduct.setFileLocation(new File("somewhere/on/disk.txt"));
        this.writeRegion(this.writer, testProduct, 1, 3);
        File t1CoordFile = new File(this.outputDir, "testWritingProductMap_productIdMap.txt");
        try (BufferedReader reader = new BufferedReader(new FileReader(t1CoordFile));){
            this.skipLines(reader, 2);
            String line = reader.readLine();
            Assert.assertNotNull((String)"Nothing written to ProductMap.", (Object)line);
            Assert.assertFalse((boolean)line.isEmpty());
            this.assertProductMapEntryEquals(0, "T1", testProduct.getFileLocation().getAbsolutePath(), line);
            this.writeRegion(this.writer, testProduct, 2, 3);
            Assert.assertNull((String)"No new entry expected.", (Object)reader.readLine());
            Product testProduct2 = MeasurementWriterTest.createTestProduct("N2", "T1", varNames, 360, 180);
            testProduct2.setFileLocation(new File("somewhere/on/disk2.txt"));
            this.writeRegion(this.writer, testProduct2, 1, 3);
            Product testProduct3 = MeasurementWriterTest.createTestProduct("N2", "T2", varNames, 360, 180);
            testProduct3.setFileLocation(new File("somewhere/on/disk3.txt"));
            this.writeRegion(this.writer, testProduct3, 1, 3);
            this.writer.close();
            line = reader.readLine();
            Assert.assertNotNull((String)"Nothing written to ProductMap.", (Object)line);
            Assert.assertFalse((boolean)line.isEmpty());
            this.assertProductMapEntryEquals(1, "T1", testProduct2.getFileLocation().getAbsolutePath(), line);
            line = reader.readLine();
            Assert.assertNotNull((String)"Nothing written to ProductMap.", (Object)line);
            Assert.assertFalse((boolean)line.isEmpty());
            this.assertProductMapEntryEquals(2, "T2", testProduct3.getFileLocation().getAbsolutePath(), line);
        }
    }

    @Test
    public void testClosing() throws IOException, FactoryException, TransformException {
        boolean windowSize = true;
        String filenamePrefix = "testClosing";
        this.writer = this.createMeasurementWriter(1, "testClosing", null, true);
        Product testProduct = MeasurementWriterTest.createTestProduct("N1", "T1", new String[0], 360, 180);
        this.writeRegion(this.writer, testProduct, 1, 1);
        this.writer.close();
        try {
            this.writeRegion(this.writer, testProduct, 2, 1);
            Assert.fail((String)"IllegalStateException expected: The writer is closed.");
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
    }

    private void writeRegion(MeasurementWriter writer, Product p1, int coordId, int windowSize) throws IOException {
        int pixelX = 20;
        int pixelY = 42;
        int pixelBorder = windowSize / 2;
        int centerX = 20 + pixelBorder;
        int centerY = 42 + pixelBorder;
        byte validValue = (byte)(coordId % 2 == 0 ? -1 : 0);
        RenderedOp renderedOp = ConstantDescriptor.create((Float)Float.valueOf(p1.getSceneRasterWidth()), (Float)Float.valueOf(p1.getSceneRasterHeight()), (Number[])new Byte[]{validValue}, null);
        Raster validData = renderedOp.getData(new Rectangle(20, 42, windowSize, windowSize));
        writer.writeMeasurements(centerX, centerY, coordId, "coord" + coordId, p1, validData);
    }

    private void assertProductMapEntryEquals(int productId, String productType, String location, String line) {
        Scanner scanner = new Scanner(line);
        scanner.useLocale(Locale.ENGLISH);
        scanner.useDelimiter("\t");
        Assert.assertEquals((int)productId, (int)scanner.nextInt());
        Assert.assertEquals((String)productType, (String)scanner.next());
        Assert.assertEquals((String)location, (String)scanner.next());
        Assert.assertFalse((String)"Too much information on single line.", (boolean)scanner.hasNext());
    }

    private void assertMeasurementEquals(Measurement measurement, String line, boolean withExpression) throws ParseException {
        Scanner scanner = new Scanner(line);
        scanner.useLocale(Locale.ENGLISH);
        scanner.useDelimiter("\t");
        if (withExpression) {
            Assert.assertEquals((boolean)measurement.isValid(), (boolean)scanner.nextBoolean());
        }
        Assert.assertEquals((long)measurement.getProductId(), (long)scanner.nextInt());
        Assert.assertEquals((int)measurement.getCoordinateID(), (int)scanner.nextInt());
        Assert.assertEquals((String)measurement.getCoordinateName(), (String)scanner.next());
        Assert.assertEquals((Object)measurement.getLat(), (Object)scanner.nextDouble());
        Assert.assertEquals((Object)measurement.getLon(), (Object)scanner.nextDouble());
        Assert.assertEquals((Object)measurement.getPixelX(), (Object)scanner.nextDouble());
        Assert.assertEquals((Object)measurement.getPixelY(), (Object)scanner.nextDouble());
        String date = scanner.next().trim();
        String time = scanner.next().trim();
        if (!date.isEmpty() && !time.isEmpty()) {
            String dateTime = ProductData.UTC.parse((String)(date + " " + time), (String)"yyyy-MM-dd HH:mm:ss").format();
            Assert.assertEquals((String)measurement.getTime().format(), (String)dateTime);
        }
        int numValues = 0;
        while (scanner.hasNextFloat()) {
            ++numValues;
            scanner.nextFloat();
        }
        Assert.assertEquals((int)numValues, (int)measurement.getValues().length);
    }

    private void skipLines(BufferedReader reader, int numLines) throws IOException {
        for (int i = 0; i < numLines; ++i) {
            reader.readLine();
        }
    }

    public static Product createTestProduct(String name, String type, String[] bandNames, int width, int height) throws FactoryException, TransformException {
        Rectangle bounds = new Rectangle(width, height);
        Product product = new Product(name, type, bounds.width, bounds.height);
        AffineTransform i2mTransform = new AffineTransform();
        int northing = 90;
        int easting = -180;
        i2mTransform.translate(-180.0, 90.0);
        double scaleX = 360 / bounds.width;
        double scaleY = 180 / bounds.height;
        i2mTransform.scale(scaleX, -scaleY);
        CrsGeoCoding geoCoding = new CrsGeoCoding((CoordinateReferenceSystem)DefaultGeographicCRS.WGS84, bounds, i2mTransform);
        product.setSceneGeoCoding((GeoCoding)geoCoding);
        for (int i = 0; i < bandNames.length; ++i) {
            Band band = product.addBand(bandNames[i], 30);
            band.setSourceImage((RenderedImage)ConstantDescriptor.create((Float)Float.valueOf(bounds.width), (Float)Float.valueOf(bounds.height), (Number[])new Float[]{Float.valueOf(i)}, null));
        }
        return product;
    }

    private static Measurement getMeasurement(int coordId, int productId) throws ParseException {
        return new Measurement(coordId, "coord" + coordId, (long)productId, 20.5, 42.5, ProductData.UTC.parse((String)"12-MAR-2008 17:12:56"), new GeoPos(47.5, -159.5), (Object[])new Float[]{Float.valueOf(12.34f), Float.valueOf(1234.56f)}, coordId % 2 == 0);
    }

    private MeasurementWriter createMeasurementWriter(int windowSize, String filenamePrefix, String expression, boolean exportExpressionResult) {
        return this.createMeasurementWriter(windowSize, true, filenamePrefix, expression, exportExpressionResult);
    }

    private MeasurementWriter createMeasurementWriter(int windowSize, boolean exportMasks, String filenamePrefix, String expression, boolean exportExpressionResult) {
        PixExRasterNamesFactory rasterNamesFactory = new PixExRasterNamesFactory(true, true, exportMasks, null);
        PixExProductRegistry productRegistry = new PixExProductRegistry(filenamePrefix, this.outputDir);
        PixExMeasurementFactory measurementFactory = new PixExMeasurementFactory((RasterNamesFactory)rasterNamesFactory, windowSize, (ProductRegistry)productRegistry);
        TargetWriterFactoryAndMap targetFactory = new TargetWriterFactoryAndMap(filenamePrefix, this.outputDir);
        DefaultFormatStrategy formatStrategy = new DefaultFormatStrategy((RasterNamesFactory)rasterNamesFactory, windowSize, expression, exportExpressionResult);
        return new MeasurementWriter((MeasurementFactory)measurementFactory, targetFactory, (FormatStrategy)formatStrategy);
    }

    private void deleteOutputFiles() throws IOException {
        for (File file : this.outputDir.listFiles()) {
            file.deleteOnExit();
            file.delete();
        }
    }
}

