/*
 * Decompiled with CFR 0.152.
 */
package org.esa.snap.dataio.pgx;

import java.io.BufferedInputStream;
import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.nio.ByteOrder;
import javax.imageio.stream.ImageInputStream;
import javax.imageio.stream.MemoryCacheImageInputStream;
import org.esa.snap.dataio.pgx.PgxProductReader;
import org.junit.Assert;
import org.junit.Test;

public class PgxProductReaderTest {
    @Test
    public void testHeaderParsing() {
        PgxProductReader.Header header = PgxProductReader.parseHeaderLine((String)"PG ML + 16 10960 4096");
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)header.byteOrder);
        Assert.assertEquals((Object)false, (Object)header.signed);
        Assert.assertEquals((long)16L, (long)header.bitDepth);
        Assert.assertEquals((long)10960L, (long)header.width);
        Assert.assertEquals((long)4096L, (long)header.height);
    }

    @Test
    public void testHeaderParsingFromStream() throws IOException {
        String content = "PG ML + 16 10960 4096\nfurther, unneeded content";
        BufferedInputStream stream = new BufferedInputStream(new ByteArrayInputStream(content.getBytes()));
        PgxProductReader.Header header = PgxProductReader.readHeader((ImageInputStream)new MemoryCacheImageInputStream(stream));
        Assert.assertNotNull((Object)header);
        Assert.assertEquals((Object)ByteOrder.BIG_ENDIAN, (Object)header.byteOrder);
        Assert.assertEquals((Object)false, (Object)header.signed);
        Assert.assertEquals((long)16L, (long)header.bitDepth);
        Assert.assertEquals((long)10960L, (long)header.width);
        Assert.assertEquals((long)4096L, (long)header.height);
    }

    @Test
    public void testHeaderParsing_WrongHeader() {
        Assert.assertNull((Object)PgxProductReader.parseHeaderLine((String)"gernuigh589z589nerjkghrepg\u00f6niofh89348"));
    }
}

