/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import com.jidesoft.utils.Lm;
import javax.swing.JCheckBox;
import opendap.dap.DArrayDimension;
import org.esa.beam.HeadlessTestRunner;
import org.esa.beam.framework.gpf.ui.DefaultAppContext;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.opendap.datamodel.DAPVariable;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.CatalogTree;
import org.esa.beam.opendap.ui.VariableFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import thredds.catalog.InvDataset;

@RunWith(value=HeadlessTestRunner.class)
public class VariableFilterTest {
    private OpendapLeaf leaf;
    private DAPVariable dapVariable;
    private VariableFilter variableFilter;

    @Before
    public void setUp() {
        Lm.verifyLicense((String)"Brockmann Consult", (String)"BEAM", (String)"lCzfhklpZ9ryjomwWxfdupxIcuIoCxg2");
        this.variableFilter = new VariableFilter(new JCheckBox(), new CatalogTree(null, (AppContext)new DefaultAppContext(""), null));
        this.variableFilter.getUI();
        this.leaf = new OpendapLeaf("leafName", new InvDataset(null, ""){});
        DArrayDimension[] dArrayDimensions = new DArrayDimension[]{new DArrayDimension(10, "dimName")};
        this.dapVariable = new DAPVariable("vName", "vType", "vDataType", dArrayDimensions);
        this.leaf.addDAPVariable(this.dapVariable);
    }

    @Test
    public void testAccept_AcceptAllIfNoFilterSet() throws Exception {
        this.variableFilter.addVariable(this.dapVariable);
        Assert.assertTrue((boolean)this.variableFilter.accept(this.leaf));
    }

    @Test
    public void testAccept_AcceptIfFilterSet() throws Exception {
        OpendapLeaf leaf2 = new OpendapLeaf("leafName2", new InvDataset(null, ""){});
        DAPVariable dapVariable2 = this.createDAPVariable("vName2");
        leaf2.addDAPVariable(dapVariable2);
        this.variableFilter.addVariable(this.dapVariable);
        this.variableFilter.addVariable(dapVariable2);
        this.variableFilter.setVariableSelected(this.dapVariable, true);
        this.variableFilter.setVariableSelected(dapVariable2, false);
        Assert.assertTrue((boolean)this.variableFilter.accept(this.leaf));
        Assert.assertFalse((boolean)this.variableFilter.accept(leaf2));
    }

    @Test
    public void testAccept_AcceptAllIfNoVariableIsSelected() throws Exception {
        OpendapLeaf leaf2 = new OpendapLeaf("leafName2", new InvDataset(null, ""){});
        DAPVariable dapVariable2 = this.createDAPVariable("vName2");
        leaf2.addDAPVariable(dapVariable2);
        this.variableFilter.addVariable(this.dapVariable);
        this.variableFilter.addVariable(dapVariable2);
        this.variableFilter.setVariableSelected(this.dapVariable, false);
        this.variableFilter.setVariableSelected(dapVariable2, false);
        Assert.assertTrue((boolean)this.variableFilter.accept(this.leaf));
        Assert.assertTrue((boolean)this.variableFilter.accept(leaf2));
    }

    @Test
    public void testAccept_AcceptNothingIfNoMatchingVariableIsSelected() throws Exception {
        OpendapLeaf leaf2 = new OpendapLeaf("leafName2", new InvDataset(null, ""){});
        DAPVariable dapVariable2 = this.createDAPVariable("vName2");
        leaf2.addDAPVariable(dapVariable2);
        DAPVariable dapVariable3 = this.createDAPVariable("vName3");
        this.variableFilter.addVariable(this.dapVariable);
        this.variableFilter.addVariable(dapVariable2);
        this.variableFilter.addVariable(dapVariable3);
        this.variableFilter.setVariableSelected(this.dapVariable, false);
        this.variableFilter.setVariableSelected(dapVariable2, false);
        this.variableFilter.setVariableSelected(dapVariable3, true);
        Assert.assertFalse((boolean)this.variableFilter.accept(this.leaf));
        Assert.assertFalse((boolean)this.variableFilter.accept(leaf2));
    }

    private DAPVariable createDAPVariable(String variableName) {
        DArrayDimension[] dArrayDimensions2 = new DArrayDimension[]{new DArrayDimension(10, "dimName2")};
        return new DAPVariable(variableName, "vType2", "vDataType2", dArrayDimensions2);
    }
}

