/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.net.URI;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Comparator;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeCellRenderer;
import javax.swing.tree.DefaultTreeModel;
import javax.swing.tree.TreeCellRenderer;
import org.esa.beam.framework.gpf.ui.DefaultAppContext;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.CatalogTree;
import org.esa.beam.opendap.ui.CatalogTreeUtils;
import org.junit.Assert;
import org.junit.Assume;
import org.junit.Test;
import thredds.catalog.InvAccess;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvService;
import ucar.nc2.constants.FeatureType;

public class CatalogTree_simpleDifferentTests {
    @Test
    public void testThatGetComponentGetsAWellDefinedJTreeComponent() {
        Assume.assumeTrue((!GraphicsEnvironment.isHeadless() ? 1 : 0) != 0);
        CatalogTree catalogTree = new CatalogTree(null, (AppContext)new DefaultAppContext(""), null);
        Component component = catalogTree.getComponent();
        Assert.assertNotNull((Object)component);
        Assert.assertTrue((boolean)(component instanceof JTree));
        JTree tree = (JTree)component;
        Assert.assertEquals((Object)false, (Object)tree.isRootVisible());
        Assert.assertNotNull((Object)tree.getModel());
        Assert.assertEquals((Object)true, (Object)(tree.getModel() instanceof DefaultTreeModel));
        DefaultTreeModel model = (DefaultTreeModel)tree.getModel();
        Assert.assertNotNull((Object)model.getRoot());
        Assert.assertEquals((Object)true, (Object)(model.getRoot() instanceof DefaultMutableTreeNode));
        DefaultMutableTreeNode rootNode = (DefaultMutableTreeNode)model.getRoot();
        Assert.assertNotNull((Object)rootNode.getUserObject());
        Assert.assertEquals((Object)true, (Object)(rootNode.getUserObject() instanceof String));
        Assert.assertEquals((Object)"root", (Object)rootNode.getUserObject().toString());
    }

    @Test
    public void testThatAWellDefinedRootNodeIsCreated() {
        DefaultMutableTreeNode rootNode = CatalogTreeUtils.createRootNode();
        Assert.assertNotNull((Object)rootNode);
        Object userObject = rootNode.getUserObject();
        Assert.assertNotNull((Object)userObject);
        Assert.assertTrue((boolean)(userObject instanceof String));
        Assert.assertEquals((Object)"root", (Object)userObject.toString());
    }

    @Test
    public void testThatCellRendererIsSet() {
        JTree jTree = new JTree();
        TreeCellRenderer renderer1 = jTree.getCellRenderer();
        Assert.assertNotNull((Object)renderer1);
        Assert.assertEquals((Object)true, (Object)(renderer1 instanceof DefaultTreeCellRenderer));
        CatalogTreeUtils.addCellRenderer((JTree)jTree);
        TreeCellRenderer renderer2 = jTree.getCellRenderer();
        Assert.assertNotNull((Object)renderer2);
        Assert.assertEquals((Object)true, (Object)(renderer2 instanceof DefaultTreeCellRenderer));
        Assert.assertNotSame((Object)renderer1, (Object)renderer2);
    }

    @Test
    public void testThatRendererRendersDifferentTypes() {
        JTree jTree = new JTree();
        CatalogTreeUtils.addCellRenderer((JTree)jTree);
        TreeCellRenderer dapCellRenderer = jTree.getCellRenderer();
        OpendapLeaf opendapLeaf = new OpendapLeaf("This is A dap Node", new InvDataset(null, ""){});
        opendapLeaf.setDapAccess(true);
        OpendapLeaf fileLeaf = new OpendapLeaf("This is A File Node", new InvDataset(null, ""){});
        fileLeaf.setFileAccess(true);
        DefaultMutableTreeNode dapNode = new DefaultMutableTreeNode(opendapLeaf);
        DefaultMutableTreeNode fileNode = new DefaultMutableTreeNode(fileLeaf);
        DefaultMutableTreeNode noDapNode = new DefaultMutableTreeNode("otherNode");
        Component component = dapCellRenderer.getTreeCellRendererComponent(jTree, noDapNode, false, false, true, 0, false);
        Assert.assertTrue((boolean)(component instanceof DefaultTreeCellRenderer));
        DefaultTreeCellRenderer tcr1 = (DefaultTreeCellRenderer)component;
        Assert.assertEquals((Object)"otherNode", (Object)tcr1.getText());
        Assert.assertEquals((Object)true, (Object)(tcr1.getIcon() != null ? 1 : 0));
        Color foreground = tcr1.getForeground();
        Color background = tcr1.getBackground();
        Font font = tcr1.getFont();
        Component component2 = dapCellRenderer.getTreeCellRendererComponent(jTree, dapNode, false, false, true, 0, false);
        Assert.assertSame((Object)component, (Object)component2);
        Assert.assertTrue((boolean)(component2 instanceof DefaultTreeCellRenderer));
        DefaultTreeCellRenderer tcr2 = (DefaultTreeCellRenderer)component2;
        Assert.assertEquals((Object)"This is A dap Node", (Object)tcr2.getText());
        Assert.assertEquals((Object)true, (Object)(tcr2.getIcon() != null ? 1 : 0));
        Icon icon2 = tcr2.getIcon();
        Assert.assertEquals((Object)"/DRsProduct16.png", (Object)icon2.toString().substring(icon2.toString().lastIndexOf("/")));
        Assert.assertEquals((Object)foreground, (Object)tcr2.getForeground());
        Assert.assertEquals((Object)background, (Object)tcr2.getBackground());
        Assert.assertEquals((Object)font, (Object)tcr2.getFont());
        Component component3 = dapCellRenderer.getTreeCellRendererComponent(jTree, fileNode, false, false, true, 0, false);
        Assert.assertSame((Object)component, (Object)component3);
        Assert.assertTrue((boolean)(component3 instanceof DefaultTreeCellRenderer));
        DefaultTreeCellRenderer tcr3 = (DefaultTreeCellRenderer)component3;
        Assert.assertEquals((Object)"This is A File Node", (Object)tcr3.getText());
        Assert.assertEquals((Object)true, (Object)(tcr3.getIcon() instanceof ImageIcon));
        ImageIcon icon3 = (ImageIcon)tcr3.getIcon();
        Assert.assertEquals((Object)"/FRsProduct16.png", (Object)icon3.getDescription().substring(icon3.getDescription().lastIndexOf("/")));
        Assert.assertEquals((Object)foreground, (Object)tcr3.getForeground());
        Assert.assertEquals((Object)background, (Object)tcr3.getBackground());
        Assert.assertEquals((Object)font, (Object)tcr3.getFont());
    }

    @Test
    public void testGetLeaves() throws Exception {
        Assume.assumeTrue((!GraphicsEnvironment.isHeadless() ? 1 : 0) != 0);
        CatalogTree catalogTree = new CatalogTree(null, (AppContext)new DefaultAppContext(""), null);
        ArrayList<InvDataset> datasets = new ArrayList<InvDataset>();
        InvCatalogImpl catalog = new InvCatalogImpl("catalogName", "1.0", new URI("http://x.y"));
        InvDataset rootDataset = this.createDataset((InvCatalog)catalog, "first", "OPENDAP");
        rootDataset.getDatasets().add(this.createDataset((InvCatalog)catalog, "second", "OPENDAP"));
        rootDataset.getDatasets().add(this.createDataset((InvCatalog)catalog, "third", "OPENDAP"));
        datasets.add(rootDataset);
        catalogTree.setNewRootDatasets(datasets);
        OpendapLeaf[] leaves = catalogTree.getLeaves();
        Arrays.sort(leaves, new Comparator<OpendapLeaf>(){

            @Override
            public int compare(OpendapLeaf o1, OpendapLeaf o2) {
                return o1.getName().compareTo(o2.getName());
            }
        });
        Assert.assertEquals((long)2L, (long)leaves.length);
        Assert.assertEquals((Object)"second", (Object)leaves[0].getName());
        Assert.assertEquals((Object)"third", (Object)leaves[1].getName());
    }

    private InvDataset createDataset(InvCatalog catalog, String datasetName, String serviceName) {
        InvDatasetImpl dapDataset = new InvDatasetImpl(null, datasetName, FeatureType.NONE, serviceName, "http://wherever.you.want.bc");
        dapDataset.setCatalog(catalog);
        InvService dapService = new InvService(serviceName, serviceName, "irrelevant", "irrelevant", "irrelevant");
        dapDataset.addAccess((InvAccess)new InvAccessImpl((InvDataset)dapDataset, "http://y.z", dapService));
        dapDataset.finish();
        return dapDataset;
    }
}

