/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import javax.swing.tree.DefaultMutableTreeNode;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.CatalogTreeUtils;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog.InvDataset;

public class CatalogTree_isDapNodeTest {
    @Test
    public void testThatNullIsResolvedToFalse() {
        Object noDapNode = null;
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isDapNode(noDapNode));
    }

    @Test
    public void testThatUserObjectWhichIsNoOpendapLeafIsResolvedToFalse() {
        Integer userObject = 4;
        DefaultMutableTreeNode noDapNode = new DefaultMutableTreeNode(userObject);
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isDapNode((Object)noDapNode));
    }

    @Test
    public void testThatOpendapLeafWhichHasNoDapServiceSetIsResolvedToFalse() {
        OpendapLeaf userObject = new OpendapLeaf("name", new InvDataset(null, ""){});
        userObject.setDapAccess(false);
        DefaultMutableTreeNode noDapNode = new DefaultMutableTreeNode(userObject);
        Assert.assertEquals((Object)false, (Object)CatalogTreeUtils.isDapNode((Object)noDapNode));
    }

    @Test
    public void testThatOpendapLeafWhichHasDapServiceSetIsResolvedToTrue() {
        OpendapLeaf userObject = new OpendapLeaf("name", new InvDataset(null, ""){});
        userObject.setDapAccess(true);
        DefaultMutableTreeNode notADapNode = new DefaultMutableTreeNode(userObject);
        Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isDapNode((Object)notADapNode));
    }
}

