/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import org.esa.beam.HeadlessTestRunner;
import org.esa.beam.framework.gpf.ui.DefaultAppContext;
import org.esa.beam.framework.ui.AppContext;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.CatalogTree;
import org.esa.beam.opendap.ui.CatalogTreeUtils;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;

@RunWith(value=HeadlessTestRunner.class)
public class CatalogTree_insertCatalogElementsTest {
    private CatalogTree catalogTree;
    private DefaultMutableTreeNode parentNode;

    @Before
    public void setUp() throws Exception {
        this.catalogTree = new CatalogTree(null, (AppContext)new DefaultAppContext(""), null);
        this.parentNode = (DefaultMutableTreeNode)((JTree)this.catalogTree.getComponent()).getModel().getRoot();
    }

    @Test
    public void testThatParentNodeHasNoChildrenAfterInitialisation() {
        Assert.assertEquals((long)0L, (long)this.parentNode.getChildCount());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThatOneCatalogReferenceNodeHasBeenAdded() throws URISyntaxException, IOException {
        URI catalogBaseUri = new URI("http://sonst.wo.hin/catalog.xml");
        try (InputStream catalogIS = null;){
            catalogIS = this.getThreddsCatalogInputStreamWithOneChildCatalogReference();
            this.catalogTree.insertCatalogElements(catalogIS, catalogBaseUri, this.parentNode, false);
            Assert.assertEquals((long)1L, (long)this.parentNode.getChildCount());
            DefaultMutableTreeNode catalogNameNode = (DefaultMutableTreeNode)this.parentNode.getChildAt(0);
            Assert.assertEquals((Object)"CatalogName", (Object)catalogNameNode.getUserObject());
            TreeNode catalogReferenceNode = catalogNameNode.getChildAt(0);
            Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isCatalogReferenceNode((Object)catalogReferenceNode));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    public void testThatTwoDapDatasetsHaveBeenAdded() throws URISyntaxException, IOException {
        URI catalogBaseUri = new URI("http://every.where/child/catalog.xml");
        try (InputStream catalogIS = null;){
            catalogIS = this.getThreddsCatalogInputStreamWithTwoChildDapDatasets();
            this.catalogTree.insertCatalogElements(catalogIS, catalogBaseUri, this.parentNode, false);
            Assert.assertEquals((long)2L, (long)this.parentNode.getChildCount());
            Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isDapNode((Object)this.parentNode.getChildAt(0)));
            Assert.assertEquals((Object)true, (Object)CatalogTreeUtils.isDapNode((Object)this.parentNode.getChildAt(1)));
            DefaultMutableTreeNode firstChild = (DefaultMutableTreeNode)this.parentNode.getChildAt(0);
            OpendapLeaf firstLeaf = (OpendapLeaf)firstChild.getUserObject();
            Assert.assertEquals((Object)"http://every.where/opendap/hyrax/data/child/ProductName.N1.nc.dds", (Object)firstLeaf.getDdsUri());
            DefaultMutableTreeNode secondChild = (DefaultMutableTreeNode)this.parentNode.getChildAt(1);
            OpendapLeaf secondLeaf = (OpendapLeaf)secondChild.getUserObject();
            Assert.assertEquals((Object)"http://every.where/opendap/hyrax/data/child/OtherProductName.N1.nc.dds", (Object)secondLeaf.getDdsUri());
        }
    }

    private InputStream getThreddsCatalogInputStreamWithOneChildCatalogReference() {
        String threddsCatalogWithOneChildCatalogReference = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n    <thredds:catalog xmlns:fn=\"http://www.w3.org/2005/02/xpath-functions\"\n                 xmlns:thredds=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\"\n                 xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n                 xmlns:bes=\"http://xml.opendap.org/ns/bes/1.0#\">\n    <thredds:service name=\"dap\" serviceType=\"OPeNDAP\" base=\"/opendap/hyrax\"/>\n    <thredds:service name=\"file\" serviceType=\"HTTPServer\" base=\"/opendap/hyrax\"/>\n        <thredds:dataset name=\"/data\" ID=\"/opendap/hyrax/data/\">\n            <thredds:catalogRef name=\"CatalogName\" xlink:href=\"CatalogName/catalog.xml\" xlink:title=\"CatalogName\"\n                          xlink:type=\"simple\"\n                          ID=\"/opendap/hyrax/data/child/\"/>\n        </thredds:dataset>\n    </thredds:catalog>";
        return new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n    <thredds:catalog xmlns:fn=\"http://www.w3.org/2005/02/xpath-functions\"\n                 xmlns:thredds=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\"\n                 xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n                 xmlns:bes=\"http://xml.opendap.org/ns/bes/1.0#\">\n    <thredds:service name=\"dap\" serviceType=\"OPeNDAP\" base=\"/opendap/hyrax\"/>\n    <thredds:service name=\"file\" serviceType=\"HTTPServer\" base=\"/opendap/hyrax\"/>\n        <thredds:dataset name=\"/data\" ID=\"/opendap/hyrax/data/\">\n            <thredds:catalogRef name=\"CatalogName\" xlink:href=\"CatalogName/catalog.xml\" xlink:title=\"CatalogName\"\n                          xlink:type=\"simple\"\n                          ID=\"/opendap/hyrax/data/child/\"/>\n        </thredds:dataset>\n    </thredds:catalog>".getBytes());
    }

    private InputStream getThreddsCatalogInputStreamWithTwoChildDapDatasets() {
        String threddsCatalogStringWithTwoChildDapDatasets = "<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<thredds:catalog xmlns:fn=\"http://www.w3.org/2005/02/xpath-functions\"\n   xmlns:thredds=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\"\n   xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n   xmlns:bes=\"http://xml.opendap.org/ns/bes/1.0#\">\n   <thredds:service name=\"dap\" serviceType=\"OPENDAP\" base=\"/opendap/hyrax\"/>\n   <thredds:service name=\"file\" serviceType=\"HTTPServer\" base=\"/opendap/hyrax\"/>\n   <thredds:dataset name=\"/data/child/MERIS/2012\" ID=\"/opendap/hyrax/data/child/MERIS/2012/\">\n       <thredds:dataset name=\"ProductName.N1.nc\" ID=\"/opendap/hyrax/data/child/MERIS/2012/ProductName.N1.nc\">\n           <thredds:dataSize units=\"bytes\">22851448</thredds:dataSize>\n           <thredds:date type=\"modified\">2012-01-13T15:18:20</thredds:date>\n           <thredds:access serviceName=\"dap\" urlPath=\"/data/child/ProductName.N1.nc\"/>\n           <thredds:access serviceName=\"file\" urlPath=\"/data/child/MERIS/2012/ProductName.N1.nc\"/>\n       </thredds:dataset>\n       <thredds:dataset name=\"OtherProductName.N1.nc\" ID=\"/opendap/hyrax/data/child/OtherProductName.N1.nc\">\n           <thredds:dataSize units=\"bytes\">20268280</thredds:dataSize>\n           <thredds:date type=\"modified\">2012-01-13T17:03:54</thredds:date>\n           <thredds:access serviceName=\"dap\" urlPath=\"/data/child/OtherProductName.N1.nc\"/>\n           <thredds:access serviceName=\"file\" urlPath=\"/data/child/MERIS/2012/OtherProductName.N1.nc\"/>\n       </thredds:dataset>\n   </thredds:dataset>\n</thredds:catalog>";
        return new ByteArrayInputStream("<?xml version=\"1.0\" encoding=\"UTF-8\"?>\n<thredds:catalog xmlns:fn=\"http://www.w3.org/2005/02/xpath-functions\"\n   xmlns:thredds=\"http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0\"\n   xmlns:xlink=\"http://www.w3.org/1999/xlink\"\n   xmlns:bes=\"http://xml.opendap.org/ns/bes/1.0#\">\n   <thredds:service name=\"dap\" serviceType=\"OPENDAP\" base=\"/opendap/hyrax\"/>\n   <thredds:service name=\"file\" serviceType=\"HTTPServer\" base=\"/opendap/hyrax\"/>\n   <thredds:dataset name=\"/data/child/MERIS/2012\" ID=\"/opendap/hyrax/data/child/MERIS/2012/\">\n       <thredds:dataset name=\"ProductName.N1.nc\" ID=\"/opendap/hyrax/data/child/MERIS/2012/ProductName.N1.nc\">\n           <thredds:dataSize units=\"bytes\">22851448</thredds:dataSize>\n           <thredds:date type=\"modified\">2012-01-13T15:18:20</thredds:date>\n           <thredds:access serviceName=\"dap\" urlPath=\"/data/child/ProductName.N1.nc\"/>\n           <thredds:access serviceName=\"file\" urlPath=\"/data/child/MERIS/2012/ProductName.N1.nc\"/>\n       </thredds:dataset>\n       <thredds:dataset name=\"OtherProductName.N1.nc\" ID=\"/opendap/hyrax/data/child/OtherProductName.N1.nc\">\n           <thredds:dataSize units=\"bytes\">20268280</thredds:dataSize>\n           <thredds:date type=\"modified\">2012-01-13T17:03:54</thredds:date>\n           <thredds:access serviceName=\"dap\" urlPath=\"/data/child/OtherProductName.N1.nc\"/>\n           <thredds:access serviceName=\"file\" urlPath=\"/data/child/MERIS/2012/OtherProductName.N1.nc\"/>\n       </thredds:dataset>\n   </thredds:dataset>\n</thredds:catalog>".getBytes());
    }
}

