/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.URL;
import java.net.URLConnection;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import opendap.dap.Attribute;
import opendap.dap.AttributeTable;
import opendap.dap.BaseType;
import opendap.dap.DAS;
import opendap.dap.DArray;
import opendap.dap.DArrayDimension;
import opendap.dap.DConnect2;
import opendap.dap.DDS;
import opendap.dap.DGrid;
import opendap.dap.DataDDS;
import org.esa.beam.util.Debug;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import thredds.catalog.InvAccess;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvCatalogRef;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.ThreddsMetadata;
import thredds.catalog2.Access;
import thredds.catalog2.Catalog;
import thredds.catalog2.CatalogRef;
import thredds.catalog2.Dataset;
import thredds.catalog2.DatasetNode;
import thredds.catalog2.Property;
import thredds.catalog2.Service;
import thredds.catalog2.ThreddsMetadata;
import thredds.catalog2.xml.parser.stax.StaxThreddsXmlParser;

public class TestOpendapAPI {
    private DConnect2 dConnect;

    @Before
    public void setUp() throws Exception {
        String url = "http://test.opendap.org/dap/data/nc/sst.mnmean.nc.gz";
        this.dConnect = new DConnect2(url);
    }

    @Test
    @Ignore
    public void testGetCatalog() throws Exception {
        String url = "http://10.3.13.120:8084/thredds/catalog/catalog.xml";
        InvCatalogFactory defaultFactory = InvCatalogFactory.getDefaultFactory((boolean)true);
        InvCatalogImpl invCatalog = defaultFactory.readXML("http://10.3.13.120:8084/thredds/catalog/catalog.xml");
        StaxThreddsXmlParser xmlParser = StaxThreddsXmlParser.newInstance();
        Catalog catalog = xmlParser.parse(new URL("http://10.3.13.120:8084/thredds/catalog/catalog.xml").toURI());
        System.out.println("invCatalog.getBaseUri() = " + invCatalog.getBaseURI());
        System.out.println("invCatalog.getVersion() = " + invCatalog.getVersion());
        List datasets = invCatalog.getDatasets();
        InvDataset invDataset = (InvDataset)datasets.get(0);
        System.out.println("invDataset.getID() = " + invDataset.getID());
        System.out.println("-----------------------------------------------------------------------");
        System.out.println("-----------------------------------------------------------------------");
        this.printInvDatasets(datasets);
        System.out.println("-----------------------------------------------------------------------");
        System.out.println("-----------------------------------------------------------------------");
    }

    private void printInvDatasets(List<InvDataset> invDatasets) {
        for (InvDataset datasetNode : invDatasets) {
            System.out.println("-----------------------------------------------------------------------");
            System.out.println("datasetNode.getID()           = " + datasetNode.getID());
            if (datasetNode instanceof InvCatalogRef) {
                InvCatalogRef catalogRef = (InvCatalogRef)datasetNode;
                System.out.println("    catalogRef.getReference() = " + catalogRef.getXlinkHref());
            }
            if (datasetNode instanceof InvDataset) {
                InvDataset ds = datasetNode;
                System.out.println("    ds.hasAccess() = " + ds.hasAccess());
                List dsAccesses = ds.getAccess();
                Iterator iterator = dsAccesses.iterator();
                while (iterator.hasNext()) {
                    InvAccess dsAccess = (InvAccess)iterator.next();
                    InvService dsAccessService = dsAccess.getService();
                    System.out.println("    dsAccessService.getName() = " + dsAccessService.getName());
                    List services = dsAccessService.getServices();
                    Iterator iterator2 = services.iterator();
                    while (iterator2.hasNext()) {
                        InvService service = (InvService)iterator2.next();
                        System.out.println("        service.getName() = " + service.getName());
                    }
                }
            }
            System.out.println("datasetNode.getIdAuthority() = " + datasetNode.getAuthority());
            List metadatas = datasetNode.getMetadata();
            for (InvMetadata metadata : metadatas) {
                Object publisher2;
                Object contributor2;
                thredds.catalog.ThreddsMetadata threddsMD;
                System.out.println("    metadata.getContent()           = " + metadata.getContentObject());
                System.out.println("    metadata.getExternalReference() = " + metadata.getXlinkURI());
                System.out.println("    metadata.isContainedContent()   = " + metadata.getContentObject() != null);
                if (!metadata.isThreddsMetadata() || (threddsMD = metadata.getThreddsMetadata()) == null) continue;
                System.out.println("    threddsMD.getAuthority() = " + threddsMD.getAuthority());
                System.out.println("    threddsMD.getHistory() = " + threddsMD.getHistory());
                System.out.println("    threddsMD.getProcessing() = " + threddsMD.getProcessing());
                System.out.println("    threddsMD.getRights() = " + threddsMD.getRights());
                System.out.println("    threddsMD.getServiceName() = " + threddsMD.getServiceName());
                System.out.println("    threddsMD.getSummary() = " + threddsMD.getSummary());
                System.out.println("    threddsMD.getDataFormatType() = " + threddsMD.getDataFormatType());
                System.out.println("    threddsMD.getDataSize() = " + threddsMD.getDataSize());
                System.out.println("    threddsMD.getDataType() = " + threddsMD.getDataType());
                System.out.println("    threddsMD.getGeospatialCoverage() = " + threddsMD.getGeospatialCoverage());
                System.out.println("    threddsMD.getTimeCoverage() = " + threddsMD.getTimeCoverage());
                List contributors = threddsMD.getContributors();
                System.out.println("    threddsMD.getContributors() = " + contributors);
                for (Object contributor2 : contributors) {
                    System.out.println("        contributor.getName() = " + contributor2.getName());
                    System.out.println("        contributor.getRole() = " + contributor2.getRole());
                }
                List creators = threddsMD.getCreators();
                System.out.println("    threddsMD.getCreators() = " + creators);
                contributor2 = creators.iterator();
                while (contributor2.hasNext()) {
                    ThreddsMetadata.Source creator = (ThreddsMetadata.Source)contributor2.next();
                    System.out.println("        creator.getName() = " + creator.getName());
                    System.out.println("        creator.getEmail() = " + creator.getEmail());
                    System.out.println("        creator.getUrl() = " + creator.getUrl());
                    System.out.println("        creator.getVocabulary() = " + creator.getVocabulary());
                }
                List publishers = threddsMD.getPublishers();
                System.out.println("    threddsMD.getPublishers() = " + publishers);
                for (Object publisher2 : publishers) {
                    System.out.println("        publisher.getName() = " + publisher2.getName());
                    System.out.println("        publisher.getEmail() = " + publisher2.getEmail());
                    System.out.println("        publisher.getUrl() = " + publisher2.getUrl());
                    System.out.println("        publisher.getVocabulary() = " + publisher2.getVocabulary());
                }
                List documentation = threddsMD.getDocumentation();
                System.out.println("    threddsMD.getDocumentation() = " + documentation);
                publisher2 = documentation.iterator();
                while (publisher2.hasNext()) {
                    InvDocumentation invDocumentation = (InvDocumentation)publisher2.next();
                    System.out.println("        invDocumentation.getInlineContent() = " + invDocumentation.getInlineContent());
                    System.out.println("        invDocumentation.getType() = " + invDocumentation.getType());
                    try {
                        System.out.println("        invDocumentation.getXlinkContent() = " + invDocumentation.getXlinkContent());
                    }
                    catch (IOException e) {
                        Debug.trace((Throwable)e);
                    }
                    System.out.println("        invDocumentation.getXlinkHref() = " + invDocumentation.getXlinkHref());
                    System.out.println("        invDocumentation.getXlinkTitle() = " + invDocumentation.getXlinkTitle());
                    System.out.println("        invDocumentation.getURI() = " + invDocumentation.getURI());
                }
                List properties = threddsMD.getProperties();
                System.out.println("    threddsMD.getProperties() = " + properties);
                for (InvProperty property : properties) {
                    System.out.println("        property.getName() = " + property.getName());
                    System.out.println("        property.getValue() = " + property.getValue());
                }
                List variables = threddsMD.getVariables();
                System.out.println("    threddsMD.getVariables() = " + variables);
                for (ThreddsMetadata.Variables variable : variables) {
                    System.out.println("        variable.getMapHref() = " + variable.getMapHref());
                    System.out.println("        variable.getVocabHref() = " + variable.getVocabHref());
                    System.out.println("        variable.getVocabulary() = " + variable.getVocabulary());
                    System.out.println("        variable.getMapUri() = " + variable.getMapUri());
                }
            }
            List properties = datasetNode.getProperties();
            for (InvProperty property : properties) {
                System.out.println("    property.getName()   = " + property.getName());
                System.out.println("    property.getValue()  = " + property.getValue());
            }
            this.printInvDatasets(datasetNode.getDatasets());
        }
    }

    private void printDatasets(List<DatasetNode> datasets) {
        for (DatasetNode datasetNode : datasets) {
            Object metadata2;
            System.out.println("-----------------------------------------------------------------------");
            System.out.println("datasetNode.getId()           = " + datasetNode.getId());
            if (datasetNode instanceof CatalogRef) {
                CatalogRef catalogRef = (CatalogRef)datasetNode;
                System.out.println("    catalogRef.getReference() = " + catalogRef.getReference());
            }
            if (datasetNode instanceof Dataset) {
                Dataset ds = (Dataset)datasetNode;
                System.out.println("    ds.isAccessible() = " + ds.isAccessible());
                List dsAccesses = ds.getAccesses();
                Iterator iterator = dsAccesses.iterator();
                while (iterator.hasNext()) {
                    Access dsAccess = (Access)iterator.next();
                    Service dsAccessService = dsAccess.getService();
                    System.out.println("    dsAccessService.getName() = " + dsAccessService.getName());
                    List services = dsAccessService.getServices();
                    for (Service service : services) {
                        System.out.println("        service.getName() = " + service.getName());
                    }
                }
            }
            List metadatas = datasetNode.getMetadata();
            for (Object metadata2 : metadatas) {
                System.out.println("    metadata.getContent()           = " + metadata2.getContent());
                System.out.println("    metadata.getTitle()             = " + metadata2.getTitle());
                System.out.println("    metadata.getExternalReference() = " + metadata2.getExternalReference());
                System.out.println("    metadata.isContainedContent()   = " + metadata2.isContainedContent());
            }
            List properties = datasetNode.getProperties();
            metadata2 = properties.iterator();
            while (metadata2.hasNext()) {
                Property property = (Property)metadata2.next();
                System.out.println("    property.getName()   = " + property.getName());
                System.out.println("    property.getValue()  = " + property.getValue());
            }
            ThreddsMetadata threddsMetadata = datasetNode.getThreddsMetadata();
            if (threddsMetadata == null) continue;
            System.out.println("    threddsMetadata.getCollectionType() = " + threddsMetadata.getCollectionType());
        }
    }

    @Test
    @Ignore
    public void testGetDDS() throws Exception {
        DDS dds = this.dConnect.getDDS();
        Enumeration variables = dds.getVariables();
        HashSet<String> variableNames = new HashSet<String>();
        while (variables.hasMoreElements()) {
            DArray variable;
            Object currentVariable = variables.nextElement();
            Assert.assertTrue((currentVariable instanceof DArray || currentVariable instanceof DGrid ? 1 : 0) != 0);
            variableNames.add(((BaseType)currentVariable).getEncodedName());
            if (currentVariable instanceof DArray) {
                variable = (DArray)currentVariable;
                if (variable.getEncodedName().equals("lat")) {
                    Assert.assertEquals((long)1L, (long)variable.numDimensions());
                    Assert.assertEquals((long)89L, (long)variable.getDimension(0).getSize());
                    continue;
                }
                if (variable.getEncodedName().equals("lon")) {
                    Assert.assertEquals((long)1L, (long)variable.numDimensions());
                    Assert.assertEquals((long)180L, (long)variable.getDimension(0).getSize());
                    continue;
                }
                if (variable.getEncodedName().equals("time")) {
                    Assert.assertEquals((long)1L, (long)variable.numDimensions());
                    Assert.assertEquals((long)1857L, (long)variable.getDimension(0).getSize());
                    continue;
                }
                if (!variable.getEncodedName().equals("time_bnds")) continue;
                Assert.assertEquals((long)2L, (long)variable.numDimensions());
                Assert.assertEquals((long)1857L, (long)variable.getDimension(0).getSize());
                Assert.assertEquals((long)2L, (long)variable.getDimension(1).getSize());
                continue;
            }
            if (!(currentVariable instanceof DGrid)) continue;
            variable = (DGrid)currentVariable;
            DArray gridArray = variable.getArray();
            Assert.assertEquals((long)3L, (long)gridArray.numDimensions());
            Assert.assertEquals((long)1857L, (long)gridArray.getDimension(0).getSize());
            Assert.assertEquals((long)89L, (long)gridArray.getDimension(1).getSize());
            Assert.assertEquals((long)180L, (long)gridArray.getDimension(2).getSize());
            Vector gridMaps = variable.getArrayDims();
            this.testMap((DArrayDimension)gridMaps.get(0), "time", 1857);
            this.testMap((DArrayDimension)gridMaps.get(1), "lat", 89);
            this.testMap((DArrayDimension)gridMaps.get(2), "lon", 180);
        }
        Assert.assertTrue((boolean)variableNames.contains("lat"));
        Assert.assertTrue((boolean)variableNames.contains("lon"));
        Assert.assertTrue((boolean)variableNames.contains("time"));
        Assert.assertTrue((boolean)variableNames.contains("time_bnds"));
        Assert.assertTrue((boolean)variableNames.contains("sst"));
    }

    @Test
    @Ignore
    public void testGetDAS() throws Exception {
        DAS das = this.dConnect.getDAS();
        Enumeration attributeNames = das.getNames();
        Assert.assertTrue((boolean)attributeNames.hasMoreElements());
        HashSet<String> attributeNameSet = new HashSet<String>();
        while (attributeNames.hasMoreElements()) {
            attributeNameSet.add(attributeNames.nextElement().toString());
        }
        Assert.assertTrue((boolean)attributeNameSet.contains("lat"));
        Assert.assertTrue((boolean)attributeNameSet.contains("lon"));
        Assert.assertTrue((boolean)attributeNameSet.contains("time"));
        Assert.assertTrue((boolean)attributeNameSet.contains("time_bnds"));
        Assert.assertTrue((boolean)attributeNameSet.contains("sst"));
        Assert.assertTrue((boolean)attributeNameSet.contains("NC_GLOBAL"));
        AttributeTable attributeTableLat = das.getAttribute("lat").getContainer();
        Enumeration attributeTableLatNames = attributeTableLat.getNames();
        this.testLatLonAttributes(attributeTableLat, attributeTableLatNames, "Latitude", 88.0f, -88.0f, "latitude_north", "y");
        AttributeTable attributeTableLon = das.getAttribute("lon").getContainer();
        Enumeration attributeTableLonNames = attributeTableLon.getNames();
        this.testLatLonAttributes(attributeTableLon, attributeTableLonNames, "Longitude", 0.0f, 358.0f, "longitude_east", "x");
        AttributeTable globalAttributes = das.getAttributeTable("NC_GLOBAL");
        Assert.assertNotNull((Object)globalAttributes);
        HashSet<String> globalAttributesNamesSet = new HashSet<String>();
        Enumeration globalAttributesNames = globalAttributes.getNames();
        while (globalAttributesNames.hasMoreElements()) {
            globalAttributesNamesSet.add(globalAttributesNames.nextElement().toString());
        }
        Assert.assertTrue((boolean)globalAttributesNamesSet.contains("title"));
        Assert.assertTrue((boolean)globalAttributesNamesSet.contains("conventions"));
        Assert.assertTrue((boolean)globalAttributesNamesSet.contains("history"));
        Assert.assertTrue((boolean)globalAttributesNamesSet.contains("comments"));
        Assert.assertTrue((boolean)globalAttributesNamesSet.contains("platform"));
        Assert.assertTrue((boolean)globalAttributesNamesSet.contains("source"));
        Assert.assertTrue((boolean)globalAttributesNamesSet.contains("institution"));
        Assert.assertTrue((boolean)globalAttributesNamesSet.contains("references"));
        Assert.assertTrue((boolean)globalAttributesNamesSet.contains("citation"));
        Assert.assertEquals((Object)"NOAA Extended Reconstructed SST V3", (Object)globalAttributes.getAttribute("title").getValueAt(0));
    }

    private void testMap(DArrayDimension map, String expectedName, int expectedSize) {
        Assert.assertEquals((Object)expectedName, (Object)map.getEncodedName());
        Assert.assertEquals((long)expectedSize, (long)map.getSize());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Test
    @Ignore
    public void testDownloadData() throws Exception {
        InputStream inputStream = null;
        OutputStream os = null;
        File file = null;
        try {
            URL url = new URL("http://test.opendap.org/dap/data/nc/data.nc");
            URLConnection connection = url.openConnection();
            inputStream = connection.getInputStream();
            file = new File("data.nc");
            os = new FileOutputStream(file);
            byte[] buffer = new byte[51200];
            while (inputStream.read(buffer) != -1) {
                os.write(buffer);
            }
        }
        finally {
            if (inputStream != null) {
                inputStream.close();
            }
            if (os != null) {
                os.close();
            }
            if (file != null) {
                file.delete();
            }
        }
    }

    @Test
    @Ignore
    public void testGetDDX() throws Exception {
        DConnect2 dConnect2 = new DConnect2("http://test.opendap.org/opendap/data/nc/sst.mnmean.nc.gz");
        DataDDS data = dConnect2.getData("geogrid(sst,-90,-150,-89,-140)");
        System.out.println("TestOpendapAPI.testGetDDX");
    }

    private void testLatLonAttributes(AttributeTable attributeTable, Enumeration attributeTableNames, String expectedLongName, float expectedMin, float expectedMax, String expectedStandardName, String expectedAxis) throws Exception {
        HashSet<Attribute> attributeSet = new HashSet<Attribute>();
        HashSet<String> attributeNamesSet = new HashSet<String>();
        while (attributeTableNames.hasMoreElements()) {
            String attributeName = attributeTableNames.nextElement().toString();
            Attribute attribute = attributeTable.getAttribute(attributeName);
            attributeSet.add(attribute);
            attributeNamesSet.add(attributeName);
        }
        for (Attribute attribute : attributeSet) {
            if (attribute.getEncodedName().equals("units")) {
                Assert.assertTrue((boolean)attribute.getValueAt(0).matches("degrees_.*"));
                continue;
            }
            if (attribute.getEncodedName().equals("long_name")) {
                Assert.assertEquals((Object)expectedLongName, (Object)attribute.getValueAt(0));
                continue;
            }
            if (attribute.getEncodedName().equals("actual_range")) {
                Assert.assertEquals((long)8L, (long)attribute.getType());
                Iterator valuesIterator = attribute.getValuesIterator();
                Assert.assertEquals((double)expectedMin, (double)Float.parseFloat(valuesIterator.next().toString()), (double)1.0E-7);
                Assert.assertEquals((double)expectedMax, (double)Float.parseFloat(valuesIterator.next().toString()), (double)1.0E-7);
                continue;
            }
            if (attribute.getEncodedName().equals("standard_name")) {
                Assert.assertEquals((Object)expectedStandardName, (Object)attribute.getValueAt(0));
                continue;
            }
            if (attribute.getEncodedName().equals("axis")) {
                Assert.assertEquals((Object)expectedAxis, (Object)attribute.getValueAt(0));
                continue;
            }
            if (!attribute.getEncodedName().equals("coordinate_defines")) continue;
            Assert.assertEquals((Object)"center", (Object)attribute.getValueAt(0));
        }
        Assert.assertTrue((boolean)attributeNamesSet.contains("units"));
        Assert.assertTrue((boolean)attributeNamesSet.contains("long_name"));
        Assert.assertTrue((boolean)attributeNamesSet.contains("actual_range"));
        Assert.assertTrue((boolean)attributeNamesSet.contains("standard_name"));
        Assert.assertTrue((boolean)attributeNamesSet.contains("axis"));
        Assert.assertTrue((boolean)attributeNamesSet.contains("coordinate_defines"));
    }
}

