/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap;

import opendap.dap.DArrayDimension;
import org.esa.beam.opendap.datamodel.DAPVariable;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog.InvDataset;

public class OpendapLeafGetterTest {
    private OpendapLeaf opendapLeaf;

    @Before
    public void setUp() throws Exception {
        this.opendapLeaf = new OpendapLeaf("blah", new InvDataset(null, ""){});
        this.opendapLeaf.setDapUri("http://domain/dap_node");
        this.opendapLeaf.setFileUri("http://domain/file_node");
    }

    @Test
    public void testGetDasURI() {
        Assert.assertEquals((Object)"http://domain/dap_node.das", (Object)this.opendapLeaf.getDasUri());
    }

    @Test
    public void testGetDdsURI() {
        Assert.assertEquals((Object)"http://domain/dap_node.dds", (Object)this.opendapLeaf.getDdsUri());
    }

    @Test
    public void testGetDdxURI() {
        Assert.assertEquals((Object)"http://domain/dap_node.ddx", (Object)this.opendapLeaf.getDdxUri());
    }

    @Test
    public void testGetDodsURI() {
        Assert.assertEquals((Object)"http://domain/dap_node", (Object)this.opendapLeaf.getDapUri());
    }

    @Test
    public void testGetFileURI() {
        Assert.assertEquals((Object)"http://domain/file_node", (Object)this.opendapLeaf.getFileUri());
    }

    @Test
    public void testGetVariables() {
        DAPVariable variable = new DAPVariable("vname", "vtype", "vdatatype", new DArrayDimension[]{new DArrayDimension(10, "dname")});
        this.opendapLeaf.addDAPVariable(variable);
        Assert.assertEquals((long)1L, (long)this.opendapLeaf.getDAPVariables().length);
        Assert.assertSame((Object)variable, (Object)this.opendapLeaf.getDAPVariables()[0]);
    }
}

