/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import opendap.dap.DAP2Exception;
import opendap.dap.DArrayDimension;
import opendap.dap.DDS;
import opendap.dap.parsers.ParseException;
import org.esa.beam.opendap.datamodel.DAPVariable;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.utils.VariableExtractor;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog.InvDataset;

public class VariableExtractorTest {
    @Test
    public void testThatNoVariableCanBeExtractedFromEmptyDDS() {
        OpendapLeaf leaf = new OpendapLeaf("empty", new InvDataset(null, ""){});
        DAPVariable[] dapVariables = new VariableExtractor().extractVariables(leaf);
        Assert.assertEquals((long)0L, (long)dapVariables.length);
    }

    @Test
    public void testThatAVariableCanBeExtractedFromADDSWithOneVariable() throws DAP2Exception, ParseException {
        DDS dds = this.createDDSWithOneVariable();
        DAPVariable[] dapVariables = new VariableExtractor().extractVariables(dds);
        Assert.assertEquals((long)1L, (long)dapVariables.length);
        Assert.assertEquals((Object)"Chlorophyll", (Object)dapVariables[0].getName());
        Assert.assertEquals((Object)"Grid", (Object)dapVariables[0].getType());
        Assert.assertEquals((Object)"Float32", (Object)dapVariables[0].getDataType());
        Assert.assertEquals((long)2L, (long)dapVariables[0].getNumDimensions());
        DArrayDimension[] dimensions = dapVariables[0].getDimensions();
        Assert.assertEquals((Object)"Y", (Object)dimensions[0].getEncodedName());
        Assert.assertEquals((long)849L, (long)dimensions[0].getSize());
        Assert.assertEquals((Object)"X", (Object)dimensions[1].getEncodedName());
        Assert.assertEquals((long)1121L, (long)dimensions[1].getSize());
    }

    @Test
    public void testThatByteVariableCanBeRead() throws DAP2Exception, ParseException {
        DDS dds = this.createDDSWithByteVariable();
        DAPVariable[] dapVariables = new VariableExtractor().extractVariables(dds);
        Assert.assertEquals((long)1L, (long)dapVariables.length);
        Assert.assertEquals((Object)"metadata", (Object)dapVariables[0].getName());
        Assert.assertEquals((Object)"atomic", (Object)dapVariables[0].getType());
        Assert.assertEquals((Object)"Byte", (Object)dapVariables[0].getDataType());
        Assert.assertEquals((long)0L, (long)dapVariables[0].getNumDimensions());
    }

    @Test
    public void testThatFloatVariableCanBeRead() throws DAP2Exception, ParseException {
        DDS dds = this.createDDSWithFloatVariable();
        DAPVariable[] dapVariables = new VariableExtractor().extractVariables(dds);
        Assert.assertEquals((long)1L, (long)dapVariables.length);
        Assert.assertEquals((Object)"metadata", (Object)dapVariables[0].getName());
        Assert.assertEquals((Object)"atomic", (Object)dapVariables[0].getType());
        Assert.assertEquals((Object)"Float32", (Object)dapVariables[0].getDataType());
        Assert.assertEquals((long)0L, (long)dapVariables[0].getNumDimensions());
    }

    @Test
    public void testThatMultipleVariablesCanBeExtractedFromADDSWithMultipleVariables() throws DAP2Exception, ParseException {
        DDS dds = this.createDDSWithMultipleVariables();
        DAPVariable[] dapVariables = new VariableExtractor().extractVariables(dds);
        Assert.assertEquals((long)6L, (long)dapVariables.length);
        Assert.assertEquals((Object)"Chlorophyll", (Object)dapVariables[0].getName());
        Assert.assertEquals((Object)"Total_suspended_matter", (Object)dapVariables[1].getName());
        Assert.assertEquals((Object)"Yellow_substance", (Object)dapVariables[2].getName());
        Assert.assertEquals((Object)"l2_flags", (Object)dapVariables[3].getName());
        Assert.assertEquals((Object)"X", (Object)dapVariables[4].getName());
        Assert.assertEquals((Object)"Y", (Object)dapVariables[5].getName());
    }

    private DDS createDDSWithByteVariable() throws DAP2Exception, ParseException {
        DDS dds = new DDS();
        String ddsString = "Dataset {\n    Byte metadata;\n} coastcolour%2ftasmania24948_0001%2enc;";
        dds.parse((InputStream)new ByteArrayInputStream(ddsString.getBytes()));
        return dds;
    }

    private DDS createDDSWithFloatVariable() throws DAP2Exception, ParseException {
        DDS dds = new DDS();
        String ddsString = "Dataset {\n    Float32 metadata;\n} coastcolour%2ftasmania24948_0001%2enc;";
        dds.parse((InputStream)new ByteArrayInputStream(ddsString.getBytes()));
        return dds;
    }

    private DDS createDDSWithOneVariable() throws DAP2Exception, ParseException {
        DDS dds = new DDS();
        String ddsString = "Dataset {\n    Grid {\n        Array:\n            Float32 Chlorophyll[Y = 849][X = 1121];\n        Maps:\n            Int32 Y[Y = 849];\n            Int32 X[X = 1121];\n    } Chlorophyll;\n} MER_RR__2PNKOF20120113_101320_000001493110_00324_51631_6150.N1.nc;";
        dds.parse((InputStream)new ByteArrayInputStream(ddsString.getBytes()));
        return dds;
    }

    private DDS createDDSWithMultipleVariables() throws DAP2Exception, ParseException {
        DDS dds = new DDS();
        String ddsString = "Dataset {\n    Grid {\n      Array:\n        Float32 Chlorophyll[Y = 849][X = 1121];\n      Maps:\n        Int32 Y[Y = 849];\n        Int32 X[X = 1121];\n    } Chlorophyll;\n    Grid {\n      Array:\n        Float32 Total_suspended_matter[Y = 849][X = 1121];\n      Maps:\n        Int32 Y[Y = 849];\n        Int32 X[X = 1121];\n    } Total_suspended_matter;\n    Grid {\n      Array:\n        Float32 Yellow_substance[Y = 849][X = 1121];\n      Maps:\n        Int32 Y[Y = 849];\n        Int32 X[X = 1121];\n    } Yellow_substance;\n    Grid {\n      Array:\n        Int32 l2_flags[Y = 849][X = 1121];\n      Maps:\n        Int32 Y[Y = 849];\n        Int32 X[X = 1121];\n    } l2_flags;\n    Int32 X[X = 1121];\n    Int32 Y[Y = 849];\n} MER_RR__2PNKOF20120113_101320_000001493110_00324_51631_6150.N1.nc;";
        dds.parse((InputStream)new ByteArrayInputStream(ddsString.getBytes()));
        return dds;
    }
}

