/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.utils;

import java.io.ByteArrayInputStream;
import java.io.InputStream;
import java.util.Set;
import opendap.dap.DAP2Exception;
import opendap.dap.DDS;
import opendap.dap.parsers.ParseException;
import org.esa.beam.opendap.datamodel.DAPVariable;
import org.esa.beam.opendap.utils.VariableCollector;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class VariableCollectorTest {
    private VariableCollector variableCollector;

    @Before
    public void setUp() throws Exception {
        this.variableCollector = new VariableCollector();
    }

    @Test
    public void testCollectFromDDS_TwoVariables() throws DAP2Exception, ParseException {
        String[] variableNames = new String[]{"Chlorophyll", "Total_suspended_matter"};
        DDS dds = this.createDDSWithTwoVariables();
        this.variableCollector.collectDAPVariables(dds);
        this.assertExpectedVariableNamesInList(variableNames, this.variableCollector.getVariables());
        Set dapVariables = this.variableCollector.getVariables();
        Assert.assertEquals((long)2L, (long)dapVariables.size());
        Assert.assertTrue((boolean)this.containsDAPVariableAsExpected(variableNames[0], "Grid", "Float32", dapVariables));
        Assert.assertTrue((boolean)this.containsDAPVariableAsExpected(variableNames[1], "Grid", "Float32", dapVariables));
    }

    @Test
    public void testCollectFromDDS_ThreeVariables() throws DAP2Exception, ParseException {
        String[] variableNames = new String[]{"Baum", "Haus", "Eimer"};
        DDS dds = this.getDDS(variableNames);
        this.variableCollector.collectDAPVariables(dds);
        this.assertExpectedVariableNamesInList(variableNames, this.variableCollector.getVariables());
    }

    @Test
    public void testMultipleCollectionOfTheSameDDS() throws DAP2Exception, ParseException {
        String[] variableNames = new String[]{"Chlorophyll", "Total_suspended_matter", "Yellow_substance", "l2_flags", "X", "Y"};
        DDS dds = this.createDDSWithTwoVariables();
        DDS dds2 = this.createDDSWithMultipleVariables();
        this.variableCollector.collectDAPVariables(dds);
        this.variableCollector.collectDAPVariables(dds2);
        this.assertExpectedVariableNamesInList(variableNames, this.variableCollector.getVariables());
        Set dapVariables = this.variableCollector.getVariables();
        Assert.assertEquals((long)6L, (long)dapVariables.size());
        Assert.assertTrue((boolean)this.containsDAPVariableAsExpected(variableNames[0], "Grid", "Float32", dapVariables));
        Assert.assertTrue((boolean)this.containsDAPVariableAsExpected(variableNames[1], "Grid", "Float32", dapVariables));
        Assert.assertTrue((boolean)this.containsDAPVariableAsExpected(variableNames[2], "Grid", "Float32", dapVariables));
        Assert.assertTrue((boolean)this.containsDAPVariableAsExpected(variableNames[3], "Grid", "Int32", dapVariables));
        Assert.assertTrue((boolean)this.containsDAPVariableAsExpected(variableNames[4], "Array", "Int32", dapVariables));
        Assert.assertTrue((boolean)this.containsDAPVariableAsExpected(variableNames[5], "Array", "Int32", dapVariables));
    }

    private DDS getDDS(String[] variableNames) throws DAP2Exception, ParseException {
        DDS dds = new DDS();
        String ddsString = this.getDDSString(variableNames);
        ByteArrayInputStream inputStream = new ByteArrayInputStream(ddsString.getBytes());
        dds.parse((InputStream)inputStream);
        return dds;
    }

    private String getDDSString(String[] variableNames) {
        StringBuffer sb = new StringBuffer("Dataset {\n");
        for (String variableName : variableNames) {
            sb.append(this.getGridString(variableName));
        }
        sb.append("} MER_RR__2PNKOF20120113_101320_000001493110_00324_51631_6150.N1.nc;\n");
        return sb.toString();
    }

    private String getGridString(String variableName) {
        return "    Grid {\n      Array:\n        Float32 " + variableName + "[Y = 849][X = 1121];\n" + "      Maps:\n" + "        Int32 Y[Y = 849];\n" + "        Int32 X[X = 1121];\n" + "    } " + variableName + ";\n";
    }

    private void assertExpectedVariableNamesInList(String[] namesSet, Set<DAPVariable> variables) {
        Assert.assertNotNull((Object)namesSet);
        Assert.assertEquals((long)variables.size(), (long)namesSet.length);
        for (DAPVariable variable : variables) {
            boolean contained = false;
            for (String name : namesSet) {
                if (!variable.getName().equals(name)) continue;
                contained = true;
            }
            Assert.assertEquals((String)("Variable name " + variable.getName() + " is contained"), (Object)true, (Object)contained);
        }
    }

    private boolean containsDAPVariableAsExpected(String name, String type, String dataType, Set<DAPVariable> variables) {
        for (DAPVariable variable : variables) {
            if (!name.equals(variable.getName()) || !type.equals(variable.getType()) || !dataType.equals(variable.getDataType())) continue;
            return true;
        }
        return false;
    }

    private DDS createDDSWithTwoVariables() throws DAP2Exception, ParseException {
        DDS dds = new DDS();
        String ddsString = "Dataset {\n    Grid {\n        Array:\n            Float32 Chlorophyll[Y = 849][X = 1121];\n        Maps:\n            Int32 Y[Y = 849];\n            Int32 X[X = 1121];\n    } Chlorophyll;\n    Grid {\n      Array:\n        Float32 Total_suspended_matter[Y = 849][X = 1121];\n      Maps:\n        Int32 Y[Y = 849];\n        Int32 X[X = 1121];\n    } Total_suspended_matter;\n} MER_RR__2PNKOF20120113_101320_000001493110_00324_51631_6150.N1.nc;";
        dds.parse((InputStream)new ByteArrayInputStream(ddsString.getBytes()));
        return dds;
    }

    private DDS createDDSWithMultipleVariables() throws DAP2Exception, ParseException {
        DDS dds = new DDS();
        String ddsString = "Dataset {\n    Grid {\n      Array:\n        Float32 Chlorophyll[Y = 849][X = 1121];\n      Maps:\n        Int32 Y[Y = 849];\n        Int32 X[X = 1121];\n    } Chlorophyll;\n    Grid {\n      Array:\n        Float32 Total_suspended_matter[Y = 849][X = 1121];\n      Maps:\n        Int32 Y[Y = 849];\n        Int32 X[X = 1121];\n    } Total_suspended_matter;\n    Grid {\n      Array:\n        Float32 Yellow_substance[Y = 849][X = 1121];\n      Maps:\n        Int32 Y[Y = 849];\n        Int32 X[X = 1121];\n    } Yellow_substance;\n    Grid {\n      Array:\n        Int32 l2_flags[Y = 849][X = 1121];\n      Maps:\n        Int32 Y[Y = 849];\n        Int32 X[X = 1121];\n    } l2_flags;\n    Int32 X[X = 1121];\n    Int32 Y[Y = 849];\n} MER_RR__2PNKOF20120113_101320_000001493110_00324_51631_6150.N1.nc;";
        dds.parse((InputStream)new ByteArrayInputStream(ddsString.getBytes()));
        return dds;
    }
}

