/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.utils;

import java.util.List;
import org.esa.beam.opendap.utils.PatternProvider;
import org.junit.Assert;
import org.junit.Test;

public class PatternProviderTest {
    @Test
    public void testRecognizePatterns_non_valid() throws Exception {
        Assert.assertEquals((long)0L, (long)PatternProvider.recommendPatterns((String)"no_valid_pattern").size());
    }

    @Test
    public void testRecommendPatterns_firstPattern() throws Exception {
        List patternCombinations = PatternProvider.recommendPatterns((String)"sth__20100101:200101.nc");
        Assert.assertTrue((patternCombinations.size() >= 3 ? 1 : 0) != 0);
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMdd:hhmmss", "*${startDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMdd", "*${startDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMM", "*${startDate}*"});
    }

    @Test
    public void testRecommendPatterns_secondPattern_twoDates() throws Exception {
        List patternCombinations = PatternProvider.recommendPatterns((String)"sth__20100101_192345_20110101_192345.nc");
        Assert.assertTrue((patternCombinations.size() >= 6 ? 1 : 0) != 0);
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMdd_hhmmss", "*${startDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMdd_hhmmss", "*${startDate}*${endDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMdd", "*${startDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMdd", "*${startDate}*${endDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMM", "*${startDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMM", "*${startDate}*${endDate}*"});
    }

    @Test
    public void testRecommendPatterns_variousPossiblePatterns() throws Exception {
        List patternCombinations = PatternProvider.recommendPatterns((String)"sth__20100101192345_99999999.nc");
        Assert.assertTrue((patternCombinations.size() >= 7 ? 1 : 0) != 0);
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMdd_hhmmss", "*${startDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMddhhmmss", "*${startDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMddhh", "*${startDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMdd", "*${startDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMMdd", "*${startDate}*${endDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMM", "*${startDate}*"});
        PatternProviderTest.containAssertEquals(patternCombinations, new String[]{"yyyyMM", "*${startDate}*${endDate}*"});
    }

    private static void containAssertEquals(List<String[]> containingList, String[] expectedStrings) {
        boolean expectedIsContained = false;
        for (String[] actualStrings : containingList) {
            if (!actualStrings[0].equals(expectedStrings[0]) || !actualStrings[1].equals(expectedStrings[1]) || actualStrings.length != expectedStrings.length || actualStrings.length != 2) continue;
            expectedIsContained = true;
            break;
        }
        Assert.assertEquals((String)("Expected String[] " + expectedStrings.toString() + " could not be found in list"), (Object)true, (Object)expectedIsContained);
    }
}

