/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.utils;

import java.io.File;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import org.esa.beam.dataio.netcdf.util.NetcdfFileOpener;
import org.esa.beam.opendap.ui.DownloadProgressBarPM;
import org.esa.beam.opendap.utils.DAPDownloader;
import org.esa.beam.util.io.FileUtils;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Ignore;
import org.junit.Test;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;
import ucar.nc2.dods.DODSNetcdfFile;

public class DAPDownloaderTest {
    static final File TESTDATA_DIR = new File("target/dap_download_test");

    @Before
    public void setUp() throws Exception {
        TESTDATA_DIR.mkdirs();
        if (!TESTDATA_DIR.isDirectory()) {
            Assert.fail((String)("Can't create test I/O directory: " + TESTDATA_DIR));
        }
    }

    @After
    public void tearDown() throws Exception {
        if (!FileUtils.deleteTree((File)TESTDATA_DIR)) {
            System.out.println("Warning: failed to completely delete test I/O directory:" + TESTDATA_DIR);
        }
    }

    @Test
    public void testDownloadFile() throws Exception {
        final HashSet downloadedFiles = new HashSet();
        NullDownloadContext fileCountProvider = new NullDownloadContext(){

            @Override
            public void notifyFileDownloaded(File downloadedFile) {
                downloadedFiles.add(downloadedFile);
            }
        };
        DAPDownloader dapDownloader = new DAPDownloader(new HashMap(), new ArrayList(), (DAPDownloader.DownloadContext)fileCountProvider, (DownloadProgressBarPM)new NullLabelledProgressBarPM());
        String fileName = "fileToTextDownload.txt";
        Assert.assertFalse((boolean)DAPDownloaderTest.getTestFile(fileName).exists());
        Assert.assertEquals((long)0L, (long)downloadedFiles.size());
        URL resource = this.getClass().getResource(fileName);
        dapDownloader.downloadFile(TESTDATA_DIR, resource.toString());
        Assert.assertEquals((long)1L, (long)downloadedFiles.size());
        Assert.assertEquals((Object)fileName, (Object)((File)downloadedFiles.toArray()[0]).getName());
        Assert.assertTrue((boolean)DAPDownloaderTest.getTestFile(fileName).exists());
    }

    @Test
    public void testGetVariableNames() throws Exception {
        List variableNames = DAPDownloader.getVariableNames((String)"iop_a_total_443[0:1:717][0:1:308],iop_a_ys_443[0:1:717][0:1:308]");
        Object[] expected = new String[]{"iop_a_total_443", "iop_a_ys_443"};
        Assert.assertArrayEquals((Object[])expected, (Object[])variableNames.toArray(new String[variableNames.size()]));
        variableNames = DAPDownloader.getVariableNames((String)"");
        Assert.assertNull((Object)variableNames);
        variableNames = DAPDownloader.getVariableNames(null);
        Assert.assertNull((Object)variableNames);
        variableNames = DAPDownloader.getVariableNames((String)"someUnconstrainedVariable");
        expected = new String[]{"someUnconstrainedVariable"};
        Assert.assertArrayEquals((Object[])expected, (Object[])variableNames.toArray(new String[variableNames.size()]));
        variableNames = DAPDownloader.getVariableNames((String)"someUnconstrainedVariable,someConstrainedVariable[0:1:717][0:1:308]");
        expected = new String[]{"someUnconstrainedVariable", "someConstrainedVariable"};
        Assert.assertArrayEquals((Object[])expected, (Object[])variableNames.toArray(new String[variableNames.size()]));
    }

    @Test
    public void testFilterVariables() throws Exception {
        URL resource = this.getClass().getResource("test.nc");
        NetcdfFile netcdfFile = NetcdfFileOpener.open((Object)resource.toString());
        List variables = netcdfFile.getVariables();
        ArrayList<String> variableNames = new ArrayList<String>();
        for (Variable variable : variables) {
            variableNames.add(variable.getFullName());
        }
        String constraintExpression = null;
        List filteredVariables = DAPDownloader.filterVariables(variableNames, constraintExpression);
        Assert.assertEquals((long)2L, (long)filteredVariables.size());
        Assert.assertEquals((Object)"sst", filteredVariables.get(0));
        Assert.assertEquals((Object)"wind", filteredVariables.get(1));
        constraintExpression = "sst[0:1:10][0:1:10]";
        filteredVariables = DAPDownloader.filterVariables(variableNames, (String)constraintExpression);
        Assert.assertEquals((long)1L, (long)filteredVariables.size());
        Assert.assertEquals((Object)"sst", filteredVariables.get(0));
        constraintExpression = "bogusVariable[0:1:10][0:1:10]";
        filteredVariables = DAPDownloader.filterVariables(variableNames, (String)constraintExpression);
        Assert.assertEquals((long)2L, (long)filteredVariables.size());
        Assert.assertEquals((Object)"sst", filteredVariables.get(0));
        Assert.assertEquals((Object)"wind", filteredVariables.get(1));
        constraintExpression = "sst[0:1:10][0:1:10],wind[0:1:10][0:1:10]";
        filteredVariables = DAPDownloader.filterVariables(variableNames, (String)constraintExpression);
        Assert.assertEquals((long)2L, (long)filteredVariables.size());
        Assert.assertEquals((Object)"sst", filteredVariables.get(0));
        Assert.assertEquals((Object)"wind", filteredVariables.get(1));
        constraintExpression = "sst[0:1:10][0:1:10],wind[0:1:10][0:1:10],sst";
        filteredVariables = DAPDownloader.filterVariables(variableNames, (String)constraintExpression);
        Assert.assertEquals((long)2L, (long)filteredVariables.size());
        Assert.assertEquals((Object)"sst", filteredVariables.get(0));
        Assert.assertEquals((Object)"wind", filteredVariables.get(1));
    }

    @Test
    public void testFilterDimensions() throws Exception {
        URL resource = this.getClass().getResource("test.nc");
        NetcdfFile netcdfFile = NetcdfFileOpener.open((Object)resource.toString());
        ArrayList<String> variableNames = new ArrayList<String>();
        variableNames.add("sst");
        variableNames.add("wind");
        List dimensions = DAPDownloader.filterDimensions(variableNames, (NetcdfFile)netcdfFile);
        Collections.sort(dimensions);
        Assert.assertEquals((long)3L, (long)dimensions.size());
        Assert.assertEquals((Object)"COADSX", (Object)((Dimension)dimensions.get(0)).getShortName());
        Assert.assertEquals((Object)"COADSY", (Object)((Dimension)dimensions.get(1)).getShortName());
        Assert.assertEquals((Object)"TIME", (Object)((Dimension)dimensions.get(2)).getShortName());
        variableNames.clear();
        variableNames.add("wind");
        dimensions = DAPDownloader.filterDimensions(variableNames, (NetcdfFile)netcdfFile);
        Collections.sort(dimensions);
        Assert.assertEquals((long)2L, (long)dimensions.size());
        Assert.assertEquals((Object)"COADSX", (Object)((Dimension)dimensions.get(0)).getShortName());
        Assert.assertEquals((Object)"COADSY", (Object)((Dimension)dimensions.get(1)).getShortName());
        variableNames.clear();
        variableNames.add("sst");
        dimensions = DAPDownloader.filterDimensions(variableNames, (NetcdfFile)netcdfFile);
        Collections.sort(dimensions);
        Assert.assertEquals((Object)"COADSX", (Object)((Dimension)dimensions.get(0)).getShortName());
        Assert.assertEquals((Object)"COADSY", (Object)((Dimension)dimensions.get(1)).getShortName());
        Assert.assertEquals((Object)"TIME", (Object)((Dimension)dimensions.get(2)).getShortName());
    }

    @Test
    public void testGetOrigin() throws Exception {
        int[] origin = DAPDownloader.getOrigin((String)"sst", (String)"sst[0:1:10][0:1:10],wind[0:1:10][0:1:10]", (int)3);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 0}, (int[])origin);
        origin = DAPDownloader.getOrigin((String)"wind", (String)"sst[0:1:10][0:1:10],wind[0:1:10][0:1:10]", (int)2);
        Assert.assertArrayEquals((int[])new int[]{0, 0}, (int[])origin);
        origin = DAPDownloader.getOrigin((String)"sst", (String)"sst[5:1:10][10:1:10],wind[1:1:10][0:1:10]", (int)3);
        Assert.assertArrayEquals((int[])new int[]{5, 10, 0}, (int[])origin);
        origin = DAPDownloader.getOrigin((String)"sst", (String)"", (int)3);
        Assert.assertArrayEquals((int[])new int[]{0, 0, 0}, (int[])origin);
    }

    @Test
    public void testGetConstraintsExpressionForVariable() throws Exception {
        Assert.assertEquals((Object)"sst[0:1:10][0:1:10]", (Object)DAPDownloader.getConstraintExpression((String)"sst", (String)"sst[0:1:10][0:1:10],wind[0:1:10][0:1:10]"));
        Assert.assertEquals((Object)"wind[0:1:10][0:1:10]", (Object)DAPDownloader.getConstraintExpression((String)"wind", (String)"sst[0:1:10][0:1:10],wind[0:1:10][0:1:10]"));
        try {
            DAPDownloader.getConstraintExpression((String)"pig_density", (String)"sst[0:1:10][0:1:10],wind[0:1:10][0:1:10]");
            Assert.fail();
        }
        catch (IllegalArgumentException expected) {
            Assert.assertTrue((boolean)expected.getMessage().contains("must be included"));
        }
        Assert.assertEquals((Object)"sst[0:1:10]", (Object)DAPDownloader.getConstraintExpression((String)"sst", (String)"sst_flag[0:1:10][0:1:10],wind[0:1:10][0:1:10],sst[0:1:10]"));
        Assert.assertEquals((Object)"sst[0:1:10]", (Object)DAPDownloader.getConstraintExpression((String)"sst", (String)"flag_sst[0:1:10][0:1:10],wind[0:1:10][0:1:10],sst[0:1:10]"));
    }

    @Test
    public void testGetDownloadSpeed() {
        Assert.assertEquals((double)17.066666666666666, (double)DAPDownloader.getDownloadSpeed((long)60000L, (int)1024), (double)1.0E-4);
    }

    @Ignore
    @Test
    public void testActualWriting() throws Exception {
        DAPDownloader dapDownloader = new DAPDownloader(null, null, (DAPDownloader.DownloadContext)new NullDownloadContext(), (DownloadProgressBarPM)new NullLabelledProgressBarPM());
        DODSNetcdfFile sourceNetcdfFile = new DODSNetcdfFile("http://test.opendap.org:80/opendap/data/nc/coads_climatology.nc");
        dapDownloader.writeNetcdfFile(TESTDATA_DIR, "deleteme.nc", "", sourceNetcdfFile, false);
        File testFile = DAPDownloaderTest.getTestFile("deleteme.nc");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((boolean)NetcdfFile.canOpen((String)testFile.getAbsolutePath()));
        NetcdfFile netcdfFile = NetcdfFileOpener.open((Object)testFile.getAbsolutePath());
        Assert.assertNotNull((Object)netcdfFile.findVariable("SST"));
    }

    @Ignore
    @Test
    public void testActualWriting_WithConstraint() throws Exception {
        DAPDownloader dapDownloader = new DAPDownloader(null, null, (DAPDownloader.DownloadContext)new NullDownloadContext(), (DownloadProgressBarPM)new NullLabelledProgressBarPM());
        DODSNetcdfFile sourceNetcdfFile = new DODSNetcdfFile("http://test.opendap.org:80/opendap/data/nc/coads_climatology.nc");
        dapDownloader.writeNetcdfFile(TESTDATA_DIR, "deleteme.nc", "COADSX[0:1:4]", sourceNetcdfFile, false);
        File testFile = DAPDownloaderTest.getTestFile("deleteme.nc");
        Assert.assertTrue((boolean)testFile.exists());
        Assert.assertTrue((boolean)NetcdfFile.canOpen((String)testFile.getAbsolutePath()));
        NetcdfFile netcdfFile = NetcdfFileOpener.open((Object)testFile.getAbsolutePath());
        Assert.assertNull((Object)netcdfFile.findVariable("SST"));
        Assert.assertNotNull((Object)netcdfFile.findVariable("COADSX"));
    }

    static File getTestFile(String fileName) {
        return new File(TESTDATA_DIR, fileName);
    }

    private static class NullDownloadContext
    implements DAPDownloader.DownloadContext {
        private NullDownloadContext() {
        }

        public int getAllFilesCount() {
            return 0;
        }

        public int getAllDownloadedFilesCount() {
            return 0;
        }

        public void notifyFileDownloaded(File downloadedFile) {
        }

        public boolean mayOverwrite(String filename) {
            return true;
        }
    }

    private static class NullLabelledProgressBarPM
    extends DownloadProgressBarPM {
        public NullLabelledProgressBarPM() {
            super(null, null, null, null);
        }

        public void setPreMessage(String preMessageText) {
        }

        public void setPostMessage(String postMessageText) {
        }

        public int getTotalWork() {
            return 0;
        }

        public int getCurrentWork() {
            return 0;
        }

        public void setTooltip(String tooltip) {
        }

        public void beginTask(String taskName, int totalWork) {
        }

        public void done() {
        }

        public void internalWorked(double work) {
        }

        public boolean isCanceled() {
            return false;
        }

        public void setCanceled(boolean canceled) {
        }

        public void setTaskName(String taskName) {
        }

        public void setSubTaskName(String subTaskName) {
        }

        public void worked(int work) {
        }
    }
}

