/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import com.jidesoft.utils.Lm;
import java.util.GregorianCalendar;
import javax.swing.JCheckBox;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.TimeRangeFilter;
import org.esa.beam.util.TimeStampExtractor;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import thredds.catalog.InvDataset;
import ucar.nc2.units.DateRange;

public class TimeRangeFilterTest {
    @BeforeClass
    public static void setUp() throws Exception {
        Lm.verifyLicense((String)"Brockmann Consult", (String)"BEAM", (String)"lCzfhklpZ9ryjomwWxfdupxIcuIoCxg2");
    }

    @Test
    public void testAccept_UserStartFileStart() throws Exception {
        JCheckBox filterCheckBox = new JCheckBox();
        filterCheckBox.setSelected(true);
        TimeRangeFilter filter = new TimeRangeFilter(filterCheckBox);
        filter.startDate = new GregorianCalendar(2010, 0, 1, 12, 37, 15).getTime();
        filter.endDate = null;
        filter.timeStampExtractor = new TimeStampExtractor("yyyyMMdd:hhmmss", "*${startDate}*");
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("sth__20100101:192345.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20091231:192345.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("does_not_match_naming_pattern", TimeRangeFilterTest.createNullDataset())));
    }

    @Test
    public void testAccept_UserStartFileBoth() throws Exception {
        JCheckBox filterCheckBox = new JCheckBox();
        filterCheckBox.setSelected(true);
        TimeRangeFilter filter = new TimeRangeFilter(filterCheckBox);
        filter.startDate = new GregorianCalendar(2010, 0, 1, 12, 37, 15).getTime();
        filter.endDate = null;
        filter.timeStampExtractor = new TimeStampExtractor("yyyyMMdd:hhmmss", "*${startDate}*${endDate}*");
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("sth__20100101:192345___20100102:012345__.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20091231:192345___20100102:012345__.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20091231:192345___20091231:233012__.nc", TimeRangeFilterTest.createNullDataset())));
    }

    @Test
    public void testAccept_UserEndFileStart() throws Exception {
        JCheckBox filterCheckBox = new JCheckBox();
        filterCheckBox.setSelected(true);
        TimeRangeFilter filter = new TimeRangeFilter(filterCheckBox);
        filter.startDate = null;
        filter.endDate = new GregorianCalendar(2010, 0, 2, 12, 37, 15).getTime();
        filter.timeStampExtractor = new TimeStampExtractor("yyyyMMdd:hhmmss", "*${startDate}*");
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("sth__20080101:192345.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20111231:192345.nc", TimeRangeFilterTest.createNullDataset())));
    }

    @Test
    public void testAccept_UserEndFileBoth() throws Exception {
        TimeRangeFilter filter = new TimeRangeFilter(new JCheckBox());
        filter.startDate = null;
        filter.endDate = new GregorianCalendar(2010, 0, 2, 12, 37, 15).getTime();
        filter.timeStampExtractor = new TimeStampExtractor("yyyyMMdd:hhmmss", "*${startDate}*${endDate}*");
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("sth__20100101:192345___20100102:012345__.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20091231:192345___20100103:012345__.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20100103:192345___20100103:233012__.nc", TimeRangeFilterTest.createNullDataset())));
    }

    @Test
    public void testAccept_UserBothFileStart() throws Exception {
        TimeRangeFilter filter = new TimeRangeFilter(new JCheckBox());
        filter.startDate = new GregorianCalendar(2010, 0, 1, 12, 37, 15).getTime();
        filter.endDate = new GregorianCalendar(2010, 0, 2, 12, 37, 15).getTime();
        filter.timeStampExtractor = new TimeStampExtractor("yyyyMMdd:hhmmss", "*${startDate}*");
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("sth__20100101:192345.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20091231:192345.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20111231:192345.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("does_not_match_naming_pattern", TimeRangeFilterTest.createNullDataset())));
    }

    private static InvDataset createNullDataset() {
        return new InvDataset(null, ""){};
    }

    @Test
    public void testAccept_UserBothFileBoth() throws Exception {
        TimeRangeFilter filter = new TimeRangeFilter(new JCheckBox());
        filter.startDate = new GregorianCalendar(2010, 0, 1, 12, 37, 15).getTime();
        filter.endDate = new GregorianCalendar(2010, 0, 2, 12, 37, 15).getTime();
        filter.timeStampExtractor = new TimeStampExtractor("yyyyMMdd:hhmmss", "*${startDate}*${endDate}*");
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("sth__20100101:192345___20100102:012345__.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20091231:192345___20100102:012345__.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20100101:192345___20100103:012345__.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20091231:192345___20100103:012345__.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20091231:192345___20091231:233012__.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertFalse((boolean)filter.accept(new OpendapLeaf("sth__20100103:004523___20100103:012345__.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("sth__20100101:192345_does_not_match_naming_pattern.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("sth__20100104:192345_does_not_match_naming_pattern.nc", TimeRangeFilterTest.createNullDataset())));
        Assert.assertTrue((boolean)filter.accept(new OpendapLeaf("does_not_match_naming_pattern", TimeRangeFilterTest.createNullDataset())));
    }

    @Test
    public void testAccept_ServerSpecifiedTimeRange() throws Exception {
        TimeRangeFilter filter = new TimeRangeFilter(new JCheckBox());
        filter.startDate = new GregorianCalendar(2010, 0, 1).getTime();
        filter.endDate = new GregorianCalendar(2010, 0, 2).getTime();
        OpendapLeaf leaf = this.createLeaf();
        Assert.assertFalse((boolean)filter.accept(leaf));
        filter.startDate = new GregorianCalendar(2010, 0, 1).getTime();
        filter.endDate = new GregorianCalendar(2011, 0, 2).getTime();
        Assert.assertTrue((boolean)filter.accept(leaf));
        filter.startDate = new GregorianCalendar(2010, 0, 2).getTime();
        filter.endDate = null;
        Assert.assertFalse((boolean)filter.accept(leaf));
        filter.startDate = null;
        filter.endDate = new GregorianCalendar(2010, 11, 31).getTime();
        Assert.assertFalse((boolean)filter.accept(leaf));
        filter.startDate = new GregorianCalendar(2009, 11, 31).getTime();
        filter.endDate = null;
        Assert.assertTrue((boolean)filter.accept(leaf));
        filter.startDate = null;
        filter.endDate = new GregorianCalendar(2011, 11, 31).getTime();
        Assert.assertTrue((boolean)filter.accept(leaf));
    }

    private OpendapLeaf createLeaf() {
        return new OpendapLeaf("", new InvDataset(null, ""){

            public DateRange getTimeCoverage() {
                return new DateRange(new GregorianCalendar(2010, 0, 1).getTime(), new GregorianCalendar(2011, 0, 1).getTime());
            }
        });
    }
}

