/*
 * Decompiled with CFR 0.152.
 */
package org.esa.beam.opendap.ui;

import com.bc.ceres.binding.Property;
import com.bc.ceres.binding.PropertyAccessor;
import com.bc.ceres.binding.PropertyDescriptor;
import com.bc.ceres.binding.ValidationException;
import com.bc.ceres.binding.accessors.DefaultPropertyAccessor;
import javax.swing.JCheckBox;
import org.esa.beam.opendap.datamodel.OpendapLeaf;
import org.esa.beam.opendap.ui.RegionFilter;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog.InvDataset;
import thredds.catalog.ThreddsMetadata;
import ucar.unidata.geoloc.LatLonPoint;
import ucar.unidata.geoloc.LatLonPointImpl;
import ucar.unidata.geoloc.LatLonRect;

public class RegionFilterTest {
    private RegionFilter regionFilter;

    @Before
    public void setUp() throws ValidationException {
        this.regionFilter = new RegionFilter(new JCheckBox());
        this.regionFilter.eastBoundProperty = new Property(new PropertyDescriptor("east", Double.class), (PropertyAccessor)new DefaultPropertyAccessor());
        this.regionFilter.westBoundProperty = new Property(new PropertyDescriptor("west", Double.class), (PropertyAccessor)new DefaultPropertyAccessor());
        this.regionFilter.northBoundProperty = new Property(new PropertyDescriptor("north", Double.class), (PropertyAccessor)new DefaultPropertyAccessor());
        this.regionFilter.southBoundProperty = new Property(new PropertyDescriptor("south", Double.class), (PropertyAccessor)new DefaultPropertyAccessor());
        this.regionFilter.eastBoundProperty.setValue((Object)20.0);
        this.regionFilter.westBoundProperty.setValue((Object)-10.0);
        this.regionFilter.northBoundProperty.setValue((Object)50.0);
        this.regionFilter.southBoundProperty.setValue((Object)-70.0);
    }

    @Test
    public void testAccept() throws Exception {
        OpendapLeaf opendapLeafFullyInside = this.createLeaf(45.0, -8.0, -68.0, 19.0);
        OpendapLeaf opendapLeafGoingHorizontallyThroughBox = this.createLeaf(89.0, -1.0, -89.0, 1.0);
        OpendapLeaf opendapLeafGoingVerticallyThroughBox = this.createLeaf(45.0, -179.0, -68.0, 179.0);
        OpendapLeaf opendapLeafContainingOneEdge = this.createLeaf(55.0, -12.0, 45.0, -8.0);
        OpendapLeaf opendapLeafWholeWorld = this.createLeaf(90.0, -180.0, -90.0, 180.0);
        OpendapLeaf opendapLeafAbove = this.createLeaf(90.0, -180.0, 80.0, 180.0);
        OpendapLeaf opendapLeafRight = this.createLeaf(90.0, 30.0, -90.0, 180.0);
        OpendapLeaf opendapLeafBelow = this.createLeaf(-80.0, -180.0, -90.0, 180.0);
        OpendapLeaf opendapLeafLeft = this.createLeaf(90.0, -180.0, -90.0, -11.0);
        Assert.assertTrue((boolean)this.regionFilter.accept(opendapLeafFullyInside));
        Assert.assertTrue((boolean)this.regionFilter.accept(opendapLeafGoingHorizontallyThroughBox));
        Assert.assertTrue((boolean)this.regionFilter.accept(opendapLeafGoingVerticallyThroughBox));
        Assert.assertTrue((boolean)this.regionFilter.accept(opendapLeafContainingOneEdge));
        Assert.assertTrue((boolean)this.regionFilter.accept(opendapLeafWholeWorld));
        Assert.assertFalse((boolean)this.regionFilter.accept(opendapLeafAbove));
        Assert.assertFalse((boolean)this.regionFilter.accept(opendapLeafRight));
        Assert.assertFalse((boolean)this.regionFilter.accept(opendapLeafBelow));
        Assert.assertFalse((boolean)this.regionFilter.accept(opendapLeafLeft));
    }

    private OpendapLeaf createLeaf(final double upperLeftLat, final double upperLeftLon, final double bottomRightLat, final double bottomRightLon) {
        return new OpendapLeaf("", new InvDataset(null, ""){

            public ThreddsMetadata.GeospatialCoverage getGeospatialCoverage() {
                ThreddsMetadata.GeospatialCoverage geospatialCoverage = new ThreddsMetadata.GeospatialCoverage();
                geospatialCoverage.setBoundingBox(new LatLonRect((LatLonPoint)new LatLonPointImpl(upperLeftLat, upperLeftLon), (LatLonPoint)new LatLonPointImpl(bottomRightLat, bottomRightLon)));
                return geospatialCoverage;
            }
        });
    }
}

